* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* **          MATHEMATICAL ANALYSIS BY JOHN SNYDER                    **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                     *  LAMBERT CONFORMAL CONIC  *
* **********************************************************************
*
      SUBROUTINE PJ04Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,I,ZONE,IPFILE,IFLG
      CHARACTER*16 ANGS(4)
      COMMON /ELLPZ0/ AZ,EZ,ESZ,E0Z,E1Z,E2Z,E3Z,E4Z
* **** PARAMETERS **** A,E,ES,LAT1,LAT2,LON0,LAT0,X0,Y0,NS,F,RH0 *******
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DATA HALFPI /1.57079632679489661923D0/
      DATA EPSLN /1.0D-10/
      DATA ZERO,ONE /0.0D0,1.0D0/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS04Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      IF (DATA(1) .LE. ZERO) GO TO 100
      A = DATA(1)
      B = DATA(2)
      IF (B .GT. ZERO) GO TO 040
      E = ZERO
      ES = ZERO
      GO TO 120
  040 IF (B .GT. ONE) GO TO 060
      E = DSQRT (B)
      ES = B
      GO TO 120
  060 ES = ONE - (B / A) ** 2
      E = DSQRT (ES)
      GO TO 120
  100 A = AZ
      E = EZ
      ES = ESZ
  120 CALL UNITZ0 (DATA(3),5,LAT1,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(4),5,LAT2,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      IF (DABS(LAT1+LAT2) .GE. EPSLN) GO TO 130
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000)
 2000 FORMAT (' EQUAL LATITUDES FOR ST. PARALLELS ON OPPOSITE',
     .        ' SIDES OF EQUATOR')
      IFLG = 401
      RETURN
  130 CALL UNITZ0 (DATA(5),5,LON0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(6),5,LAT0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      X0 = DATA(7)
      Y0 = DATA(8)
      SINPHI = DSIN (LAT1)
      CON = SINPHI
      COSPHI = DCOS (LAT1)
      MS1 = MSFNZ0 (E,SINPHI,COSPHI)
      TS1 = TSFNZ0 (E,LAT1,SINPHI)
      SINPHI = DSIN (LAT2)
      COSPHI = DCOS (LAT2)
      MS2 = MSFNZ0 (E,SINPHI,COSPHI)
      TS2 = TSFNZ0 (E,LAT2,SINPHI)
      SINPHI = DSIN (LAT0)
      TS0 = TSFNZ0 (E,LAT0,SINPHI)
      IF (DABS(LAT1-LAT2) .GE. EPSLN) GO TO 140
      NS = CON
      GO TO 150
  140 NS = DLOG (MS1 / MS2) / DLOG (TS1 / TS2)
  150 F = MS1 / (NS * TS1 ** NS)
      RH0 = A * F * TS0 ** NS
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
      CALL DMSLZ0 (LAT1,0,ANGS(1),IPFILE,IFLG)
      CALL DMSLZ0 (LAT2,0,ANGS(2),IPFILE,IFLG)
      CALL DMSLZ0 (LON0,0,ANGS(3),IPFILE,IFLG)
      CALL DMSLZ0 (LAT0,0,ANGS(4),IPFILE,IFLG)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010) A,ES,ANGS,X0,Y0
 2010 FORMAT (' INITIALIZATION PARAMETERS (LAMBERT CONFORMAL CONIC',
     .        ' PROJECTION)'/
     .        ' SEMI-MAJOR AXIS OF ELLIPSOID =',F16.4,' METERS'/
     .        ' ECCENTRICITY SQUARED         =',F16.13/
     .        ' LATITUDE OF 1ST ST. PARALLEL =',A16/
     .        ' LATITUDE OF 2ND ST. PARALLEL =',A16/
     .        ' LONGITUDE OF ORIGIN          =',A16/
     .        ' LATITUDE OF ORIGIN           =',A16/
     .        ' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
      SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF04Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 200
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
 2020 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 400
      RETURN
  200 CON = DABS (DABS (GEOG(2)) - HALFPI)
      IF (CON .GT. EPSLN) GO TO 220
      CON = GEOG(2) * NS
      IF (CON .GT. ZERO) GO TO 210
      IF (IPFILE .NE. 0) WRITE (IPFILE,2030)
 2030 FORMAT (' POINT CANNOT BE PROJECTED')
      IFLG = 402
      RETURN
  210 RH = ZERO
      GO TO 230
  220 SINPHI = DSIN (GEOG(2))
      TS = TSFNZ0 (E,GEOG(2),SINPHI)
      RH = A * F * TS ** NS
  230 THETA = NS * ADJLZ0 (GEOG(1) - LON0)
      PROJ(1) = X0 + RH * DSIN (THETA)
      PROJ(2) = Y0 + RH0 - RH * DCOS (THETA)
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI04Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 240
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
      IFLG = 400
      RETURN
  240 X = PROJ(1) - X0
      Y = RH0 - PROJ(2) + Y0
      RH = DSIGN (DSQRT (X*X + Y*Y) , NS)
      THETA = ZERO
      CON = DSIGN (ONE , NS)
      IF (RH .NE. ZERO) THETA = DATAN2 (CON * X , CON * Y)
      IF (RH.NE.ZERO .OR. NS.GT.ZERO) GO TO 250
      GEOG(2) = - HALFPI
      GO TO 260
  250 CON = ONE / NS
      TS = (RH / (A * F)) ** CON
      GEOG(2) = PHI2Z0 (E,TS,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
  260 GEOG(1) = ADJLZ0 (THETA / NS + LON0)
      RETURN
*
      END
