/* $Id: event.c,v 1.15 1993/04/18 17:11:01 bjoerns Exp $
 *
 *	This file is part of the XPilot project, written by
 *
 *	    Bjrn Stabell (bjoerns@staff.cs.uit.no)
 *	    Ken Ronny Schouten (kenrsc@stud.cs.uit.no)
 *
 *	Copylefts are explained in the LICENSE file.
 */

#include <X11/Xproto.h>
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/keysym.h>
#ifdef	apollo
#    include <X11/ap_keysym.h>
#endif

#include "global.h"
#include "score.h"
#include "map.h"
#include "sound.h"

#ifndef	lint
static char sourceid[] =
    "@(#)$Id: event.c,v 1.15 1993/04/18 17:11:01 bjoerns Exp $";
#endif

#define SWAP(_a, _b)	    {float _tmp = _a; _a = _b; _b = _tmp;}

#define CONTROL_DELAY	100


/*
 * Globals.
 */
static char		msg[MSG_LEN];



void Refuel(int ind)
{
    player *pl = Players[ind];
    int i, min = -1;
    float l, min_dist=FLT_MAX;


    if (!BIT(pl->have, OBJ_REFUEL))
	return;

    for (i=0; i<World.NumFuels; i++) {
	l = Wrap_length(pl->pos.x - World.fuel[i].pos.x, 
			pl->pos.y - World.fuel[i].pos.y);
	if (min_dist > l) {
	    min_dist = l;
	    min = i;
	}
    }

    if (min >= 0) {
	sound_play_player(pl, REFUEL_SOUND);
	SET_BIT(pl->used, OBJ_REFUEL);
	pl->fs = min;
    }
}


static keys_t Lookup_key(KeySym ks, player *pl, bool reset)
{
    keys_t ret = KEY_DUMMY;
    static int i = 0;

    if (reset)
	i = 0;

    while (i < MAX_KEY_DEFS && pl->keyDefs[i].key) {
	if (pl->keyDefs[i].keysym == ks) {
	    ret = pl->keyDefs[i].key;
	    i++;
	    break;
	} else {
	    i++;
	}
    }

    return (ret);
}


void Key_event(int ind, XEvent *event)
{
    KeySym  	KS;
    int	    	i, xi, yi, min_ind;
    player  	*pl;
    float  	min, l;
    keys_t	key;
    bool	first_iteration = True;


    pl = Players[ind];
    KS = XLookupKeysym(&(event->xkey), 0);

    while ((key = Lookup_key(KS, pl, first_iteration)) != KEY_DUMMY) {
	first_iteration = False;

	if (!BIT(pl->status, PLAYING))	/* Allow these functions */
	    switch (key) {		/* while you're 'dead'. */
	    case KEY_PAUSE:
	    case KEY_LOCK_NEXT:
	    case KEY_LOCK_PREV:
	    case KEY_ID_MODE:
	    case KEY_TOGGLE_VELOCITY:
	    case KEY_TOGGLE_COMPASS:
	    case KEY_SWAP_SETTINGS:
	    case KEY_INCREASE_POWER:
	    case KEY_DECREASE_POWER:
	    case KEY_INCREASE_TURNSPEED:
	    case KEY_DECREASE_TURNSPEED:
	    case KEY_TANK_NEXT:
	    case KEY_TANK_PREV:
	    case KEY_TURN_LEFT:	/* Needed so that we don't get */
	    case KEY_TURN_RIGHT: /* out-of-sync with the turnacc */
		break;
	    default:
		continue;
	    }


	if (event->type == KeyPress) { /* --- KEYPRESS --- */
	    switch (key) {

	    case KEY_TANK_NEXT:
	    case KEY_TANK_PREV:
		if (pl->fuel.num_tanks) {
		    pl->fuel.current += (key==KEY_TANK_NEXT) ? 1 : -1;
		    pl->fuel.count = FUEL_NOTIFY;
		    if (pl->fuel.current < 0)
			pl->fuel.current = pl->fuel.num_tanks;
		    else if (pl->fuel.current > pl->fuel.num_tanks)
			pl->fuel.current = 0;
		}
		break;

	    case KEY_TANK_DETACH:
		Tank_handle_detach(pl);
		break;

	    case KEY_LOCK_NEXT:
	    case KEY_LOCK_PREV:
		i = GetInd[pl->lock.pl_id];
		if (NumPlayers > 1)
		    do {
			if (key == KEY_LOCK_PREV)
			    i--;
			else
			    i++;
			i = mod(i, NumPlayers);
			pl->lock.pl_id = Players[i]->id;
			pl->lock.tagged = LOCK_PLAYER;
		    } while (i == ind);
		break;

	    case KEY_LOCK_CLOSE:
		min = FLT_MAX;
		for (i=0; i<NumPlayers; i++) {
		    if (TEAM(ind, i) || !BIT(Players[i]->status, PLAYING))
			continue;
		    l = Wrap_length(Players[i]->pos.x - pl->pos.x,
				    Players[i]->pos.y - pl->pos.y);
		    if (l < min && i != ind) {
			min = l;
			min_ind = i;
		    }
		}
		if (min < FLT_MAX) {
		    pl->lock.pl_id = Players[min_ind]->id;
		    pl->lock.tagged = LOCK_PLAYER;
		} else
		    pl->lock.tagged = LOCK_NONE;
		break;

	    case KEY_CHANGE_HOME:
		xi = (int)pl->pos.x / BLOCK_SZ;
		yi = (int)pl->pos.y / BLOCK_SZ;
		if (World.block[xi][yi] == BASE) {
		    msg[0] = '\0';
		    for (i=0; i<World.NumBases; i++) {
			if (World.base[i].pos.x == xi
			    && World.base[i].pos.y == yi
			    && i != pl->home_base) {

			    if (World.base[i].team != TEAM_NOT_SET
				&& World.base[i].team != pl->team)
				break;
			    pl->home_base = i;
			    sprintf(msg, "%s has changed home base.",
				    pl->name);
			    break;
			}
		    }
		    for (i=0; i<NumPlayers; i++)
			if (i != ind
			    && pl->home_base == Players[i]->home_base) {
			    Pick_startpos(i);
			    sprintf(msg, "%s has taken over %s's home base.",
				    pl->name, Players[i]->name);
			}
		    if (msg[0])
		    {
			sound_play_all(CHANGE_HOME_SOUND);
			Set_message(msg);
		    }
		}
		break;

	    case KEY_SHIELD:
		if (BIT(pl->have, OBJ_SHIELD))
		    SET_BIT(pl->used, OBJ_SHIELD);
		break;

	    case KEY_DROP_BALL:
		if (BIT(pl->have, OBJ_BALL)) {
		    i=0;
		    while (i < NumObjs &&  pl->id != Obj[i]->id 
			   && Obj[i]->type == OBJ_BALL)
			i++;
		    Obj[i]->id = -1;
		    CLR_BIT(pl->have, OBJ_BALL);
		}
		break;

	    case KEY_FIRE_SHOT:
		Fire_shot(ind, OBJ_SHOT, pl->dir);
		for (i=0; i<pl->extra_shots; i++) {
		    Fire_shot(ind, OBJ_SHOT,
			      MOD2(pl->dir + (1+i)*SHOTS_ANGLE, RES));
		    Fire_shot(ind, OBJ_SHOT,
			      MOD2(pl->dir - (1+i)*SHOTS_ANGLE, RES));
		}
		for (i=0; i<pl->rear_shots; i++) {
		    Fire_shot(ind, OBJ_SHOT,
			      MOD2(pl->dir + RES/2
				   + (pl->rear_shots-1 - 2*i) * SHOTS_ANGLE/2,
				   RES));
		}
		break;

	    case KEY_FIRE_MISSILE:
		if (pl->missiles > 0)
		    Fire_shot(ind, OBJ_SMART_SHOT, pl->dir);
		break;

	    case KEY_FIRE_HEAT:
		if (pl->missiles > 0)
		    Fire_shot(ind, OBJ_HEAT_SHOT, pl->dir);

		break;

	    case KEY_FIRE_TORPEDO:
		if (pl->missiles > 0)
		    Fire_shot(ind, OBJ_TORPEDO, pl->dir);

		break;

            case KEY_FIRE_NUKE:
		if (BIT(World.rules->mode, ALLOW_NUKES)
		    && pl->missiles > NUKE_MIN_SMART) {
		    Fire_shot(ind, OBJ_NUKE, pl->dir);
		    sprintf(msg, "%s has launched a nuke!", pl->name);
		    Set_message(msg);
		}
		break;

	    case KEY_DROP_MINE:
		if (pl->mines > 0) {
		    Place_mine(ind);
		    pl->mines--;
		}
		break;

	    case KEY_DETACH_MINE:
		if (pl->mines > 0) {
		    Place_moving_mine(ind, pl->vel.x,pl->vel.y);
		    pl->mines--;
		}
		break;

	    case KEY_TURN_LEFT:
		pl->turnacc += pl->turnspeed;
		break;
	    
	    case KEY_TURN_RIGHT:
		pl->turnacc -= pl->turnspeed;
		break;

	    case KEY_SELF_DESTRUCT:
		TOGGLE_BIT(pl->status, SELF_DESTRUCT);
		if (BIT(pl->status, SELF_DESTRUCT))
		    pl->count = 150;
		break;

	    case KEY_ID_MODE:
		TOGGLE_BIT(pl->status, ID_MODE);
		break;

	    case KEY_PAUSE:
		xi = (int)pl->pos.x / BLOCK_SZ;
		yi = (int)pl->pos.y / BLOCK_SZ;
		if ((pl->velocity < (0.5 + LENGTH(World.gravity[xi][yi].x,
						  World.gravity[xi][yi].y)))
		    && (World.base[pl->home_base].pos.x == xi
			&& World.base[pl->home_base].pos.y == yi)) {
		    if (!BIT(pl->status, PAUSE)) { /* Turn pause mode on */
			pl->count = MIN_PAUSE;
			SET_BIT(pl->status, PAUSE);
			CLR_BIT(pl->status, SELF_DESTRUCT|PLAYING);
		    } else
			if (pl->count <= 0) {
			    CLR_BIT(pl->status, PAUSE);
			    if (!BIT(pl->status, GAME_OVER))
				SET_BIT(pl->status, PLAYING);
			}
		}
		break;
		
	    case KEY_TOGGLE_VELOCITY:
		TOGGLE_BIT(pl->status, VELOCITY_GAUGE);
		break;

	    case KEY_TOGGLE_COMPASS:
		if (!BIT(pl->have, OBJ_COMPASS))
		    break;
		TOGGLE_BIT(pl->used, OBJ_COMPASS);
		if (BIT(pl->used, OBJ_COMPASS))
		    if (NumPlayers > 1) {
			pl->lock.tagged = LOCK_PLAYER;
		    } else
			pl->lock.tagged = LOCK_NONE;
		break;

	    case KEY_SWAP_SETTINGS:
		if (pl->turnacc == 0.0) {
		    SWAP(pl->power, pl->power_s);
		    SWAP(pl->turnspeed, pl->turnspeed_s);
		    SWAP(pl->turnresistance, pl->turnresistance_s);
		}
		pl->control_count = CONTROL_DELAY;
		break;

	    case KEY_REFUEL:
		pl->fuel.count = FUEL_NOTIFY;
		Refuel(ind);
		break;

	    case KEY_CONNECTOR:
		if (BIT(pl->have, OBJ_CONNECTOR))
		    SET_BIT(pl->used, OBJ_CONNECTOR);
		break;

	    case KEY_INCREASE_POWER:
		pl->power *= 1.10;
		pl->power = MIN(pl->power, MAX_PLAYER_POWER);
		pl->control_count = CONTROL_DELAY;
		break;

	    case KEY_DECREASE_POWER:
		pl->power *= 0.90;
		pl->power=MAX(pl->power, MIN_PLAYER_POWER);
		pl->control_count = CONTROL_DELAY;
		break;

	    case KEY_INCREASE_TURNSPEED:
		if (pl->turnacc == 0.0)
		    pl->turnspeed *= 1.05;
		pl->turnspeed = MIN(pl->turnspeed, MAX_PLAYER_TURNSPEED);
		pl->control_count = CONTROL_DELAY;
		break;

	    case KEY_DECREASE_TURNSPEED:
		if (pl->turnacc == 0.0)
		    pl->turnspeed *= 0.95;
		pl->turnspeed = MAX(pl->turnspeed, MIN_PLAYER_TURNSPEED);
		pl->control_count = CONTROL_DELAY;
		break;
		/*
		   case XK_KP_0:
		   case XK_0:
		   if (BIT(pl->used, OBJ_TRAINER))
		   pl->vel.x = pl->vel.y = 0.0;
		   pl->turnacc = 0.0;
		   break;
		   */
	    case KEY_THRUST:
		SET_BIT(pl->status, THRUSTING);
		break;

	    case KEY_CLOAK:
		if (pl->cloaks > 0)
		    {
			sound_play_player(pl, CLOAK_SOUND);
			pl->updateVisibility = 1;
			TOGGLE_BIT(pl->used, OBJ_CLOAKING_DEVICE);
		    }
		break;

	    case KEY_ECM:
		if (pl->ecms > 0 && pl->fuel.sum > -ED_ECM)
		    {
			SET_BIT(pl->used, OBJ_ECM);
			do_ecm(pl);
			pl->ecms--;
			Add_fuel(&(pl->fuel), ED_ECM);
		    }
		break;

#ifdef	CHEAT
	    case XK_KP_F1:
		if (!BIT(pl->have, OBJ_TRAINER))
		    continue;
		if (BIT(pl->used, OBJ_TRAINER)) {
		    SET_BIT(pl->status, GRAVITY);
		    sprintf(msg, "%s is no longer a cheater.", pl->name);
		    Set_message(msg);
		    pl->mychar=' ';
		} else {
		    sprintf(msg, "%s has become a cheater.", pl->name);
		    Set_message(msg);
		    pl->mychar='C';
		}
		TOGGLE_BIT(pl->used, OBJ_TRAINER);
		updateScores = true;
		break;

	    case XK_KP_F4:
		if (!BIT(pl->have, OBJ_TRAINER))
		    continue;
		if (BIT(pl->used, OBJ_TRAINER)) {
		    SET_BIT(pl->status, GRAVITY);
		    sprintf(msg, "%s has reentered our dimension.", pl->name);
		    Set_message(msg);
		    pl->mychar = ' ';
		} else {
		    CLR_BIT(pl->status, GRAVITY);
		    sprintf(msg, "%s has entered the twilight zone.",
			    pl->name);
		    Set_message(msg);
		    pl->mychar = 'T';
		}
		TOGGLE_BIT(pl->used, OBJ_TRAINER);
		updateLables = true;
		break;

	    case XK_KP_Tab:
		pl->mines += 100;
		break;
	    case XK_KP_Enter:
		pl->missiles += 100;
		break;
	    case XK_KP_Separator:
		pl->extra_shots += 5;
		break;
	    case XK_KP_Decimal:
		pl->fuel = pl->max_fuel;
		break;
#endif

	    default:
		break;
	    }
	}


	else if (event->type == KeyRelease) { /* --- KEYRELEASE --- */
	    switch (key) {
	    case KEY_TURN_LEFT:
		pl->turnacc -= pl->turnspeed;
		break;

	    case KEY_TURN_RIGHT:
		pl->turnacc += pl->turnspeed;
		break;

	    case KEY_REFUEL:
		CLR_BIT(pl->used, OBJ_REFUEL);
		pl->fuel.count = FUEL_NOTIFY;
		break;

	    case KEY_CONNECTOR:
		CLR_BIT(pl->used, OBJ_CONNECTOR);
		break;

	    case KEY_SHIELD:
		CLR_BIT(pl->used, OBJ_SHIELD);
		break;

	    case KEY_THRUST:
		CLR_BIT(pl->status, THRUSTING);
		break;

	    default:
		break;
	    }
	}
    }
}
