;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Emacs-Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;
;; emp-option.el -- Support for customization of Gnu Emacs Empire Tool (GEET)
;; 
;; Copyright (c) 1990 Lynn Randolph Slater, Jr
;; 
;; Created On      : Sun Oct 28 14:54:16 1990
;; Last Modified By: Lynn Slater x2048
;; Last Modified On: Thu Feb 14 19:17:07 1991
;; Update Count    : 40
;; Status          : GEET General Release 2d Patch 0
;; 
;; HISTORY
;; 4-Feb-1991		Lynn Slater x2048	
;;    Last Modified: Mon Feb  4 11:40:35 1991 #33 (Lynn Slater x2048)
;;    made hooks buffer be ordered
;; 6-Nov-1990		Lynn Slater	
;;    Last Modified: Tue Nov  6 09:14:46 1990 #12 (Lynn Slater)
;;    took out load of options mode
;; PURPOSE
;; 	This file contains code that empire uses but which SHOULD be in
;; options.el. Nothing in this file is special to empire.
;; TABLE OF CONTENTS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The contents of this file ARE copyrighted but permission to use, modify,
;; and distribute this code is granted as described in the file
;; emp-install.el which should have been distributed with this file. These
;; terms constitute what the Free Software Foundation calls a COPYLEFT.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(provide 'emp-option)

(defun edit-hooks (hook-list-name all-possible-hooks bname &optional label)
  "Display a buffer with ALL-POSSIBLE-HOOKS and their documentation with those
hooks listed in HOOK-LIST-NAME shown as enabled. Change the value of
HOOK-LIST-NAME as the user directs."
  (save-excursion
    (set-buffer (get-buffer-create bname))
    (Edit-hooks-mode hook-list-name))
  (with-output-to-temp-buffer bname
    (if label (progn (princ label) (terpri)))

    (princ (format "\nStored in Variable '%s and documented as:\n\n" hook-list-name))
    (princ (substitute-command-keys 
		  (documentation-property hook-list-name 'variable-documentation)))
    (princ "\n\n")
    
    (let* ((actual-hooks (eval hook-list-name))
	   (hook-order actual-hooks))
      (mapcar '(lambda (hook)
		 (if (not (memq hook hook-order))
		     (setq hook-order
			   (nconc hook-order (list hook)))))
	      all-possible-hooks)
      
      (while hook-order
	(let ((sym (car hook-order)))
	  (princ "\n;; ")
	  (prin1 sym)
	  (princ "\t")
	  (princ (if (memq sym actual-hooks) "Enabled" "Disabled"))
	  (terpri)
	  (if (fboundp sym)
	      (princ (substitute-command-keys 
		      (documentation sym)))
	    (princ "This unknown function is not yet available."))
	  (princ "\n"))
	(setq hook-order (cdr hook-order)))
      (terpri)
      )
    ))

(defvar Edit-hooks-mode-map
  (let ((map (make-keymap)))
    (define-key map "x" 'Edit-hooks-toggle)
    (define-key map "t" 'Edit-hooks-toggle)
    (define-key map "p" 'backward-paragraph)
    (define-key map " " 'forward-paragraph)
    (define-key map "n" 'forward-paragraph)
    map)
  "")

;; Edit Options mode is suitable only for specially formatted data.
(put 'Edit-hooks-mode 'mode-class 'special)

(defun Edit-hooks-mode (hook-list-name) ;; based on edit-options mode
  "Major mode for editing Emacs user hook settings.
The hooks are shown in the order they will execute.

Special commands are:
x,t -- toggle whether this function is in the hook list.
  if the fcn goes on the list, it goes in at the beginning.
n,p -- Move to next or previous hook
"
  (kill-all-local-variables)
  (set-syntax-table emacs-lisp-mode-syntax-table)
  (use-local-map Edit-hooks-mode-map)
  (make-local-variable 'paragraph-separate)
  (setq paragraph-separate "^;; ")
  (make-local-variable 'paragraph-start)
  (setq paragraph-start "^;; ")
  (setq truncate-lines t)
  (make-local-variable 'hook-list)
  (setq hook-list hook-list-name)
  (setq major-mode 'Edit-hooks-mode)
  (setq mode-name "Hooks"))

(defun Edit-hooks-toggle () (interactive)
  (let (var pos doc)
    (end-of-line)
    (re-search-backward "^;; ")
    (forward-char 3)
    (setq pos (point))
    (save-restriction
      (narrow-to-region pos (progn (end-of-line) (1- (point))))
      (goto-char pos)
      (setq var (read (current-buffer))))
    (setq pos (- pos 3))
    
    (delete-region (point) (progn (end-of-line) (point)))
    (if (memq var (eval hook-list))
	(progn
	  (set hook-list (delq var (eval hook-list)))
	  (insert "Disabled")
	  )
      (set hook-list (cons var (eval hook-list)))
      (insert "Enabled")
      )
    (forward-paragraph)
    (setq doc (buffer-substring pos (point)))
    (delete-region pos (point))
    (if (memq var (eval hook-list))
	(progn
	  (beginning-of-buffer)
	  (forward-paragraph 1)
	  (insert doc)
	  )
      (save-excursion
      (end-of-buffer)
      (insert doc))
      )
    (message "Hooks are %s" (eval hook-list))
    ))

