#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/update/RCS/mobility.c,v 1.2 89/09/03 17:08:43 mr-frog Exp $";
#endif

/*
 * mobility.c
 *
 * Add mobility to each of the items which accumlate mobility.
 * 
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "nat.h"
#include "file.h"
#include "tm.h"

mob_sect(etus)
	register int etus;
{
	extern	int sect_mob_scale;
	extern	int sect_mob_max;
	register struct sctstr *sp;
	register int value;
	register int n;

	for (n=0; sp = getsectid(n); n++) {
		if (sp->sct_own == 0)
			continue;
		if (sp->sct_type == SCT_SANCT)
			continue;
		value = sp->sct_mobil + etus * sect_mob_scale;
		if (value > sect_mob_max)
			value = sect_mob_max;
		sp->sct_mobil = value;
	}
}

mob_ship(etus)
	register int etus;
{
	extern	int ship_mob_max;
	extern	int ship_mob_scale;
	register struct shpstr *sp;
	register int value;
	register int n;

	for (n=0; sp = getshipp(n); n++) {
		if (sp->shp_own == 0)
			continue;
		value = sp->shp_mobil + etus * ship_mob_scale;
		if (value > ship_mob_max)
			value = ship_mob_max;
		sp->shp_mobil = value;
	}
}

mob_plane(etus)
	register int etus;
{
	extern	int plane_mob_max;
	extern	int plane_mob_scale;
	register struct plnstr *pp;
	register int value;
	register int n;

	for (n=0; pp = getplanep(n); n++) {
		if (pp->pln_own == 0)
			continue;
		value = pp->pln_mobil + etus * plane_mob_scale;
		if (value > plane_mob_max)
			value = plane_mob_max;
		pp->pln_mobil = value;
	}
}
