static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/SUBS/RCS/list.c,v 1.9 89/09/02 01:41:16 jeffw Exp $";

/*
 * list.c
 *
 * list ships, planes at a given x,y.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "news.h"
#include "ship.h"
#include "sect.h"
#include "nuke.h"
#include "plane.h"
#include "nat.h"
#include "item.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

int
shipsatxy(x, y, wantflags, nowantflags)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
{
	extern	char *effadv();
	int	first;
	int	ships;
	struct	nstr_item ni;
	struct	mchrstr *mp;
	struct	shpstr ship;

	first = 1;
	ships = 0;
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (char *)&ship)) {
		if (ship.shp_effic < 20 || ship.shp_own == 0)
			continue;
		mp = &mchr[ship.shp_type];
		if (wantflags) {
			if ((mp->m_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (mp->m_flags & nowantflags)
				continue;
		}
		if (first) {
			pr(" #          owner           eff        type\n");
			first = 0;
		}
#ifdef	SHIPNAMES
		pr(fmt("(#%3d) %10.10s  %12.12s  %s %s\n", ni.cur,
#else
		pr(fmt("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
#endif	SHIPNAMES
			cname(ship.shp_own),
#ifdef	SHIPNAMES
			effadv(ship.shp_effic), mp->m_name, ship.shp_name));
#else
			effadv(ship.shp_effic), mp->m_name));
#endif	SHIPNAMES
		ships++;
	}
	return ships;
}

int
planesatxy(x, y, wantflags, nowantflags)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
{
	int	first;
	int	planes;
	struct	plnstr plane;
	struct	nstr_item ni;
	struct	plchrstr *plp;

	planes = 0;
	first = 1;
	snxtitem_xy(&ni, EF_PLANE, x, y);
	while (nxtitem(&ni, (char *)&plane)) {
		if (plane.pln_effic < 10 || plane.pln_own == 0)
			continue;
		if (plane.pln_flags & PLN_LAUNCHED)
			continue;
		plp = &plchr[plane.pln_type];
		if (first) {
			pr(" #          owner        eff       type\n");
			first = 0;
		}
		if (wantflags) {
			if ((plp->pl_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (plp->pl_flags & nowantflags)
				continue;
		}
		pr(fmt("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
			cname(plane.pln_own),
			effadv(plane.pln_effic), plp->pl_name));
		planes++;
	}
	return planes;
}
