#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/decl.c,v 1.4 89/05/29 14:18:29 emp-src Exp $";
#endif /* not lint */

/*
 * decl.c
 *
 * declare war, neutrality or alliance.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "news.h"
#include "file.h"

decl()
{
	extern	char *argp[];
	register char *p;
	struct	natstr	*natp;
	int	rel;
	int	oldrel;
	int	n;
	natid	with;

	natp = getnatp(cnum);

	p = getstarg(argp[1], "alliance, neutrality, hostility, or war? ");
	switch (*p) {
	case 'a':
		rel = ALLIED;
		break;
	case 'h':
		rel = HOSTILE;
		break;
	case 'n':
		rel = NEUTRAL;
		break;
	case 'w':
		rel = AT_WAR;
		break;
	default:
		pr("That's no declaration!\n");
		return RET_SYN;
	}
	if ((n = natarg(argp[2], "with which country? ")) < 0)
		return RET_SYN;
	with = n;
	if ((oldrel = getrel(natp, with)) == rel) {
		pr("No change required for that!\n");
		return RET_FAIL;
	}
	setrel(cnum, with, rel);
	if (rel == ALLIED) {
		pr("Congratulations.\n");
		nreport(cnum, N_DECL_ALLY, with, 1);
		wu(0, with,
			fmt("Country #%d has declared an alliance with you!",
			cnum));
	} else if (rel == NEUTRAL) {
		if (oldrel == 1)
			nreport(cnum, N_DIS_ALLY, with, 1);
		else
			nreport(cnum, N_DIS_WAR, with, 1);
		pr("Neutrality declared.\n");
		wu(0, with,
			fmt("Country #%d has declared neutrality toward you!",
			cnum));
	} else if (rel == HOSTILE) {
		pr("Another cold war...\n");
		wu(0, with, fmt("Country #%d has become hostile!", cnum));
	} else if (rel == AT_WAR) {
		pr("Declaration made (give 'em hell).\n");
		wu(0, with, fmt("Country #%d has declared war on you!", cnum));
		nreport(cnum, N_DECL_WAR, with, 1);
	}
	return RET_OK;
}
