/*
 * plane.h
 *
 * defines and plane types
 *
 * Dave Pare, 1986
 * $Revision: 1.5 $ $Date: 89/08/17 21:48:24 $
 */

#include "queue.h"

/*
 * some routines assume that from pln_x to pln_wing remains
 * exactly equivalent with shp_x to shp_fleet
 */
struct plnstr {
	coord pln_x;		/* plane x-y */
	coord pln_y;
	natid pln_own;		/* owning country */
	char pln_type;		/* fighter, bomber, etc */
	char pln_effic;		/* actually "training" */
	char pln_mobil;		/* mobility */
	short pln_sell;		/* index into trade file */
	short pln_tech;		/* plane's tech level */
	short pln_uid;		/* plane unit id */
	char pln_wing;		/* like fleet */
	u_char pln_range;	/* total distance, not radius */
#ifdef	RANGEEDIT
	u_char pln_range_max;	/* max range for this plane */
#endif	RANGEEDIT
	short pln_ship;		/* pointer to carrier */
	char pln_att;		/* plane air-air attack/defense values */
	char pln_def;
	char pln_harden;	/* for missiles */
	char pln_nuketype;	/* type of nuclear armament (if any) */
	char pln_nukeamt;	/* # of nukes */
	char pln_flags;		/* State of the plane */
#ifdef	ORBIT
	float pln_theta;	/* position in orbital sine wave */
#endif	ORBIT
};

#define	PLN_LAUNCHED	bit(0)	/* A satellite that's in orbit */
#ifdef	ORBIT
#define	PLN_SYNCHRONOUS	bit(1)	/* A satellite in geo-synchronous orbit */
#endif	ORBIT

struct plchrstr {
	char *pl_name;		/* plane unit name */
	int pl_lcm;		/* costs to build */
	int pl_hcm;
	int pl_cost;
	int pl_tech;		/* tech needed to build */
	int pl_acc;		/* bombing accuracy (higher the better) */
	int pl_load;		/* bomb load, also for carrying cargo */
	int pl_att;		/* air-air attack/defense strengths */
	int pl_def;
	int pl_range;		/* how many sectors it can fly */
	int pl_crew;		/* number of mil to crew it */
	int pl_fuel;		/* fuel consumption */
	int pl_flags;		/* description of capability */
};

#define P_B	bit(0)	/* bombing factor only for bombing */
#define P_T	bit(1)	/* tactical bombing ability */
#define P_F	bit(2)	/* interceptor/escort */
#define P_C	bit(3)	/* bombing factor for transport only */
#define P_V	bit(4)	/* vtol ability */
#define P_M	bit(5)	/* missile, used only once, can't be intercepted */
#define P_L	bit(6)	/* light plane, lands on carriers */
#define P_S	bit(7)	/* Spy ability */
#define P_I	bit(8)	/* Imaging ability (advanced spying) */
#define P_O	bit(9)	/* Orbital ability (a satellite) */
#define P_X	bit(10)	/* Stealth ability */
#ifdef	ABM
#define P_N	bit(11) /* Nuclear RV interceptor (abm) */
#endif	ABM

#define PM_R	bit(0) /* Recon mission */

#define PLN_MAXDEF	50

	/* internal to "fly" module -- really shouldn't be here */

struct plist {
	struct qelem queue;	/* list of planes */
	int state;		/* state of plane */
	int bombs;		/* bombs carried for bombing mission */ 
	int misc;		/* amount of random item being transported */
	struct plchrstr *pcp;	/* pointer to desc of plane */
	struct plnstr plane;	/* struct plane */
};

#define	P_OK		0
#define P_FIRED		1
#define P_DEL		2

#define getplane(n, p) \
	ef_nbread(EF_PLANE, n, (caddr_t)p)
#define putplane(n, p) \
	ef_nbwrite(EF_PLANE, n, (caddr_t)p)
#define getplanep(n) \
	(struct plnstr *) ef_ptr(EF_PLANE, n)

extern  struct plchrstr plchr[];
extern	int pln_maxno;
