/*
 * land.c
 *
 * new version of empcre
 * Create the land masses in the game.
 *
 * Original created by James W. Anderson, 1987
 * Revised by Dave Pare, 1989
 *
 */

/* 
* This program was written by Dan Bennett and Yasser Doleh 
* The Graph Widget is the property of Kent State University
*
*  This contains code from land.c as noted above
*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <math.h>
#include <stdio.h>
#include <X11/Xaw/Form.h>
#include <X11/Composite.h>
#include <X11/Xaw/Command.h>
#include <X11/Shell.h>
#ifdef	sys5
#include <string.h>
#else
#include <strings.h>
#endif	sys5
#include "Graph.h"
#include <X11/Xlib.h>
/*
#include <stdlib.h>
 */
#include <fcntl.h>
#include "var.h"
#include "misc.h"
#include "power.h"
#include "nat.h"
#include "sect.h"
#include "gamesdef.h"
#include "file.h"
#include "xy.h"

#define rnd(x) (random() % (x))

Widget thegraph,button[3],fillbutton,EXACTB,
       toplevel;

int RED,GREEN,BLUE,BLACK;
int Current_Color;
int Draw_Mode;
int Fill = True;
int Exact = True;

#define XPLATES         ((WORLD_X) / 2) /* basically world x-y size */
#define YPLATES         (WORLD_Y)
#define XSIZE           (XPLATES)
#define YSIZE           (YPLATES)

#define BIGV            256             /* used in making altitude */
#define SMALLV          128             /* ex-ocean: rnd(SMALLV) - rnd(BIGV) */
#define LANDMIN         1               /* plate altitude for normal land */
#define HILLMIN         34              /* plate altitude for hills */
#define PLATMIN         36              /* plate altitude for plateau */
#define HIGHMIN         108             /* plate altitude for mountains */

struct  sctstr sects[YSIZE][XSIZE];

typedef enum plates {
	OCEAN, ISLAND, CONTINENT
} plate_e;

plate_e plates[YPLATES][XPLATES];
int     world[YSIZE][XSIZE];

#define SECTRANGE       3               /* smoothing area */

int     sectrange = SECTRANGE;

int uimage[WORLD_X][WORLD_Y] = 0;
int buimage[WORLD_X][WORLD_Y] = 0;
int tmp[WORLD_X][WORLD_Y] = 0;

#define BOX_SIZE 8
#define LMIN 0
#define LMAX 254 

flood_fill(x,y,color)
   int  x,y,color;
   {
      if (((x<WORLD_X) & (x>-1)) & ((y<WORLD_Y)&(y>-1))) {
	  if (uimage[x][y] == BLUE) {
	     uimage[x][y] = color;
	     XGPDrawPoint(thegraph,x,y,WORLD_X,BOX_SIZE,color);
	     flood_fill(x-1,y-1,color);
	     flood_fill(x-1,y+1,color);
	     flood_fill(x+1,y-1,color);
	     flood_fill(x+1,y+1,color);
	     flood_fill(x-2,y,color);
	     flood_fill(x+2,y,color);
	   }
	}
    }

static void fillit(w,event,params,num_params)
    Widget  w;
    XEvent  *event;
    String  *params;
    int     num_params;

    { 
      int   x,y;

      if (Fill) {
	  bcopy(uimage,buimage,WORLD_X*WORLD_Y*sizeof(int)); 
          x = (int) event->xmotion.x/ BOX_SIZE;
          y = (int) event->xmotion.y/ BOX_SIZE;
          if ((even(x) & !even(y)) | (even(y)& !even(x))){
	     y++;
          }
          flood_fill(x,y,Current_Color);
      }	
   }

make_altitude(plates, world)
        register plate_e plates[YPLATES][XPLATES];
        register int world[YSIZE][XSIZE];
{
        register int x, y;

        for (y = 0; y < YPLATES; y++) {
                for (x = 0; x < XPLATES*2; x++) {
                    if (((x ^ y) & 1)){
                         continue;
                    } else {
                        if (uimage[x][y] == BLUE) { 
                                /*-BIGV, -SMALLV/2, SMALLV*/
                                world[y][x/2] = rnd(SMALLV) - rnd(BIGV);
				if(Exact &&(world[y][x/2] > -1)){
				   world[y][x/2] = -10;
				}
                        } else if (uimage[x][y] == RED) { 
                                /*-BIGV, 0, BIGV*/
                                world[y][x/2] = rnd(BIGV) - rnd(BIGV) + 20;
				if(Exact &&(world[y][x/2] < 1)){
				   world[y][x/2] = 5;
				}
                        } else { 
                                /*-SMALLV, SMALLV/2, BIGV*/
                                world[y][x/2] = rnd(BIGV) -
                                     rnd((int)((float)SMALLV/1.3));
				if(Exact &&(world[y][x/2] < 1)){
				   world[y][x/2] = 10;
				}
                        }
                    }
                }
        }
}

int
total_land(world, xbase, ybase, range)
        register int world[YSIZE][XSIZE];
        register int xbase;
        int ybase;
        register int range;
{
        register int x;
        register int xmax;
        register int total;
        register int *row;
        int     y;
        int     ymax;

        total = 0;
        xmax = xbase + range;
        ymax = ybase + range;
        for (y = ybase; y < ymax; y++) {
                row = world[y % YSIZE];
                for (x = xbase; x < xmax; x++)
                        total += row[x % XSIZE];
        }
        return(total);
}

make_sects(world, sects)
        register int world[YSIZE][XSIZE];
        struct sctstr *sects;
{
        register struct sctstr *sct;
        register int i;
        register int x, y;
        int     elev[12+12+3]; /* # sects from -12 to 12 in steps of 10 elev */
        int     range;
        int     rangesq;
        int     total;
        int     sum;

        for (i = 0; i < 12+12+3; i++)
                elev[i] = 0;
        sum = 0;
        sct = sects;
        for (y = 0; y < YSIZE; y++) {
                for (x = 0; x < XSIZE; x++, sct++) {
                        sct->sct_x = x*2 + (y & 01);
                        sct->sct_y = y;
                        range = 3 + rnd(sectrange);
                        rangesq = range * range;
                        total = total_land(world, x, y, range) / rangesq;
			if (Exact) {
			   if (world[y][x] < 0) {
				sct->sct_type = SCT_WATER;
                           } else if (total < HILLMIN)
                                sct->sct_type = SCT_RURAL;
                           else if (total < PLATMIN)
                                sct->sct_type = SCT_MOUNT;
                           else if (total < HIGHMIN)
                                sct->sct_type = SCT_RURAL;
                           else
                                sct->sct_type = SCT_MOUNT;
			} else {
                            if (total < LANDMIN) {
                                sct->sct_type = SCT_WATER;
                            } else if (total < HILLMIN)
                                sct->sct_type = SCT_RURAL;
                            else if (total < PLATMIN)
                                sct->sct_type = SCT_MOUNT;
                            else if (total < HIGHMIN)
                                sct->sct_type = SCT_RURAL;
                            else
                                sct->sct_type = SCT_MOUNT;
			}
                        sct->sct_elev = total;
                        sct->sct_newtype = sct->sct_type;
                        sum += total;
                        if (total < -129)
                                elev[0]++;
                        else
                                if (total > 129)
                                        elev[26]++;
                                else
                                        elev[13+total/10]++;
                }
        }
        for (i = 0; i < 12+12+3; i++)
                if (elev[i] != 0)
                        printf("%4d sectors elevation %4d to %4d\n",
                                elev[i], 10*i - 140, 10*i - 130);
}



void stopit(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
      exit(0);
   }

void quitit(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
        extern  struct empfile empfile[];
        register int n;
        int     x, y;
        int     i, j;
        long    now;
        int     fd;
        int     left;
        int     big;
        fd = open(empfile[EF_SECTOR].file, O_RDWR|O_CREAT|O_TRUNC, 0660);
        if (fd < 0) {
                perror(empfile[EF_SECTOR].file);
        }
        time(&now);
        srandom(now+getpid());
        printf("Making altitude\n");
        make_altitude(plates, world);
        printf("Creating sectors\n");
        make_sects(world, sects);
        printf("Writing sectors\n");
        n = write(fd, sects, sizeof(sects));
        if (n < 0) {
                perror(empfile[EF_SECTOR].file);
        }
        if (n != sizeof(sects)) {
                printf("%s: partial write\n", empfile[EF_SECTOR].file);
        }
        close(fd);
        exit(0);
   }

void printit(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
      FILE*  fp;
      int x,y;

      fp = fopen("land.output","w");
      for(x=0;x<WORLD_X;x++){
	 for(y=0;y<WORLD_Y;y++){
	    if((even(x) && even(y)) || (!even(x) && !even(y))){
		  if (uimage[y][x]== BLUE ){ fprintf(fp," %d",OCEAN);}
		  else{ if (uimage[y][x] == RED) {fprintf(fp," %d",ISLAND);}
		  else{ fprintf(fp," %d",CONTINENT);}}
	    }
	 }
	 fprintf(fp,"\n");
     }
     fclose(fp);
   }

void undoit(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
	bcopy(uimage,tmp,WORLD_X*WORLD_Y*sizeof(int)); 
	bcopy(buimage,uimage,WORLD_X*WORLD_Y*sizeof(int)); 
        bcopy(tmp,buimage,WORLD_X*WORLD_Y*sizeof(int)); 
        displaypicture(uimage,thegraph,WORLD_X,WORLD_Y,BOX_SIZE);
   }

void DoExact(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
      Arg  args[2];

      if(Exact){
          XtSetArg(args[0],XtNforeground,BLACK);
          XtSetArg(args[1],XtNbackground,GREEN);
          XtSetValues(EXACTB,args,2);  
	  Exact = False;
      } else {
          XtSetArg(args[0],XtNforeground,RED);
          XtSetArg(args[1],XtNbackground,BLUE);
          XtSetValues(EXACTB,args,2);  
	  Exact = True;
      }
   }

void DoFill(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
      Arg  args[2];

      if(Fill){
          XtSetArg(args[0],XtNforeground,BLACK);
          XtSetArg(args[1],XtNbackground,GREEN);
          XtSetValues(fillbutton,args,2);  
	  Fill = False;
      } else {
          XtSetArg(args[0],XtNforeground,RED);
          XtSetArg(args[1],XtNbackground,BLUE);
          XtSetValues(fillbutton,args,2);  
	  Fill = True;
      }
   }

void ClearIt(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
    int i,j;

    bcopy(uimage,buimage,WORLD_X*WORLD_Y*sizeof(int)); 
    for(i=0;i<WORLD_X;i++){
	for(j=0;j<WORLD_Y;j++){
	   uimage[i][j] = BLUE;
	}
    }
    displaypicture(uimage,thegraph,WORLD_X,WORLD_Y,BOX_SIZE);
     
   }

void oceaner(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   { 
     Arg args[2];

     XtSetArg(args[0],XtNforeground,BLUE);
     XtSetArg(args[1],XtNbackground,BLACK);
     XtSetValues(button[0],args,2);  
     XtSetArg(args[0],XtNforeground,BLACK);
     XtSetArg(args[1],XtNbackground,RED);
     XtSetValues(button[1],args,2);  
     XtSetArg(args[1],XtNbackground,GREEN);
     XtSetValues(button[2],args,2);  
     Current_Color = BLUE;
   }

void islander(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
     Arg args[2];
     XtSetArg(args[0],XtNforeground,RED);
     XtSetArg(args[1],XtNbackground,BLACK);
     XtSetValues(button[1],args,2);  
     XtSetArg(args[0],XtNforeground,BLACK);
     XtSetArg(args[1],XtNbackground,BLUE);
     XtSetValues(button[0],args,2);  
     XtSetArg(args[1],XtNbackground,GREEN);
     XtSetValues(button[2],args,2);  
     Current_Color = RED;
   }

void continenter(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
     Arg args[2];
     XtSetArg(args[0],XtNforeground,GREEN);
     XtSetArg(args[1],XtNbackground,BLACK);
     XtSetValues(button[2],args,2);  
     XtSetArg(args[0],XtNforeground,BLACK);
     XtSetArg(args[1],XtNbackground,RED);
     XtSetValues(button[1],args,2);  
     XtSetArg(args[1],XtNbackground,BLUE);
     XtSetValues(button[0],args,2);  
     Current_Color = GREEN;
   }

static void DoPoint(w,event,params,num_params)
    Widget  w;
    XEvent  *event;
    String  *params;
    int     num_params;

    {
       Draw_Mode = True; 
    }

static void UnDoPoint(w,event,params,num_params)
    Widget  w;
    XEvent  *event;
    String  *params;
    int     num_params;

    {
       Draw_Mode = False; 
    }

static void DoAction(w,event,params,num_params)
    Widget  w;
    XEvent  *event;
    String  *params;
    int     num_params;

    { 
       int   x,y;

       if (Draw_Mode) {
	    x = (int) event->xmotion.x/ BOX_SIZE;
	    y = (int) event->xmotion.y/ BOX_SIZE;

	    buimage[x][y] = uimage[x][y];
	    uimage[x][y]=Current_Color;
	    XGPDrawPoint(w,x,y,WORLD_X,BOX_SIZE,Current_Color);
       }
    }

main(argc,argv)
   int argc;
   char *argv[];

   {
   
    Widget  box,
	    Quit,
	    Stop,
	    Clear,
	    UnDo,
	    Save,
	    TITLE;

    Arg     args[10];
    int     i,j;
	    
    int     pict[WORLD_X][WORLD_Y];
    XtTranslations trans;

    static char trans_string[]="<Btn1Down>: draw()\n \
			 <Btn1Up>: nodraw()\n \
			 <Btn3Down>,<Btn3Up>: fill()\n \
			 <MotionNotify>:move()\n";
    static XtActionsRec actionList[] = {{"draw",DoPoint}
					,{"nodraw",UnDoPoint}
					,{"fill",fillit}
					,{"move",DoAction}};

    static XtCallbackRec quiter[][2]= {{{quitit,NULL},{NULL,NULL}},
				       {{DoFill,NULL},{NULL,NULL}},
				       {{DoExact,NULL},{NULL,NULL}},
				       {{undoit,NULL},{NULL,NULL}},
				       {{printit,NULL},{NULL,NULL}},
				       {{stopit,NULL},{NULL,NULL}},
				       {{ClearIt,NULL},{NULL,NULL}}};

    static XtCallbackRec action[][2]= {{{oceaner,NULL},{NULL,NULL}}
				     ,{{islander,NULL},{NULL,NULL}}
				     ,{{continenter,NULL},{NULL,NULL}}};

    toplevel = XtInitialize(argv[0],"FOURIER",NULL,0,&argc,argv);
    XtSetArg(args[0],XtNborderWidth,0);
    box = XtCreateManagedWidget("FOURIER",formWidgetClass,toplevel,args,1);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Empire Land Map Maker");
    TITLE = XtCreateManagedWidget("label",labelWidgetClass,box,args,1);
     
    XtSetArg(args[0],XtNlabel,(XtArgVal) "OCEAN");
    XtSetArg(args[1],XtNfromHoriz,TITLE);
    XtSetArg(args[2],XtNcallback,action[0]);
    button[0] = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "ISLAND");
    XtSetArg(args[1],XtNfromHoriz,button[0]);
    XtSetArg(args[2],XtNcallback,action[1]);
    button[1] = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "CONTINENT");
    XtSetArg(args[1],XtNfromHoriz,button[1]);
    XtSetArg(args[2],XtNcallback,action[2]);
    button[2] = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Clear");
    XtSetArg(args[1],XtNfromHoriz,button[2]);
    XtSetArg(args[2],XtNcallback,quiter[6]);
    Clear = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Fill");
    XtSetArg(args[1],XtNfromHoriz,Clear);
    XtSetArg(args[2],XtNcallback,quiter[1]);
    fillbutton = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Exact");
    XtSetArg(args[1],XtNfromHoriz,fillbutton);
    XtSetArg(args[2],XtNcallback,quiter[2]);
    EXACTB = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "UnDo");
    XtSetArg(args[1],XtNfromHoriz,EXACTB);
    XtSetArg(args[2],XtNcallback,quiter[3]);
    UnDo = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Save");
    XtSetArg(args[1],XtNfromHoriz,UnDo);
    XtSetArg(args[2],XtNcallback,quiter[4]);
    Save = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Quit - Make Sector File");
    XtSetArg(args[1],XtNcallback,quiter[0]);
    XtSetArg(args[2],XtNfromVert,TITLE);
    Quit = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Stop - DO NOT MAKE SECTOR FILE");
    XtSetArg(args[3],XtNfromVert,TITLE);
    XtSetArg(args[1],XtNfromHoriz,Quit);
    XtSetArg(args[2],XtNcallback,quiter[5]);
    Stop= XtCreateManagedWidget("label",commandWidgetClass,box,args,4);

    XtSetArg(args[0],XtNheight,WORLD_Y*BOX_SIZE);
    XtSetArg(args[1],XtNwidth,WORLD_X*BOX_SIZE);
    XtSetArg(args[4],XtNfromVert,Quit);
    
    thegraph = XtCreateManagedWidget("hello",graphWidgetClass,box,args,5);

    XtAddActions(actionList,XtNumber(actionList));
    trans = XtParseTranslationTable(trans_string);
    XtOverrideTranslations(thegraph,trans);

    XtRealizeWidget(toplevel);

    RED = MakeColor(thegraph,"RED");
    GREEN = MakeColor(thegraph,"Green");
    BLUE = MakeColor(thegraph,"BLUE");
    BLACK = MakeColor(thegraph,"Black");

    Current_Color = RED;

    ClearIt(thegraph,NULL,NULL);
    bcopy(uimage,buimage,WORLD_X*WORLD_Y*sizeof(int)); 
    continenter(button[1],NULL,NULL);
    DoFill(fillbutton,NULL,NULL);
    DoExact(EXACTB,NULL,NULL);

    XtMainLoop();
}
