#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/subs/RCS/type.c,v 1.2 89/09/18 00:07:25 mr-frog Exp $";
#endif

/*
 * type.c
 *
 * typename to array offset translation.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "ship.h"
#include "plane.h"
#include "sect.h"
#include "nuke.h"
#include "file.h"

int
typematch(buf, type)
	char	*buf;
	int	type;
{
	register int n;
	int	len;
	int	count, current;

	len = strlen(buf);
	switch (type) {
	case EF_SECTOR: {
		register struct dchrstr *dcp;
	
		if (!buf[0] || buf[1])
			return -1;
		for (dcp=dchr,n=0; dcp->d_name; n++,dcp++)
			if (dcp->d_mnem == *buf)
				return n;
		}
		break;
	case EF_SHIP: {
		register struct mchrstr *mcp;
	
		for (mcp=mchr,n=0,count=0; *mcp->m_name; n++,mcp++)
			if (strscan(buf, mcp->m_name) == 0) {
				current = n;
				count++;
			};
		}
		if (count == 1)
			return current;
		break;
	case EF_PLANE: {
		register struct plchrstr *pcp;
	
		for (pcp=plchr,n=0,count=0; *pcp->pl_name; n++,pcp++)
			if (strscan(buf, pcp->pl_name) == 0) {
				current = n;
				count++;
			};
		}
		if (count == 1)
			return current;
		break;
	case EF_NUKE: {
		register struct nchrstr *ncp;
	
		for (ncp=nchr,n=0,count=0; *ncp->n_name; n++,ncp++)
			if (strscan(buf, ncp->n_name) == 0) {
				current = n;
				count++;
			};
		}
		if (count == 1)
			return current;
		break;
	default:
		break;
	}
	return -1;
}
