#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/coll.c,v 1.6 89/09/17 21:15:18 mr-frog Exp $";
#endif /* not lint */

/*
 * coll.c
 *
 * collect on loan
 *
 * from PSL Empire, 1985
 */

#include <math.h>
#include "misc.h"
#include "var.h"
#include "file.h"
#include "sect.h"
#include "item.h"
#include "loan.h"
#include "news.h"
#include "nat.h"
#include "xy.h"

coll()
{
	extern	char *argp[];
	register int arg;
	register int i;
	register int val;
	time_t	now;
	char	*p;
	struct	lonstr loan;
	struct	sctstr sect;
	coord	x, y;
	long	due;
	long	last;
	long	rdur;
	long	xdur;
	double	rate;
	double	owed;
	double	pay;

	if ((arg = onearg(argp[1], "Collect on loan #")) < 0)
		return RET_SYN;
	if (!getloan(arg, &loan) || loan.l_loner != cnum || loan.l_ldur == 0) {
		pr("You aren't owed anything on that loan...\n");
		return RET_FAIL;
	}
	(void) time(&now);
	due = loan.l_duedate;
	if (now <= due) {
		pr(fmt("There has been no default on loan %d\n", arg));
		return RET_FAIL;
	}
	last = loan.l_lastpay;
	if (last < due && due < now) {
		rdur = due - last;
		xdur = now - due;
	} else if (due < last) {
		rdur = 0;
		xdur = now - last;
	}
	rate = loan.l_irate / (loan.l_ldur * 8.64e6);

/* changed following to avoid overflow 3/27/89 bailey@math-cs.kent.edu
	owed = ((rdur * rate) + (xdur * rate * 2.0) + 1.0) * loan.l_amtdue;
   Begin overflow fix */
	owed = ((rdur * rate) + (xdur * rate * 2.0) + 1.0);
	if (((1 << 30) / owed) < loan.l_amtdue)
		owed = (1 << 30);
	else
		owed *= loan.l_amtdue;
/* End overflow fix */

	pr(fmt("You are owed $%.2f on that loan.\n", owed));
	if (!(p = getstarg(argp[2], "What sector do you wish to confiscate? ")))
		return RET_SYN;
	if (!sarg_xy(p, &x, &y) || !getsect(x, y, &sect))
		return RET_SYN;
	if (!neigh(x, y, cnum)) {
		pr(fmt("You are not adjacent to %s\n", xyas(x, y, cnum)));
		return RET_FAIL;
	}
	if (sect.sct_own != loan.l_lonee) {
		pr(fmt("%s is not owned by %s.\n",
			xyas(x, y, cnum),  cname(loan.l_lonee)));
		return RET_FAIL;
	}
	pay = dchr[sect.sct_type].d_value * ((float)sect.sct_effic + 100.0);
	for (i = 0; ichr[i].i_name; i++) {
		if (ichr[i].i_value == 0 || ichr[i].i_vtype == 0)
			continue;
		val = getvar(ichr[i].i_vtype, (char *)&sect, EF_SECTOR);
		pay += val * ichr[i].i_value;
	}
	pr(fmt("That sector (and its contents) is valued at $%.2f\n", pay));
	if (pay > owed * 1.2) {
		pr("That is more than is owed!\n");
		return RET_FAIL;
	}
	if (sect.sct_type == SCT_CAPIT)
		caploss(&sect, sect.sct_own, "that was %s's capital!\n");
	putvar(V_MILIT, 0, (char *)&sect, EF_SECTOR);
	(void) takeover(&sect, 0);
	putsect(&sect);
	nreport(cnum, N_SEIZE_SECT, loan.l_lonee, 1);
	if (pay >= owed) {
		loan.l_ldur = 0;
		nreport(loan.l_lonee, N_REPAY_LOAN, cnum, 1);
		wu(0, loan.l_lonee,
			fmt("%s seized %s to satisfy loan #%d\n",
				cname(cnum),
				xyas(sect.sct_x, sect.sct_y, loan.l_lonee),
				arg));
		pr("That loan is now considered repaid.\n");
	} else {
		(void) time(&loan.l_lastpay);
		owed -= pay;
		loan.l_amtdue = (long) owed;
		pay += loan.l_amtpaid;
		loan.l_amtpaid = pay;
		wu(0, loan.l_lonee, fmt(
			"%s seized %s in partial payment of loan %d.\n",
			cname(cnum),
			xyas(sect.sct_x, sect.sct_y, loan.l_lonee), arg));
		pr(fmt("You are still owed $%.2f on loan %d.\n", owed, arg));
	}
	putloan(arg, &loan);
	return RET_OK;
}
