#include "gamesdef.h"
#include "misc.h"

#ifdef	AUTONAV

#define MAXROUTE	100	   /* return '?' if path longer than this */
#define WORLDSIZE	WORLD_X*WORLD_Y/2
#define valid(x,y)	(((x^y)&1)==0)
#define stype(x,y)   	bigmap[(x/2)*WORLD_X+y]

extern char bigmap[];

/* ________________________________________________________________
**
**  bestpath(x1,y1,x2,y2,(char *)terrain);
**
**  Calculate routing string to get from sector [x1,y1] to sector [x2,y2]
**  via a specified type of terrain.
**
**  Specify:
**
**	x1,y1	     starting coordinates
**
**	x2,y2	     destination coordinates
**
**	terrain	     ptr to string showing the types of sectors that
**		     we're allowed to pass through:
**
**		     A null string enables routing through any kind of
**		     sector (useful for airplanes).
**
**		     A string that begins with an 'R' ensures that
**		     the source and destination sectors also match
**		     the specified type of terrain.
**
**		     A string that begins with a '~' (after the 'R',
**		     if necessary) specifies that we can pass through
**		     any kind of sector EXCEPT those in the remainder
**                   of the string.
**
**		     Examples:
**
**			"R~.^"	all sectors along route must be
**				non-ocean, non-mountain
**
**			"+"	all sectors between start and end
**				must be highway
**
**			"h. "	all sectors along route must be
**				harbor, water, or unmapped
**
**  'bestpath' returns a pointer to a route string containing either:
**
**     yugjbn - string of normal routing characters if route possible
**     ?      - if route is longer than MAXROUTE characters
**     \0     - (null string) if no route possible
**     h      - if start and end points are the same sector
** ________________________________________________________________
*/

char bpath[MAXROUTE];
char *dirchar	= "juygbn";
int dx[6] 	= { 2, 1,-1,-2,-1, 1 };
int dy[6] 	= { 0,-1,-1, 0, 1, 1 };
int tmp;

char *bestpath(x,y,ex,ey,terrain)
int x,y,ex,ey;
char *terrain;
{
  int i,j,tmp,tx,ty,markedsectors,routelen,restrict;
  int minx,maxx,miny,maxy,scanx,scany;
  unsigned int map[WORLD_X][WORLD_Y];

  if (restrict = (*terrain == 'R')) terrain++;

  x  = xnorm(x);
  y  = ynorm(y);
  ex = xnorm(ex);
  ey = ynorm(ey);

  if (x==ex && y==ey) return("h");

  if ( !valid(x,y) || !valid(ex,ey) ) return((char *)0);

  if (restrict &&
      (!navigable( x, y,terrain) ||
      !navigable(ex,ey,terrain)) )  return((char *)0);

  for (i=0;i<WORLD_X;i++)
    for (j=0;j<WORLD_Y;j++)
      map[i][j] = 0xFFFF;	/* clear the workspace	*/

  routelen = 0;			/* path length is now 0	*/
  map[x][y] = 0;		/* mark starting spot	*/
  markedsectors = 1;		/* source sector marked */
  minx = x-2; maxx = x+2;	/* set X scan bounds	*/
  miny = y-1; maxy = y+1;	/* set Y scan bounds	*/

  do {
    if (++routelen == MAXROUTE) return("?");
    markedsectors = 0;
    for (scanx=minx;scanx<=maxx;scanx++) {
      x = xnorm(scanx);
      for (scany=miny;scany<=maxy;scany++) {
	y = ynorm(scany);
	if ( valid(x,y) ) {
	  if ((((map[x][y])&0x1FFF)==(routelen-1)) ) {
	    for (i=0;i<6;i++) {
	      tx = xnorm(x+dx[i]);
	      ty = ynorm(y+dy[i]);
	      if (map[tx][ty]==0xFFFF) {
		if ( navigable(tx,ty,terrain) || 
		    (tx==ex && ty==ey && !restrict) ) {
		  map[tx][ty] = ((i+1)<<13) + routelen;
		  markedsectors++;
		}
	      }
	      if (tx==ex && ty==ey) {
		bpath[routelen] = 0;
		while (routelen--) {
		  i = ((map[tx][ty])>>13) - 1;
		  bpath[routelen] = dirchar[i];
		  tx = xnorm(tx-dx[i]);
		  ty = ynorm(ty-dy[i]);
		}
		return((char *)bpath);
	      }
	    }
	  }
	}
      }
    }
    miny--;
    maxy++;
    minx-=2;
    maxx+=2;
  }
  while (markedsectors);
  return((char *)0); 		/* no route possible 	*/
}


navigable(x,y,terrain)	/* return TRUE if sector is passable */
int x,y;
char *terrain;
{
  char c;
  int negate;
  if (!*terrain) return(1);
  c = stype(x,y);
  /* wu(0, 1, fmt("checking %s as %c\n", xyas(x, y, 1), c)); */
  if (negate = (*terrain=='~')) terrain++;
  while (*terrain && c!=*terrain) terrain++;
  return(negate ? (*terrain==0) : (*terrain!=0));
}

#endif	AUTONAV
