#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/rela.c,v 1.6 89/09/10 19:07:49 mr-frog Exp $";
#endif /* not lint */

/*
 * rela.c
 *
 * hacked from nati.c
 *
 */

#include "misc.h"
#include "var.h"
#include "nat.h"
#include "sect.h"
#include "file.h"
#include "xy.h"

/*
 * report relations with other countries.
 * Optional argument reports relations from the
 * viewpoint of another country
 */
int
rela()
{
	extern	char *argp[];
	struct	natstr *natp;
	struct	natstr *np;
	natid	cn;
	natid	as;
	int	n;

	if (argp[1] == 0)
		as = cnum;
	else {
		if ((n = natarg(argp[1], "Which country? ")) <= 0) {
			pr("Bad country number\n");
			return RET_SYN;
		}
		as = (natid) n;
	}
	if ((natp = getnatp(as)) == 0) {
		pr(fmt("Bad country number %d\n", cnum));
		return RET_SYN;
	}
	pr(fmt("\t%s Diplomatic Relations Report\t", cname(as)));
	prdate();
	pr(fmt("\n  Formal Relations         %5s     theirs\n",
			cnum == as ? "yours" : "his"));
	for (cn=1; cn < MAXNOC; cn++) {
		if ((np = getnatp(cn)) == 0)
			break;
		if (cn == as)
			continue;
		if ((np->nat_stat & STAT_NORM) == 0 &&
		    (np->nat_stat & STAT_SANCT) == 0)
			continue;
		pr(fmt("%3d) %-20.20s  ", cn, cname(cn)));
		pr(fmt("%-9s %s\n", relatename(natp, cn), relatename(np, as)));
	}
	return RET_OK;
}
