#ifndef lint
static char *RCSid = "$Header: offs.c,v 1.10 90/03/19 11:03:17 mr-frog Exp $";
#endif

/*
 * offs.c
 *
 * Diety set mapping offset.  #nat num, nat name, or (x,y) offset from current
 *
 * from PSL Empire, 1985
 */

#include <ctype.h>
#include "misc.h"
#include "file.h"
#include "nat.h"

offs()
{
	extern	char *argp[];
	register int i;
	struct	natstr *natp;
	coord	xorg, yorg;
	coord	dx, dy;
	char	*cp;
	struct	natstr *np;

	natp = getnatp(cnum);
	xorg = natp->nat_xorg;
	yorg = natp->nat_yorg;
	if (!(cp = getstarg(argp[1], "sector or nation? ")))
		return RET_SYN;
	if (index(cp, ',')) {	/* x, y pair for offset */
		if (!sarg_xy(cp, &dx, &dy)) {
			pr("Bad sector designation.\n");
			return RET_SYN;
		}
		xorg = dx;
		yorg = dy;
	} else {
		/* actually nation name */
		if ((i = natarg(cp, (char *)0)) < 0)
			return RET_SYN;
		np = getnatp(i);
		xorg = np->nat_xorg;
		yorg = np->nat_yorg;
	}
	np = getnatp(cnum);
	/* NOTE: it's OK to use %d,%d here, because we want abs coords */
	pr(fmt("Old offset was %d,%d\n", np->nat_xorg, np->nat_yorg));
	NAT_SET(nat_xorg, cnum, xorg);
	NAT_SET(nat_yorg, cnum, yorg);
	pr(fmt("New offset was %d,%d\n", xorg, yorg));
	return RET_OK;
}
