#ifndef lint
static char *RCSid = "$Header: login.c,v 1.3 90/04/13 12:27:37 mr-frog Exp $";
#endif

/*
 * login.c
 *
 * Keep track of people logged in to the game
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "login.h"
#include "tm.h"
#include "proto.h"

#include <sys/socket.h>
#include <netinet/in.h>

struct	qelem logins;

lo_init()
{
	initque(&logins);
}

lo_delete(lp)
	struct	login *lp;
{
	remque(&lp->queue);
	free((char *)lp);
}

struct login *
lo_new()
{
	struct	login *lp;

	lp = (struct login *) malloc(sizeof(*lp));
	insque(&lp->queue, &logins);
	lp->cnum = -1;
	lp->pid = -1;
	return lp;
}

struct login *
lo_next(lp)
	struct	login *lp;
{
	if (lp == 0)
		lp = (struct login *)logins.q_forw;
	else
		lp = (struct login *)lp->queue.q_forw;
	if (&lp->queue == &logins)
		return 0;
	return lp;
}

struct login *
lo_find(pid)
	register int pid;
{
	register struct qelem *qp;
	register struct login *lp;

	for (qp = logins.q_forw; qp != &logins; qp = qp->q_forw) {
		lp = (struct login *)qp;
		if (lp->pid == pid)
			return lp;
	}
	return 0;
}

struct login *
lo_cnum(cnum)
	register natid cnum;
{
	register struct qelem *qp;
	register struct login *lp;

	for (qp = logins.q_forw; qp != &logins; qp = qp->q_forw) {
		lp = (struct login *)qp;
		if (lp->cnum == cnum)
			return lp;
	}
	return 0;
}
