#include "main.h"
#include "nation.h"

#define	UNKNOWN		-1
#define	ALLIED		0
#define	NEUTRAL		1
#define	HOSTILE		2
#define	ATWAR		3

typedef struct s_relinfo RELINFO;
struct s_relinfo
{
	int as;
	int his [MAX_NATIONS];
	int theirs [MAX_NATIONS];
	int allied, hostile, atwar;
};

static int FindRelStatus (stat)
char * stat;
{
	if (strncmp (stat, "Allied", 6) == 0)
		return ALLIED;	
	else if (strncmp (stat, "Neutral", 7) == 0)
		return NEUTRAL;
	else if (strncmp (stat, "Hostile", 7) == 0)
		return HOSTILE;
	else if (strncmp (stat, "At War", 6) == 0)
		return ATWAR;
	else
	{
		PrintAtEmpire (Fmt ("Unknown status found (%7.7s)",
				stat));
		Bell ();
		return UNKNOWN;
	}
}

RelInfo ScanRelationsAs (country)
int country;
{
	RelInfo info;
	char * ptr;
	int i;

	info = (RelInfo) doalloc ((unsigned) sizeof (RELINFO));
	for (i = 0; i < MAX_NATIONS; i ++)
		info-> his [i] = info-> theirs [i] = UNKNOWN;
	
	info-> allied = 0;
	info-> hostile = 0;
	info-> atwar = 0;

	info-> as = country;

	FeedEmpire (Fmt ("relations %s", CountryName (country)), PRINT);
	PrintAtEmpire ("xemp: scanning relations");
	for (;;)
	{
		ptr = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (ptr);
			break;
		}

		if (EmpireStatus () == E_QUESTION)
		{
			if (! HandleQuestion (ptr))
			{
				Message ("Relations aborted");
				FreeRelInfo (info);
				return (RelInfo) 0;
			}
		}

		i = atoi (ptr);
		if (i == 0)
			continue;
		
		info-> his    [i] = FindRelStatus (ptr + 27);
		info-> theirs [i] = FindRelStatus (ptr + 37);

		if (info-> theirs [i] == info-> his [i])
		{
			switch (info-> theirs [i])
			{

			case ALLIED:	info-> allied ++; break;
			case HOSTILE:	info-> hostile ++; break;
			case ATWAR:	info-> atwar ++; break;

			}
		}
		else if (info-> theirs [i] == HOSTILE &&
			 info-> his [i] == ATWAR)
			info-> atwar ++;
		else if (info-> theirs [i] == ATWAR &&
			 info-> his [i] == HOSTILE)
			info-> hostile ++;
	}

	return info;
}

void FreeRelInfo (rel)
RelInfo rel;
{
	(void) free ((char *) rel);
}

int RelLines (rel)
RelInfo rel;
{
	int lines;

	lines = 2 + rel-> allied + rel-> hostile + rel-> atwar;
	if (lines == 2)
		lines = 3;
	
	return lines;
}

void PrintRelations (win, y, rel)
WinInfo win;
int y;
RelInfo rel;
{
	int i;

	PrintN (win, 0, y, "Relation info: ");

	if (rel-> allied + rel-> hostile + rel-> atwar == 0)
	{
		PrintN (win, 0, y + 2, "No relations.");
		return;
	}
	
	y += 2;

	if (rel-> allied > 0)
	{
		PrintN (win, 0, y, "Allied:");
		for (i = 0; i < MAX_NATIONS; i ++)
			if (rel-> his [i] == ALLIED &&
			    rel-> theirs [i] == ALLIED)
				PrintN (win, 10, y ++, CountryName (i));
	}

	if (rel-> hostile > 0)
	{
		PrintN (win, 0, y, "Hostile:");
		for (i = 0; i < MAX_NATIONS; i ++)
			if (rel-> his [i] == HOSTILE &&
			    (rel-> theirs [i] == ATWAR ||
			     rel-> theirs [i] == HOSTILE))
				PrintN (win, 10, y ++,
					Fmt ("%s%s",
						CountryName (i),
						rel-> theirs [i] == ATWAR
							? " (*)"
							: ""));
	}

	if (rel-> atwar > 0)
	{
		PrintN (win, 0, y, "At War:");
		for (i = 0; i < MAX_NATIONS; i ++)
			if (rel-> his [i] == ATWAR &&
			    (rel-> theirs [i] == ATWAR ||
			     rel-> theirs [i] == HOSTILE))
				PrintN (win, 10, y ++,
					Fmt ("%s%s",
						CountryName (i),
						rel-> theirs [i] == HOSTILE
							? " (*)"
							: ""));
	}
}
