#include <main.h>

void UtilNatInfo (x, y)
int x, y;
{
	char * ptr;
	RepInfo repinfo;
	RelInfo relinfo;
	int c, lines;
	WinInfo win;

	for (;;)
	{
		ptr = AskCountry (x, y, "About which country?", False);
		if (ptr == (char *) 0)
			return;

		c = CountryId (ptr);

		if (c < 0)
		{
			Panic ("UtilNatInfo", __FILE__,
					"Couldn't find country");
			return;
		}

		if (c == 0)
		{
			Message ("No country info on the deity");
			Bell ();
			continue;
		}

		relinfo = ScanRelationsAs (c);
		repinfo = ScanReportAs (c);
		ScanPower ();

		lines = 15 + RelLines (relinfo);

#ifdef TERMC_VERSION
		win = OpenRelToRoot (map_win, x, y, 60,
			lines > screen_rows - 3 ? screen_rows - 3
						: lines,
			FULL_BOX,
			lines > screen_rows - 3 ? lines - screen_rows + 3
						: 0);
#else
		win = OpenRelToRoot (map_win, x, y, 60, lines, CHARS, 0);
#endif

		PrintN (win, 0, 0, Fmt ("Information about %s", ptr));
		PrintPowerEntry (win, c, 2);	/* 6 lines */
		PrintRepInfo (win, 9, repinfo);
		PrintRelations (win, 15, relinfo);

		FreeReportInfo (repinfo);
		FreeRelInfo (relinfo);
		FlushWindow (win);
		Refresh ();

		(void) WaitButtonPress ((int *) 0);
		DestroyWindow (win);
	}
}
