#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "var.h"
#include "census.h"

#define 	STORE	0
#define		RESET	1

extern char * levelnames [];

static void SaveSct (sct, mode)
Sector sct;
int mode;
{
	static int eff;
	static char nds, des;
	static int foo;

	if (mode == STORE)
	{
		eff = s_eff (sct);
		nds = s_nds (sct);
		des = s_des (sct);
		foo = q_foo (sct);
	}
	else
	{
		set_eff (sct, eff);
		set_nds (sct, nds);
		set_des (sct, des);
		set_q_foo (sct, foo);
	}
}

#ifdef TERMC_VERSION
#define ADDIT_MODE	NORMAL
#else
#define	ADDIT_MODE	BOLD
#endif

void CensusProduce (sct, line)
Sector sct;
int line;
{
	int work;
	int starved;
	double range;
	bool can_convert;
	register struct pchrstr * product;
	register u_char *vp;
	register u_int *ap;
	register u_char *endp;
	register int item;
	register char itemchar;
	register int n;
	char buffer [60];
	int output, max;
	double intr;
	double	p_e;
	double	level_p_e;
	int	resource;
	int	unit_work;
	double	depend;
	int	worker_limit;
	int	material_limit;
	int	material_consume;

	ClearLine (census_win, line);
	ClearLine (census_win, line + 1);
	ClearLine (census_win, line + 2);

	if (s_des (sct) == ')')
	{
		range = 2.0 * TechFact ((int) n_tech (nation), 8.0);
		range = (range * s_eff (sct) / 100.0);

		Print (census_win, 0, line ++,
		       Fmt ("Can see %.2f sectors far", range), ADDIT_MODE);
	}
	else if (s_des (sct) == 'f')
	{
		range = TechFact ((int) n_tech (nation),
			q_gun (sct) > 7 ? 7.0 : (double) q_gun (sct));
		if (range > 7.0)
			range = 7.0;

		Print (census_win, 0, line ++,
			Fmt ("Will shoot %.2f sects far", range), ADDIT_MODE);
	}
	else if (s_des (sct) == '\\' || s_des (sct) == 's' ||
							s_des (sct) == '.')
		return;

	SaveSct (sct, STORE);

	work = roundavg (etu_per_update * PopulaceSct (sct) / 100.0);

	if (s_eff (sct) < 100 || s_nds (sct) != s_des (sct))
	{
		can_convert = s_des (sct) != s_nds (sct);
		n = BuildEff (sct, work/2);
		work -= n;

		if (can_convert)
			Print (census_win, 0, line ++, 
				Fmt ("Will be a %d%% '%c'", s_eff (sct),
							   s_des (sct))),
				ADDIT_MODE;
		else
			Print (census_win, 0, line ++,
				Fmt ("Will be %d%%", s_eff (sct)), ADDIT_MODE);
	}

	if (q_foo (sct) < 1 + etu_per_update * eatrate *
				(s_civ (sct) + s_mil (sct) + q_uw (sct)))
		work -= GrowFood(sct, work, etu_per_update);

	starved = FeedSctPeople(sct, etu_per_update, False);

	if (starved > 0)
		Print (census_win, 0, line ++,
			Fmt ("%d will starve (no work)", starved), ADDIT_MODE);

	if (s_des (sct) == 'e' && s_eff (sct) > 60)
	{
		if (s_occ (sct) == '*')
			Print (census_win, 0, line,
					"No enlistm. in occ. scts", ADDIT_MODE);
		else if (starved == 0)
			Print (census_win, 0, line,
				Fmt ("Will enlist %d mils", 
				       UpdEnlist (sct, etu_per_update, False)),
				ADDIT_MODE);
		else
			Print (census_win, 0, line, 
						"Will enlist some military",
				ADDIT_MODE);
	}
	else if (s_des (sct) == 'b' && s_eff (sct) > 60)
	{
		intr = bankint * etu_per_update * q_bar (sct);
		if (intr != 0.0)
			Print (census_win, 0, line ++,
					Fmt ("Will collect $%.2f", intr),
				ADDIT_MODE);
	}

	product = ProdChr (s_des (sct));
	if (product == (struct pchrstr *) 0 || product-> p_vtype == 0)
	{
		SaveSct (sct, RESET);
		return;
	}

	if (s_eff (sct) < 60)
	{
		Print (census_win, 0, line, "Not effic. enough (<60)",
			ADDIT_MODE);
		SaveSct (sct, RESET);
		return;
	}

	if (starved > 0)
	{
		SaveSct (sct, RESET);
		return;
	}


	item = product->p_type;
	itemchar = ItemChar (item);
	if (GiveQuant (sct, itemchar) >= 999)
	{
		SaveSct (sct, RESET);
		Print (census_win, 0, line, Fmt ("Backlog of %s", 
				ItemName (item)), ADDIT_MODE);
		SaveSct (sct, RESET);
		return;
	}

	material_limit = materials_cost (product, sct, & unit_work);

	/*
	 * calculate production efficiency.
	 */

	p_e = s_eff (sct) / 100.0;

	if (product->p_nrndx != 0)
	{
		unit_work ++;
		resource = GiveProdResource (sct, product-> p_nrndx);
		p_e = (resource * p_e) / 100.0;
		if (product->p_nrdep > 0)
		{
			/* XXX this looks way wrong */
			depend = (resource * 100.0) / product->p_nrdep;
			if (p_e > depend)
				p_e = depend;
		}
	}

	/*
	 * determine number that can be made with
	 * the available workforce
	 */

	material_consume = material_limit;
	worker_limit = roundavg (work * p_e / unit_work);
	if (material_consume > worker_limit)
		material_consume = worker_limit;
	level_p_e = 1.0;
	if (product->p_nlndx >= 0)
	{
		level_p_e = (int) GiveNatLevel (product->p_nlndx)
							- product->p_nlmin;
		if (level_p_e < 0.0)
		{
			Print (census_win, 0, line,
					Fmt ("%s lvl < %d)",
						levelnames [product-> p_nlndx],
						product-> p_nlmin),
					ADDIT_MODE);
			SaveSct (sct, RESET);
			return;
		}

		level_p_e = level_p_e / (level_p_e + product->p_nllag);
	}

	/*
	 *	Adjust produced amount by commodity production ratio
	 */

	output = (int) ((product->p_effic * 0.01 * material_consume + 0.5) *
							level_p_e);
	max = (int) ((product->p_effic * 0.01 * worker_limit + 0.5) *
							level_p_e);
	if (max > 999)
		max = 999;
	if (output > 999)
		output = 999;

	if (item == 0)
		Print (census_win, 0, line ++,
				Fmt ("%-4s:%-3d %-7.7s max %d",
					Fmt ("%.0f%%", 100.0 * level_p_e),
					output,
					product-> p_sname,
					max),
				ADDIT_MODE);
	else
		Print (census_win, 0, line ++,
				Fmt ("%-4s: %-3d %-7.7s max %d",
					Fmt ("%.0f%%", 100.0 * level_p_e),
					output,
					product-> p_sname,
					max),
			ADDIT_MODE);

	/*
	 *	Reset produced amount by commodity production ratio
	 */

	strcpy (buffer, "uses: ");

	ap = product->p_vamt;
	endp = product->p_vtype + product->p_nv;
	for (vp = product->p_vtype; vp < endp; vp++, ap++)
	{
		itemchar = ItemChar (*vp);
		strcat (buffer, Fmt ("%3d %c ", *ap * material_consume,
								itemchar));
	}

	if (product-> p_nv != 0 && output > 0)
		Print (census_win, 0, line, buffer, ADDIT_MODE);

	SaveSct (sct, RESET);
}

void CensusPlanProduce (win, y, des, civ_eff, civ_work, sct)
WinInfo win;
int y;
char des;
int civ_eff, civ_work;
Sector sct;
{
	int work;
	int effb;
	struct pchrstr * product;

	int item;
	char itemchar;
	register int n;
	char buffer [60];
	int output, max;
	double intr;
	double	p_e;
	double	level_p_e;
	int	resource;
	int	unit_work;
	double	depend;
	int	worker_limit;
	int	material_limit;
	int	material_consume;

	work = roundavg (etu_per_update * civ_eff / 100.0);
	effb = (int) work / 2;
	if (effb > 100)
		effb = 100;

	PrintN (win, 0, y, Fmt ("%d civs build %d eff.", civ_eff, effb));

	work = roundavg (etu_per_update * civ_work / 100.0);
	product = ProdChr (des);
	if (product == (struct pchrstr *) 0 || product-> p_vtype == 0)
		return;
	
	item = product->p_type;
	itemchar = ItemChar (item);
	(void) materials_cost (product, sct, & unit_work);
	p_e = 1.0;
	if (product->p_nrndx != 0)
	{
		unit_work ++;
		resource = GiveProdResource (sct, product-> p_nrndx);
		p_e = (resource * p_e) / 100.0;
	}
	worker_limit = roundavg (work * p_e / unit_work);
	max = (int) ((product->p_effic * 0.01 * worker_limit + 0.5));
	if (max > 999)
		max = 999;

	PrintN (win, 0, y + 1, Fmt ("%d civs: %d %-7.7s", civ_work,
						max, product-> p_sname));
}
