#include "type.h"
#include "main.h"
#include "event.h"
#include "sector.h"

char * MySelRealm ()
{
	int x, y, button;
	EVENT event;
	bool ul_set, lr_set, free_sct1, free_sct2;
	Sector sct1, sct2, sct;
	char * ret;

	ul_set = False;
	lr_set = False;
	while (! ul_set && ! lr_set)
	{
		if (! ul_set)
		{
			Message ("Select upper left sector of realm");
			MesBut ("View", "Cancel", "Set");
		}

		while (! ul_set)
		{
			NextEvent (& event);
			x = event. x;
			y = event. y;

			if (interrupt)
			{
				interrupt = False;
				Message ("Set realm aborted");
				MesClearBut ();
				Bell ();
				return (char *) 0;
			}

			switch (event. type)
			{

			case ButtonPress:

				switch (event. button)
				{

				case MIDDLE_BUTTON:
					Message ("Setting realm cancelled");
					MesClearBut ();
					return (char *) 0;
				
				case LEFT_BUTTON:
					if (! ConvertToSctCrd (& x, & y))
					{
						Bell ();
						continue;
					}

					sct = World (x, y, S_EXIST);
					if (sct != (Sector) 0 &&
							! NO_INFO (sct))
						CensusSct (sct);
					continue;
				
				case RIGHT_BUTTON:
					if (! ConvertToSctCrd (& x, & y))
					{
						Bell ();
						continue;
					}

					sct = World (x, y, S_EXIST);
					if (sct == (Sector) 0)
					{
						sct = World (x, y, S_DESIG);
						if (sct == (Sector) 0)
						{
							Bell ();
							continue;
						}
						free_sct1 = True;
						set_des (sct, ' ');
					}
					else
						free_sct1 = False;
				
					sct1 = sct;
					MarkSector (sct1);
					ul_set = True;
					continue;
				}

				break;
			
			default:
				break;
			}
		}

		if (! lr_set)
		{
			Message ("Select lower right sector");
			MesBut ("View", "Cancel", "Select");
		}

		while (! lr_set && ul_set)
		{
			NextEvent (& event);
			x = event. x;
			y = event. y;

			if (interrupt)
			{
				interrupt = False;
				UnmarkSector (sct1);
				if (free_sct1)
					FreeSector (sct1);
				Message ("Set realm aborted");
				MesClearBut ();
				Bell ();
				return (char *) 0;
			}

			switch (event. type)
			{

			case ButtonPress:
				
				switch (event. button)
				{

				case MIDDLE_BUTTON:
					UnmarkSector (sct1);
					if (free_sct1)
						FreeSector (sct1);
					ul_set = False;
					continue;
				
				case LEFT_BUTTON:
					if (! ConvertToSctCrd (& x, & y))
					{
						Bell ();
						continue;
					}

					sct = World (x, y, S_EXIST);
					if (sct != (Sector) 0 &&
							! NO_INFO (sct))
						CensusSct (sct);
					continue;
				
				case RIGHT_BUTTON:
					if (! ConvertToSctCrd (& x, & y))
					{
						Bell ();
						continue;
					}

					free_sct2 = False;
					sct = World (x, y, S_EXIST);
					if (sct == (Sector) 0)
					{
						free_sct2 = True;
						sct = World (x, y, S_DESIG);
						if (sct == (Sector) 0)
						{
							Bell ();
							continue;
						}
						set_des (sct, ' ');
					}
					sct2 = sct;
					MarkSector (sct2);
					lr_set = True;
				}
				break;

			default:
				break;
			}
		}
	}

	ret = Fmt ("%d:%d,%d:%d", s_xcd (sct1), s_xcd (sct2), 
				  s_ycd (sct1), s_ycd (sct2));

	UnmarkSector (sct1);
	UnmarkSector (sct2);
	MesClearBut ();

	if (free_sct1)
		FreeSector (sct1);
	
	if (free_sct2)
		FreeSector (sct2);
	
	return ret;
}
