#include <math.h>
#include <stdio.h>

void usage ()
{
	fprintf (stderr, "usage: %s\n");
	exit (1);
}

double ask (str)
char * str;
{
	char buffer [100];

	printf (str);
	fflush (stdout);
	if (gets (buffer) == (char *) 0)
	{
		fprintf (stderr, "\nUnexpected EOF.\n");
		exit (1);
	}

	return atof (buffer);
}

float tech (lvl, easy, logb)
float lvl, easy, logb;
{
	float above;

	if (lvl <= easy)
		return lvl;

	above = (float) (log ((double) (lvl - easy)) / log ((double) logb));
	if (above > 0)
		return above + easy;
	else
		return easy;
}

main (argc, argv)
int argc;
char ** argv [];
{
	float easy, delta;
	float max, lvl, logb;

	if (argc == 0)
		usage ();
	
	if (argc < 2)
		easy = ask ("Easy tech: ");
	else
		easy = atof (argv [1]);
		
	if (argc < 3)
		logb = ask ("Log base: ");
	else
		logb = atof (argv [2]);
		
	if (argc < 4)
		delta = ask ("Delta: ");
	else
		delta = atof (argv [3]);
		
	if (argc < 5)
		max = ask ("Max: ");
	else
		max = atof (argv [4]);
		
	
	for (lvl = 0.0; lvl <= max; lvl += delta)
		printf ("%.2f\t%.2f\n",	lvl, tech (lvl, easy, logb));
}
