#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"
#include "nation.h"

static int last_planeid, last_techn;
void RedoBuildPlane ();

void DoBuildPlane (x, y, planeid, techn)
int x, y;
int planeid, techn;
{
	Strings strings;
	Pager pager;
	char * ptri, * err;
	char * line, * answer;
	int newplanenr;
	double maint;

	if (s_des (cursct) != '*' || s_eff (cursct) < 60)
	{
		Message ("You can only build planes in +60% airports !");
		Bell ();
		return;
	}

	if (s_ava (cursct) < 1)
	{
		Message ("No available workers !");
		Bell ();
		return;
	}

	if (planeid < 0)
	{
		strings = InitStrings ();

		for (planeid = 0; planetypes [planeid]. nam != (char *) 0;
								planeid ++)
			if (planetypes [planeid]. tech <= (int) n_tech (nation))
			{
					/* Cost to maintain this plane */
					/* Of course no multiplier     */

				maint = etu_per_update * - dmin (-1.0,
				     planetypes [planeid]. cost * money_plane);

				maint -= planetypes [planeid]. crew * 5 *
					etu_per_update * money_mil;

				AddStringID (strings, Fmt (
		   "%-18.18s  %3d tech %3d lcm  %3d hcm  %3d ava $%-4d  ($%d)",
					planetypes [planeid]. nam,
					planetypes [planeid]. tech,
					planetypes [planeid]. lcm,
					planetypes [planeid]. hcm,
					planetypes [planeid]. ava,
					planetypes [planeid]. cost,
					(int) (maint + 0.5)), planeid);
			}

		if (StringsSize (strings) == 0)
		{
			Message ("You can't build any planes");
			Bell ();
			return;
		}

		pager = InitPager (strings, "Build which plane ?");
		MapPagerFromTop (pager, map_win, x, y);
		planeid = PagerMenu (pager);
		FreePager (pager);
		FreeStrings (strings);

		if (planeid < 0 || interrupt)
		{
			interrupt = False;
			ClearMes ();
			return;
		}
	}

	err = (char *) 0;

	if (planetypes [planeid]. ava > s_ava (cursct))
		err = Fmt ("not enough available workers (need %d)",
			planetypes [planeid]. ava);

	if (planetypes [planeid]. lcm > q_lcm (cursct))
		err = Fmt ("not enough light constr. materials (need %d)",
			planetypes [planeid]. lcm);;

	if (planetypes [planeid]. hcm > q_hcm (cursct))
		err = Fmt ("not enough heavy constr. materials (need %d)",
			planetypes [planeid]. hcm);

	if (planetypes [planeid]. cost / 10 > n_treas (nation))
		err = Fmt ("not enough money (need $%d)",
			(int) planetypes [planeid]. cost / 10);

	if (planetypes [planeid]. crew > s_mil (cursct))
		err = Fmt ("not enough mil crew (need %d)",
			planetypes [planeid]. crew);

	if (err != (char *) 0)
	{
		Message (err);
		Bell ();
		return;
	}

	if (command_state == FORCE_BUF_STATE && EmpireStatus () == E_DEAD)
	{
		if (techn < 0)
		{
			answer = InputAtMessage (Fmt ("Build at tech [%d]: ",
				(int) n_tech (nation)), 4, GS_PNUMBER);

			if (answer == (char *) 0 || interrupt)
			{
				Message ("Build plane cancelled");
				interrupt = False;
				return;
			}

			if (* answer == '\0')
				techn = n_tech (nation);
			else
				techn = atoi (answer);
		}

		if (techn > (int) n_tech (nation))
			techn = (int) n_tech (nation);
		else if (techn < planetypes [planeid]. tech)
			techn = planetypes [planeid]. tech;

		FeedCommand (Fmt ("build plane %s", CrdStr (cursct)), PRINT);
		FeedCommand (Fmt ("*%s", planetypes [planeid]. nam), PRINT);
		FeedCommand (Fmt ("*%d", techn), PRINT);

		set_q_hcm (cursct, q_hcm (cursct) - planetypes [planeid]. hcm);
		set_q_lcm (cursct, q_lcm (cursct) - planetypes [planeid]. lcm);
		set_mil (cursct, s_mil (cursct) - planetypes [planeid]. crew);
		set_ava (cursct, s_ava (cursct) - planetypes [planeid]. ava);

		last_techn = techn;
		last_planeid = planeid;
		SetAgain (RedoBuildPlane);
		Message ("Plane will be redumped after feeding");
		return;
	}

	FeedEmpire (Fmt ("build plane %s", CrdStr (cursct)), PRINT);
	(void) WaitForPrompt (PRINT);
	if (EmpireStatus () != E_QUESTION)
	{
		Message ("Build failed");
		Bell ();
		return;
	}

	FeedEmpire (Fmt ("%s", planetypes [planeid]. nam), PRINT);

	for (;;)
	{
		line = ReadEmpire (PRINT);

		if (EmpireStatus () == E_QUESTION)
		{
			PrintAtEmpire (line);

			if (strncmp (line, "Build at what tech", 18) == 0)
			{
			    if (techn < 0)
			    {
				Bell ();
			    	answer = InputAtMessage (line, 5, GS_PNUMBER);

				if (answer == (char *) 0 || interrupt)
				{
					Message ("Aborting");

					while (EmpireStatus () != E_COMMAND)
					{
						FeedEmpire ("aborted", PRINT);
						(void) WaitForPrompt (PRINT);
					}

					Message ("Build plane aborted");
					return;
				}

				if (* answer == '\0' || atoi (answer) >
							(int) n_tech (nation))
				     answer = Fmt ("%d", (int) n_tech (nation));
				     
				techn = atoi (answer);
			    }
			    else
				answer = Fmt ("%d", techn);

			    if (techn < planetypes [planeid]. tech)
			    {
					techn = planetypes [planeid]. tech;
					Message (Fmt ("Building at tech %d",
							techn));
					Bell ();
					answer = Fmt ("%d", techn);
			    }
			}
			else
			{
				Bell ();
			    	answer = InputAtMessage (line, 10, GS_NAME);
			}

			if (interrupt || answer == (char *) 0)
			{
				interrupt = False;
				Message ("Build cancelled");
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
				return;
			}
			FeedEmpire (answer, PRINT);
			continue;
		}

		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (line);
			Message ("Build failed");
			Bell ();
			return;
		}

		ptri = index (line, '#');

		if (ptri != (char *) 0)
		{
			ptri++;

			if (!ScanDigit (&ptri, &newplanenr))
				/* No digit ignore it */
				continue;

			SkipBlank (&ptri);

			if (strncmp (ptri, "built in sector", 15) != 0)
				/* No build ignore it */
				continue;

			break;
		}
	}

		/* Get new plane, just scan it */

	(void) WaitForPrompt (PRINT);
	last_techn = techn;
	last_planeid = planeid;
	SetAgain (RedoBuildPlane);

	if (FScanPlanes (Fmt ("%d", newplanenr), DONT_PRINT) == 0)
	{
		Bell ();
		PrintAtEmpire ("Can't find your new plane !!");
		(void) WaitForPrompt (DONT_PRINT);
		return;
	}

	(void) WaitForPrompt (DONT_PRINT);

	curplane = NrToPlane (newplanenr);

	Message (Fmt ("A new %s is build (at tech %d)",
		planetypes [planeid]. nam,
		pl_tech (curplane)));

		/* Adjust materials */
	
	RedumpSector (cursct, DONT_PRINT);

	CensusPlane (curplane);
	if ((planetypes [planeid]. cost / 10) <= 100)
		n_treas (nation) -= (double) (planetypes [planeid]. cost / 10);
}

void BuildPlane (x, y)
int x, y;
{
	DoBuildPlane (x, y, -1, -1);
}

void RedoBuildPlane (x, y)
int x, y;
{
	DoBuildPlane (x, y, last_planeid, last_techn);
}
