#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"
#include "nuke.h"

void RedoArm ()
{
	if (last_layout == PLANE_MODE)
	{
		Arm (10, 10, Fmt ("%d", pl_nr (curplane)));
		CensusPlane (curplane);
	}
	else
	{
		Message ("No current plane selected");
		Bell ();
	}
}

Arm (x, y, what)
int x, y;
char * what;
{
	Stockp stockp;
	char * ans, * ptr;
	int quant, type, max, ok;

	UnmarkAllPlanes ();
	MarkPlanes (what);

	stockp = s_stock (cursct);
	type = SelectNuke(x, y, stockp);
	max = sp_nukamt(stockp,type);

	ans = InputAtMessage (Fmt("Number of devices [%d/1]: ",max),
				3, GS_PNUMBER);
	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		Message ("Arm cancelled");
		Bell ();
		return;
	}
	if (* ans == '\0')
		quant = 1;
	else
		quant = atoi (ans);

	if (quant == 0) {
		interrupt = False;
		Message ("Arm cancelled");
		Bell ();
		return;
	}
	if (quant > max)
		quant = max;

	SetAgain (RedoArm);

	FeedEmpire (Fmt ("arm %s \"%s\" %d", what, nt_name(type), quant),
			PRINT);

	ptr = ReadEmpire(PRINT);

	ok = False;

	if (strchr(ptr,'#') != 0)
	{
		sp_nukamt(stockp,type) -= quant;
		add_nuk(cursct,-quant);
		ok = True;
	}
	else
		ptr = ReadEmpire(PRINT);

	ptr = WaitForPrompt (PRINT);

	if (ok == True)
	{
		FScanPlanes(what,DONT_PRINT);
		CensusPlane (curplane);
	}
}
