#include "main.h"
#include "nuke.h"

Stockp spl_head = (Stockp) 0;
Stockp spl_tail = (Stockp) 0;

Stockp NewStockPile ()
{
	Nuke new;

	new = (Stockp) doalloc ((unsigned) sizeof (struct s_nuke));
	(void) bzero (new, sizeof (struct s_nuke));

	if (spl_tail == (Stockp) 0)
		spl_tail = spl_head = new;
	else
	{
		set_sp_next (spl_tail, new);
		spl_tail = new;
	}

	return new;
}

void FreeStockPile (stockp)
Stockp stockp;
{
	Stockp ptr, found;

	if (spl_head == (Stockp) 0)
		Panic (__FILE__, "FreeStockPile", "spl_head NULL");

	if (stockp == spl_head)
	{
		if (spl_tail == stockp)
			spl_tail = sp_next (stockp);
		
		spl_head = sp_next (stockp);
	}
	else
	{
		found = (Stockp) 0;
		for (ptr = spl_head; sp_next (ptr) != (Stockp) 0;
				     ptr = sp_next (ptr))
		{
			if (ptr-> next == stockp)
			{
				found = ptr;
				break;
			}
		}
		
		if (found == (Stockp) 0)
			Panic (__FILE__, "FreeStockPile", 
				"stock pile not found");
		
		if (spl_tail == stockp)
			spl_tail = found;

		set_sp_next (found, sp_next (stockp));
	}

	(void) free ((char *) stockp);
}
