#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"

PlType planetypes [MAX_PLANETYPES];

static PlType nilplane =
{
	(char *) 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ~ P_KNOWN
};

int FindPlaneTypeByName (name, must_exist)
char *name;
bool must_exist;
{
	register int i;
	register char *ptr;
	register char *nptr;

	for (i = 0; planetypes [i]. nam != (char *) 0; i ++)
	{
		nptr = name;
		ptr = planetypes [i]. nam;

		while (*ptr == *nptr && *ptr != '\0')
		{
			ptr ++;
			nptr ++;
		}

		if (*ptr != '\0' && *nptr != '\0')
		{
			continue;
		}

		if (*ptr == '\0' && *nptr == '\0')
			return i;
		
		if (*nptr != '\0')
		{
			/* Hmmm "escort" and "escort 2" */
			if (ptr - planetypes [i]. nam < 13)
				continue;

			free (planetypes [i]. nam);
			planetypes [i]. nam = Str (name);
			return i;
		}
		else
		{
			if ((nptr - name) < 13)
				continue;
			else
				return i;
		}
	}

	if (! must_exist)
		return -1;

	PrintAtEmpire (Fmt ("Plane \"%s\" not found in 'plane-types' list",
			name));

	Bell ();
	(void) EmpireMore ();

	planetypes [i] = nilplane;
	planetypes [i]. nam = Str (name);
	if (isupper (*planetypes [i]. nam))
		*planetypes [i]. nam = tolower (*planetypes [i]. nam);
	return i;
}

void FScanShowPlaneBuild ()
{
	char *line;
	char *bptr, buffer [BUFSIZ];
	int nr, how_much;
	PlType tmp;
	int i;
	
	FeedEmpire ("show plane build", PRINT);
/*	(void) SkipNLines (1, DONT_PRINT); */
/* read line:
 *                 lcm hcm crew avail tech  $
 * and get offset from it
 */
	line = ReadEmpire (DONT_PRINT);
	how_much = index(line, 'l') - line -1;

	MessageAtEmpire ("scanning plane build data");

	nr = 0;
	for (;;)
	{

		line = ReadEmpire (DONT_PRINT);

		if (StrStr(line, "lcm hcm crew avail tech  $"))
		   continue;
			/* last line ? */
		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			planetypes [nr]. nam = (char *) 0;
			return;
		}
		
		strncpy (buffer, line, how_much);
		buffer [how_much] = '\0';
		bptr = buffer + how_much;

		while ((! isalnum (* bptr)) && (*bptr != ')') )
			bptr --;

		* ++bptr = '\0';

		if (planetypes [nr]. nam != (char *) 0)
			free (planetypes [nr]. nam);

		planetypes [nr]. nam = Str (buffer);

              /*	lcm hcm crew avail tech  $	*/

		if (sscanf (line + how_much, " %d %d %d %d %d $%d",
			               & (planetypes [nr]. lcm),
			               & (planetypes [nr]. hcm),
			               & (planetypes [nr]. crew),
				       & (planetypes [nr]. ava),
			               & (planetypes [nr]. tech),
			               & (planetypes [nr]. cost)) != 6) {
			PrintAtEmpire (Fmt ("Scanning plane failed \"%s\"",
						line));
			PrintAtEmpire (line+how_much);
			Bell ();
			(void) EmpireMore ();
			nr --;
		}

		/* sort the list by tech */
		for( i=nr; i > 0; i-- ) {
		    if (planetypes[i].tech < planetypes[i-1].tech) {
			bcopy(&planetypes[i-1], &tmp, sizeof(PlType));
			bcopy(&planetypes[i], &planetypes[i-1],sizeof(PlType));
			bcopy(&tmp, &planetypes[i], sizeof(PlType));
		    }
		}
		nr ++;
	}
}

void FScanShowPlaneCap ()
{
	char *line, *ptri;
	char *bptr, buffer [BUFSIZ];
	char word [BUFSIZ];
	int nr, how_much;

	FeedEmpire ("show plane capabilities", PRINT);
/*	(void) SkipNLines (1, DONT_PRINT); */
/* read line:
 *                 acc load att def ran fuel abilites
 * and get offset from it
 */
	line = ReadEmpire (DONT_PRINT);
	how_much = index(line, 'a') - line -1;

	MessageAtEmpire ("scanning plane capabilities");

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (StrStr(line, "acc load att def ran fuel abilites"))
		   continue;
			/* last line ? */
		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}
		
		strncpy (buffer, line, how_much);
		buffer [how_much] = '\0';
		bptr = buffer + how_much;

		while ((! isalnum (* bptr)) && (*bptr != ')') )
			bptr --;

		* ++ bptr = '\0';


		nr = FindPlaneTypeByName (buffer, True);

              /*	acc load att def ran fuel abilites */

		if (sscanf (line + how_much, " %d %d %d %d %d %d",
			               & (planetypes [nr]. acc),
			               & (planetypes [nr]. load),
			               & (planetypes [nr]. att),
			               & (planetypes [nr]. def),
				       & (planetypes [nr]. range),
			               & (planetypes [nr]. fuel)) != 6)
	       {
			PrintAtEmpire (Fmt ("Scanning plane failed \"%s\"",
						line));
			PrintAtEmpire (line+how_much);
			Bell ();
			(void) EmpireMore ();
		}

		planetypes [nr]. flags = 0;

			/* Scan max cargoes */
		
		ptri = line + how_much+27; /* hardwired, eh? mta */

		for (;;)
		{
			if (! ScanWord (&ptri, word))
				break;

			if (strcmp (word, "bomber") == 0)
				planetypes [nr]. flags |= P_B;
			else if (strcmp (word, "tactical") == 0)
				planetypes [nr]. flags |= P_T;
			else if (strcmp (word, "intercept") == 0)
				planetypes [nr]. flags |= P_F;
			else if (strcmp (word, "cargo") == 0)
				planetypes [nr]. flags |= P_C;
			else if (strcmp (word, "VTOL") == 0)
				planetypes [nr]. flags |= P_V;
			else if (strcmp (word, "missile") == 0)
				planetypes [nr]. flags |= P_M;
			else if (strcmp (word, "light") == 0)
				planetypes [nr]. flags |= P_L;
			else if (strcmp (word, "spy") == 0)
				planetypes [nr]. flags |= P_S;
			else if (strcmp (word, "image") == 0)
				planetypes [nr]. flags |= P_I;
			else if (strcmp (word, "satellite") == 0)
				planetypes [nr]. flags |= P_O;
			else if (strcmp (word, "stealth") == 0)
				planetypes [nr]. flags |= P_X;
			else if (strcmp (word, "SDI") == 0)
				planetypes [nr]. flags |= P_D;
			else if (strcmp (word, "half-stealth") == 0)
				planetypes [nr]. flags |= P_H;
			else
			{
				PrintAtEmpire (Fmt (
				  "Strange ability in show plane cap \"%s\"",
					word));
				Bell ();
				(void) EmpireMore ();
			}
		}

		planetypes [nr]. flags |= P_KNOWN;
	}
}

int FScanPlanes (list, flag)
char *list;
int flag;
{
	bool nr;

	FeedEmpire (Fmt ("planes %s", list), flag);
	nr = ScanPlanes (flag);
	(void) WaitForPrompt (flag);

	return (nr);
}

int ScanPlanes (flag)
int flag;
{
	char *line, * ptri;
	Plane new;
	int nr, x, y, eff, mob, att, def, tech, ran, hard, shipnr, nuke, nuketype;
	int own;
	Sector to;
	extern WinInfo empire_win;
	int plane_type;
	char planename[100];
	int i;
	int nr_of_planes;

	if (EmpireStatus () != E_PRINTING)
		return 0;

	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning planes");

	(void) SkipNLines (1, DONT_PRINT);

	nr_of_planes = 0;

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire (line);
			return (nr_of_planes);
		}

		if (strlen (line) < 45)
			return (nr_of_planes);

		if (deity)
		{
			own = atoi (line);
			line += 4;
		}
		else
			own = (int) my_cnum;
		
		for (i = 5; i <= 20; i++)
                        planename [i - 5] = *(line + i);

                i -= 5;
                while (planename [-- i] == ' ');
			planename [i + 1] = '\0';

		plane_type = FindPlaneTypeByName (planename, False);

		nr = atoi (line);

		if (sscanf (line + 20, "%d,%d", & x, & y) != 2)
		{
			PrintAtEmpire (Fmt ("Bad plane %s", line));
			continue;
		}
			
		to = World (x, y, S_DESIG);

		if ((new = NrToPlane (nr)) == (Plane) 0)
		{
			new = (Plane)
				doalloc ((unsigned) sizeof (struct s_plane));
			bzero (new, sizeof (struct s_plane));

			set_pl_type (new, plane_type);
			set_pl_nr (new, nr);

			AddPlaneToList (new);
			AddPlaneToSector (new, to);
		}
		else
		{
			set_pl_type (new, plane_type);
			DeletePlaneFromSector (new);
			AddPlaneToSector (new, to);
		}

		clr_pl_marked (new);

		set_pl_owner (new, own);

		for (i = 5; i <= 21; i++)
			planename [i - 5] = *(line + i);

		i -= 5;
		while (planename [-- i] == ' ');

		planename [i + 1] = '\0';

		set_pl_wing (new, *(line + 30));

		if (pl_wing (new) == ' ')
			set_pl_wing (new, '~');

		ptri = line + 31;

		(void) ScanDigit (& ptri, & eff);
		ptri ++;	/* skip '%' */
		(void) ScanDigit (& ptri, & mob);
		(void) ScanDigit (& ptri, & att);
		(void) ScanDigit (& ptri, & def);
		(void) ScanDigit (& ptri, & tech);
		(void) ScanDigit (& ptri, & ran);
		(void) ScanDigit (& ptri, & hard);

		if (strlen(line) > 72)
		{
			line[71] = 0;
			ptri = line + 72;
			(void) ScanDigit (& ptri, & nuke);
			ptri++;
			nuketype = FindNukeType(ptri);
			ptri = line + 63;
		}
		else
		{
			nuke = 0;
			nuketype = -1;
		}

		if (! ScanDigit (& ptri, & shipnr))
			set_pl_shipnr (new, -1);
		else
			set_pl_shipnr (new, shipnr);

		set_pl_eff (new, eff);
		set_pl_mob (new, mob);
		set_pl_att (new, att);
		set_pl_def (new, def);
		set_pl_tech (new, tech);
		set_pl_range (new, ran);
		set_pl_hard (new, hard);
		set_pl_nukeamt (new, nuke);
		set_pl_nuketype (new, nuketype);

		nr_of_planes ++;
	}
}

void DumpPlanes (form, flag)
char * form;
int flag;
{
	MarkPlanes (form);
	FScanPlanes (form, flag);
	DeleteMarkedPlanes ();
}
