#include <sys/types.h>
#ifdef DIRENT_INSYS
#include <sys/dirent.h>
#else
#include <dirent.h>
#endif
	/*
	 *	or (mta)
	 *	#include <dirent.h>
	 */

#include <sys/stat.h>
#include <sys/file.h>

#include "type.h"
#include "main.h"
#include "func.h"


#ifndef XEMPINFO
#define XEMPINFO "/home/student1/hjvissc/ksu/info"
#endif XEMPINFO

static char * xemp_info_dir = XEMPINFO;

#ifdef EMPINFO
static char *emp_info_dir = EMPINFO;
#endif EMPINFO

#define OWN  		0
#define ENEMY           1


bool local_info = True;

Strings ListDir (dir)
char *dir;
{
	Strings strings;
	FILE *fp;
	char buffer[BUFSIZ];

	strings = InitStrings ();

	fp = popen (Fmt ("/bin/ls -C %s", dir), "r");

	if (fp == (FILE *) 0)
		AddString (strings, "couln't not execute /bin/ls");

	else if (fgets (buffer, BUFSIZ, fp) == (char *) 0
#ifdef EMPINFO
		|| strncmp (buffer, emp_info_dir, strlen (dir)) == 0
#endif EMPINFO
			)
	{
		AddString (strings,
			Fmt ("couldn't not list %s", dir));
		pclose (fp);
	}
	else
	{
		do
			AddString (strings,
				DelNewline (DelTabs (buffer)));
		while (fgets (buffer, BUFSIZ, fp) != (char *) 0);
		pclose (fp);
	}

	return strings;
}

	/* ARGSUSED */
Strings FileToStrings (x, y, filename)
int x, y;
char *filename;
{
	Strings strings;
	FILE *fp;
	char *p, *ptr, buffer[BUFSIZ];
	int len;
	bool first_pass;

	strings = InitStrings ();

	p = strrchr (filename, '/');
	if (p == (char *) 0) p = filename;
	else p++;

	if ((fp = fopen (filename, "r")) == (FILE *) 0)
		AddString (strings, Fmt ("No info on %s", p));
	else
	{
		if (fgets (buffer, BUFSIZ, fp) == (char *) 0)
			AddString (strings, Fmt ("No info on %s", p));
		else
			do
			{
				ptr = DelControl (
					DelNewline (DelTabs (buffer)));
				len = strlen (ptr);
				first_pass = True;
				while (len > 0 || first_pass)
				{
					first_pass = False;
					if (len > 80)
						AddString (strings,
							Fmt ("%.80s", ptr));
					else
						AddString (strings, ptr);
					ptr += 80;
					len -= 80;
				}
			}
			while (fgets (buffer, BUFSIZ, fp) != (char *) 0);

		fclose (fp);
	}

	return strings;
}

void InfoFile (x, y, file, iscom)
int x, y;
char *file;
bool iscom;
{
	Pager pager;
	Strings strings;
	char *com;

	if (iscom)
	{
		if ((com = strrchr (file, '/')) == (char *) 0)
			com = file;
		else
			com++;
	} else
		com = file;

	strings = FileToStrings (x + 2, y + 2, file);
#ifdef X_VERSION
	pager = InitPager (strings, Fmt ("info %s", com));
	AddPagerFunc (pager, "Write", WRITEFUNC);
	if (iscom)
		AddPagerFunc (pager, "New", NEWFUNC);
	AddPagerFunc (pager, "Done", DONEFUNC);
	MapPager (pager, map_win, x, y, True, True);
	AddPagerToWMList (pager);
#else
	ShowStringsInPager (strings, Fmt ("info %s", com));
#endif /* VERSION */
}

bool InfoDir (x, y, dir, header)
int x, y;
char * dir, * header;
{
	Strings strings;
	Pager pager;
	bool cont = True;
	int func;
	char *entry, *buf;
	struct stat stat_ent;

	strings = ListDir (dir);

	pager = InitPager (strings, header);

	AddPagerFunc (pager, "Done", DONEFUNC);

	MapPagerFromTop (pager, map_win, x, y);

	for (;;)
	{
		if ((buf = PagerMulti (pager, & func)) == (char *) 0)
		{
			if (func == CANCEL)
				cont = True;
			else
				/*  (func == CANCELALL || func == DONEFUNC) */
				cont = False;
			break;
		}
		buf = Str (buf);

		entry = Str (Fmt ("%s/%s", dir, buf));
		if (stat (entry, & stat_ent) < 0)
		{
			Message (Fmt ("Can't stat %s !!", entry));
			Bell ();
			free (buf);
			free (entry);
			continue;
		}

		if ((stat_ent. st_mode & S_IFDIR) == S_IFDIR)
		{
				/* directory */
			if (! InfoDir (x + 2, y + 2, entry, header))
			{
				cont = False;
				free (entry);
				free (buf);
				break;
			}
		}
		else
			InfoFile (x + 2, y + 2, entry, False);
		free (entry);
		free (buf);
	}

	FreePager (pager);
	FreeStrings (strings);

	return cont;
}

void XempInfo (x, y)
int x, y;
{
	char *ptr;


	if ((ptr = getenv ("XEMPINFO")) != (char *) 0)
		xemp_info_dir = ptr;
	
	(void) InfoDir (x, y, xemp_info_dir, "xemp/tcemp info");
}


void EmpInfo (x, y)
int x, y;
{
	Strings strings;
	Strings strings2;	/* Don't re-use variable */
	Pager pager;
	char *buf, *ptr;
	int func;

#ifdef EMPINFO
	if (! local_info)
	{
#endif /* EMPINFO */
		FeedEmpire ("info", PRINT);
		SkipNLines (1, DONT_PRINT);
		PrintAtEmpire ("Empiretool: scanning info");
		strings = InitStrings ();
		ReadEmpireStrings (strings);
#ifdef EMPINFO
	}
	else
	{
		if ((ptr = getenv ("EMPINFO")) != (char *) 0)
			emp_info_dir = ptr;

		strings = ListDir (emp_info_dir);
	}
#endif /* EMPINFO */

	pager = InitPager (strings, "Info Empire");

	AddPagerFunc (pager, "Write", WRITEFUNC);
	AddPagerFunc (pager, "Done", DONEFUNC);

	MapPagerFromTop (pager, map_win, x, y);

	for (;;)
	{
		if ((buf = PagerMulti (pager, &func)) == (char *) 0)
			break;

#ifdef EMPINFO
		if (! local_info)
		{
#endif /* EMPINFO */
			ptr = Fmt ("info %s", buf);
			FeedEmpire (ptr, PRINT);
			strings2 = InitStrings (); /* Avoid re-using strings */
			ReadEmpireStrings (strings2);
#ifdef X_VERSION
			InitWMPager (strings2, ptr);
#else
			ShowStringsInPager (strings2, ptr);
#endif /* X_VERSION */

#ifdef EMPINFO
		}
		else
			InfoFile (x + 2, y  + 2,
				Fmt ("%s/%s", emp_info_dir, buf), True);
#endif /* EMPINFO */
	}
	FreePager (pager);
	FreeStrings (strings);
}

#define	XINFO_INFOCOMS	0
#define	EINFO_INFOCOMS	1
#define SHOWNATION	2
#define SHIPSCB		3
#define PLANESCB	4
#define PLANELIST	5
#define SHIPLIST	6
#define ENEMYSHIPS	7
#define	CHINF_INFOCOMS	8

#ifdef EMPINFO
#define	MAX_INFOCOMS	9
#else
#define MAX_INFOCOMS	8
#endif /* EMPINFO */

static char *info_menu [] =
{
	"Xemp info",
	"Empire info",
	"nation",
	"ships cap & build",
	"planes cap & build",
	"list of planes",
	"list of ships",
	"list of enemy ships",
#ifdef EMPINFO
	"get info from host (now local)",
#endif /* EMPINFO */
	(char *) 0
};

void InfoCommands (x, y)
int x, y;
{
	Strings strings;
	Pager pager;
	int r, func;

	strings = InitStrings ();
	AddStringsID (strings, info_menu, MAX_INFOCOMS, 0);
	pager = InitPager (strings, "Empire Info commands");

#ifdef EMPINFO
	if (! local_info)
		ChangeString (strings, CHINF_INFOCOMS, 
					"get info local (now from host)");
#endif EMPINFO

	MapPagerFromTop (pager, map_win, x, y);

	for (;;)
	{
		r = PagerMenuFunc (pager, & func, (int *) 0);

		if (func == CANCEL || func == CANCELALL || r < 0)
			break;

		switch (r)
		{
#ifdef EMPINFO
		case CHINF_INFOCOMS:
			if (local_info)
				ChangeString (strings, CHINF_INFOCOMS, 
					"get info local (now from host)");
			else
				ChangeString (strings, CHINF_INFOCOMS, 
					"get info from host (now local)");

			local_info = ! local_info;
			ShowPagerLine (pager, r);
			continue;
#endif /* EMPINFO */

		case XINFO_INFOCOMS:
			XempInfo (x + 2, y + 2);
			break;

		case EINFO_INFOCOMS:
			EmpInfo (x + 2, y + 2);
			break;

		case SHOWNATION:
			ShowNation ();
			break;

		case SHIPSCB:
			PageShowShipCBs ();
			break;

		case PLANESCB:
			PageShowPlaneCBs ();
			break;

		case PLANELIST:
			ListPlanes (x + 2, y + 2);
			break;

		case SHIPLIST:
			ListShips (x + 2, y + 2, OWN);
			break;

		case ENEMYSHIPS:
			ListShips (x + 2, y + 2, ENEMY);
			break;
		}
	}

	FreePager (pager);
	FreeStrings (strings);

	return;
}
