#include "main.h"
#include "sector.h"
#include "nation.h"
#include "census.h"
#include "ship.h"

	/*
	 *	Output routines use by both versions
	 */

void CenPutInt (x, y, i)
int x, y, i;
{
	CenPuts (x, y, "    ");
	CenPutVal (x, y, Fmt ("%d", i));
}

void CenPutUnknown (x, y)
int x, y;
{
	CenPutVal (x, y, "-?-");
}

void CenPuts (x, y, str)
int x, y;
char * str;
{
	PrintN (census_win, x, y, str);
}

void CenClr (y)
int y;
{
	ClearLine (census_win, y);
}

void CenPutShort (x, y, s)
int x, y;
int s;
{
	CenPuts (x, y, "    ");
	CenPutVal (x, y, Fmt ("%d", s));
}

void CenPutPosit (x, y, s)
int x, y;
int s;
{
	if (s > 0)
		CenPutVal (x, y, Fmt ("%-4d", s));
	else
		CenPutVal (x, y, "    ");
}

void CenPutPos (x, y, s)
int x, y;
int s;
{
	if (s > 0)
		CenPutVal (x, y, Fmt ("%d", s));
	else
		CenPutVal (x, y, "---");
}

#ifdef TERMC_VERSION

	/*
	 *	Output routines used by termcap
	 */

void CenButton (x, y, str, len, enabled)
int x, y;
char * str;
int len;
bool enabled;
{
	PrintMarked (census_win, x, y, Fmt ("%-*s", len, str),
				enabled ? BOLD : NORMAL);
}

	/* ARGSUSED */
void CenLine (y)
int y;
{
	/* Dummy function */
}

	/* ARGSUSED */
void CenLineText (y, str)
int y;
char * str;
{
	/* Dummy function */
}

void CenPutVal (x, y, str)
int x, y;
char * str;
{
	PrintN (census_win, x, y, str);
}

bool ButtonPressed (x, y, sx, sy, len)
int x, y, sx, sy, len;
{
	return (y == sy && x >= sx && x <= (sx + len - 1));
}

#else 

	/*
	 *	Output routines used by X
	 */

void CenButton (x, y, str, len, enabled)
int x, y;
char * str;
int len;
bool enabled;
{
	PrintMarked (census_win, x - 1, y, Fmt (" %-*s ", len, str),
				enabled ? BOLD : NORMAL);
}

void CenLine (y)
int y;
{
	DrawHorizontal (census_win, y);
}

void CenLineText (y, str)
int y;
char * str;
{
	DrawHorizontal (census_win, y);
	PrintN (census_win, (26 - strlen (str)) / 2, y, str);
}

void CenPutVal (x, y, str)
int x, y;
char * str;
{
	PrintB (census_win, x, y, str);
}

bool ButtonPressed (x, y, sx, sy, len)
int x, y, sx, sy, len;
{
	return (y == sy && x >= (sx - 1) && x <= (sx + len));
}

#endif

void ClearCols (starty, lines)
int starty, lines;
{
	int x;

	while ((-- lines) >= 0)
		for (x = 4; x <= 4 + 2 * 9; x += 9)
			CenPuts (x, starty + lines, "    ");
}

void DrawCensusButtons (funcbuttons, max, enabled)
struct s_funcbutton funcbuttons [];
int max;
bool enabled [];
{
	int i;

	for (i = 0; i < max; i ++)
		CenButton      (funcbuttons [i]. x,
				funcbuttons [i]. y,
				funcbuttons [i]. name,
				funcbuttons [i]. len,
				enabled [funcbuttons [i]. id]);
}

int WhichCensusButton (funcbuttons, max, x, y)
struct s_funcbutton funcbuttons [];
int max;
int x, y;
{
	int i;

	for (i = 0; i < max; i ++)
		if (ButtonPressed (x, y, funcbuttons [i]. x,
				   funcbuttons [i]. y, funcbuttons [i]. len))
			return funcbuttons [i].id;
	
	return -1;
}

void BindCensusMode (x, y, str)
int x, y;
char * str;
{
	int new_mode;
	bool drawmap;

	if (str == (char *) 0)
	{
		ChangeCommandMode (x, y);
	}
	else
	{
		new_mode = -1;
		drawmap = (command_mode == PLAN_MODE);

		if (strcmp (str, "(normal)") == 0)
			new_mode = NORMAL_MODE;
		else if (strcmp (str, "(ship)") == 0)
			new_mode = SHIP_MODE;
		else if (strcmp (str, "(fleet)") == 0)
			new_mode = FLEET_MODE;
		else if (strcmp (str, "(plane)") == 0)
			new_mode = PLANE_MODE;
		else if (strcmp (str, "(wing)") == 0)
			new_mode = WING_MODE;
		else if (strcmp (str, "(ferry)") == 0)
			new_mode = FERRY_LIST;
		else if (strcmp (str, "(nuke)") == 0)
			new_mode = NUKE_MODE;
		else if (strcmp (str, "(info)") == 0)
			new_mode = INFO_MODE;
		else if (strcmp (str, "(plan)") == 0)
			new_mode = PLAN_MODE;
		
		if (new_mode == -1)
		{
			Message ("Illegal argument to 'census mode' binding");
			Bell ();
			return;
		}

		command_mode = new_mode;
		Census ();
		if (new_mode == PLAN_MODE || drawmap)
			DrawMap ();
	}
}
