/*
 * EmpireToolkit.h
 *
 * Type, protocol, object and class definitions used by the EmpireToolkit
 * This header file will be included in both the server and the EmpireToolkit
 *
 * Ken Stevens, 1995
 */

#ifndef _TOOLKIT_H_
#define _TOOLKIT_H_

#define EDB_VERS_MAJOR	0
#define EDB_VERS_MINOR	0
#define EDB_VERS_PATCH	4

/* Types */
#define EDB_BAD		-1
#define EDB_CHAR	1
#define EDB_UCHAR	2
#define EDB_SHORT	3
#define EDB_USHORT	4
#define EDB_INT		5
#define EDB_LONG	6
#define EDB_FLOAT	7
#define EDB_DOUBLE	8

/* Protocol */

#define EDB_VERSION	0x01
#define	EDB_CHECKSUM	0x02
#define EDB_TYPE_DEF	0x03
#define EDB_UPDATE	0x04

/* Classes and Objects */

#define EDB_STRUCT	bit(6)
#define EDB_CLASS	(EDB_STRUCT | bit(7))
#define EDB_OBJECT	(EDB_STRUCT | bit(8))

#define SCT_CLASS	(EF_SECTOR | EDB_CLASS)
#define SCT_OBJECT	(EF_SECTOR | EDB_OBJECT)
#define SHP_CLASS	(EF_SHIP | EDB_CLASS)
#define SHP_OBJECT	(EF_SHIP | EDB_OBJECT)
#define PLN_CLASS	(EF_PLANE | EDB_CLASS)
#define PLN_OBJECT	(EF_PLANE | EDB_OBJECT)
#define LND_CLASS	(EF_LAND | EDB_CLASS)
#define LND_OBJECT	(EF_LAND | EDB_OBJECT)
#define NUK_CLASS	(EF_NUKE | EDB_CLASS)
#define NUK_OBJECT	(EF_NUKE | EDB_OBJECT)
#define NWS_CLASS	(EF_NEWS | EDB_CLASS)
#define NWS_OBJECT	(EF_NEWS | EDB_OBJECT)
#define TRT_CLASS	(EF_TREATY | EDB_CLASS)
#define TRT_OBJECT	(EF_TREATY | EDB_OBJECT)
#define TRD_CLASS	(EF_TRADE | EDB_CLASS)
#define TRD_OBJECT	(EF_TRADE | EDB_OBJECT)
#define PWR_CLASS	(EF_POWER | EDB_CLASS)
#define PWR_OBJECT	(EF_POWER | EDB_OBJECT)
#define NAT_CLASS	(EF_NATION | EDB_CLASS)
#define NAT_OBJECT	(EF_NATION | EDB_OBJECT)
#define LOA_CLASS	(EF_LOAN | EDB_CLASS)
#define LOA_OBJECT	(EF_LOAN | EDB_OBJECT)
#define MAP_CLASS	(EF_MAP | EDB_CLASS)
#define MAP_OBJECT	(EF_MAP | EDB_OBJECT)
#define BMP_CLASS	(EF_BMAP | EDB_CLASS)
#define BMP_OBJECT	(EF_BMAP | EDB_OBJECT)
#define ITM_CLASS	(EF_MAX | EDB_CLASS)
#define ITM_OBJECT	(EF_MAX | EDB_OBJECT)
#define PRD_CLASS	((EF_MAX + 1) | EDB_CLASS)
#define PRD_OBJECT	((EF_MAX + 1) | EDB_OBJECT)
#define VER_CLASS	((EF_MAX + 2) | EDB_CLASS)
#define VER_OBJECT	((EF_MAX + 2) | EDB_OBJECT)
#define GEN_CLASS	((EF_MAX + 3) | EDB_CLASS)
#define	GEN_OBJECT	((EF_MAX + 3) | EDB_OBJECT)

#endif /* _TOOLKIT_H_ */
