/*
 * misc.h
 *
 * defines which don't really belong anywhere,
 * but have to go somewhere!
 *
 * $Revision: 2.7 $ $Date: 1995/10/11 03:12:06 $
 */

#ifndef _MISC_H_
#define _MISC_H_

#include <ctype.h>
#include <sys/types.h>
#include <ctype.h>

#if defined(hpux) || defined(SUN4)
#include <string.h>
#else
#include <strings.h>
#endif

#include "options.h"

#define MAXNOC		52

#define WORLD_X		64
#define WORLD_Y		32

#define	ETUS		60	/* Defined here.. may be overridden later,
				   but things still use this define */

#define ANNO_KEEP_DAYS 7 /* Keep announcements around for this many days */
#define SYNC_KEEP_DAYS 3 /* Keep spooled C_SYNC messages for this many days */

typedef u_char natid;		/* also change NSC_NATID in nsc.h */
#if !defined(aix) && !defined(sgi)
#ifndef ultrix			/* already defined in ultrix */
typedef char s_char;		/* change to signed char for aix */
#endif /* ultrix */
#else
typedef signed char s_char;
#endif /* !aix && !sgi */
typedef	short coord;		/* also change NSC_COORD in nsc.h */
/*
 * watch it; your compiler might not like this.
 * If you think this is bogus, look at /usr/include/struct.h
 */
#define	OFFSET(stype, oset) ((int)(&(((struct stype *)0)->oset)))
#define	SETOFF(sinst, oset) ((s_char *) (sinst) + (oset))

#ifndef bit
#define	bit(x)		(1<<(x))
#endif

#define minutes(x)	(60*(x))
#define hours(x)	(60*60*(x))
#define days(x)		(60*60*24*(x))

typedef void (*voidfunc)();

	/* return codes from command routines */
#define	RET_OK		0   /* command completed sucessfully */
#define	RET_FAIL	1   /* command completed unsucessfully [?] */
#define	RET_SYN		2   /* syntax error in command */
#define	RET_SYS		3   /* system error (missing file, etc) */

#define MAX_DISTPATH_LEN	10	/* Has to go somewhere */

/*
 * references to library functions which aren't related to any
 * particular object, and are of general interest
 */
#ifndef ALPHA
extern	long random();
#endif

extern	double dmax();
extern	double dmin();

extern	s_char *fmt();
extern	s_char *copy();
extern	s_char *numstr();
extern	s_char *esplur();
extern	s_char *splur();
extern	s_char *iesplur();
extern	s_char *plur();
extern	s_char *getstarg();
extern	s_char *getstring();
extern	s_char *prbuf();

/*
 * frequently used libc functions
 */

#if defined(linux)
#ifndef __STDC__
extern	s_char *malloc();
extern	s_char *calloc();
#endif
#else
#if !defined(ALPHA)
extern	s_char *malloc();
extern	s_char *calloc();
#endif
#endif

#if (!defined (aix) && !defined (sgi))
extern	s_char *ctime();
extern	s_char *strncpy();
extern	s_char *strcpy();
#ifndef NeXT
extern	s_char *index();
extern	s_char *rindex();
#endif /* NeXT */
#endif /* !aix && !sgi*/

extern	time_t time();
#ifdef linux
#ifndef atof
extern	double atof(char *);
#endif
#else
extern	double atof();
#endif

#if !defined (aix) && !defined (linux) && !defined(ALPHA) && !defined(SUN4) && !defined (SVR4)
extern	s_char *sprintf();
#endif /* aix */

#define MAXCHRNV 12

#endif /* _MISC_H_ */
