#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "edbproc.h"

/* edb_new -- allocate a new database control structure */
Empire_Database *edb_new()
{
	Empire_Database *p;
	p = (Empire_Database *) malloc(sizeof(Empire_Database));
	if (p) memset(p, 0, sizeof(Empire_Database));
	return p;
}


/* edb_save -- save the database */
int edb_save(Empire_Database  *edb, Edb_WriteFunc func)
{
	printf("edb_save called\n");
	return 0;
}


/* edb_load -- load the database */
int edb_load(Empire_Database *edb, Edb_ReadFunc func)
{
	printf("edb_load called\n");
	return 0;
}

/* edb_getSectorBuild -- retrieve info about a particular sector type */
Sector_Build *edb_getSectorBuild(Empire_Database *edb, int n)
{
	return (Sector_Build *) getCollectionItem(edb->sector_build, n);
}

/* edb_getPlaneBuild -- retrieve info about a particular plane type */
Plane_Build *edb_getPlaneBuild(Empire_Database *edb, int planeType)
{
	return (Plane_Build *) getCollectionItem(edb->plane_build, planeType);
}

/* edb_getLandBuild -- retrieve info about a particular land type */
Land_Build *edb_getLandBuild(Empire_Database *edb, int landType)
{
	return (Land_Build *) getCollectionItem(edb->land_build, landType);
}

/* edb_getShipBuild -- retrieve info about a particular ship type */
Ship_Build *edb_getShipBuild(Empire_Database *edb, int shipType)
{
	return (Ship_Build *) getCollectionItem(edb->ship_build, shipType);
}

/* edb_getNukeBuild -- retrieve info about a particular nuke type */
Nuke_Build *edb_getNukeBuild(Empire_Database *edb, int nukeType)
{
	return (Nuke_Build *) getCollectionItem(edb->nuke_build, nukeType);
}

/* edb_getItemClass -- retrieve info about a particular commod type */
Item_Class *edb_getItemClass(Empire_Database *edb, int itemType)
{
	return (Item_Class *) getCollectionItem(edb->item_class, itemType);
}

/* edb_getItemClass -- retrieve info about a particular product type */
Product_Class *edb_getProductClass(Empire_Database *edb, int productType)
{
	return (Product_Class *) getCollectionItem(edb->product_class, productType);
}

/* edb_getPlane -- retrieve info about a particular plane */
Plane  *edb_getPlane(Empire_Database *edb, int planeNo)
{
	int slot = findIndexEntry(edb->plane_data_index, planeNo, 0);
	return (Plane *) getCollectionItem(edb->plane_data, slot);
}

/* edb_getLand -- retrieve info about a particular land unit */
Land   *edb_getLand(Empire_Database *edb, int unitNo)
{
	int slot = findIndexEntry(edb->land_data_index, unitNo, 0);
	return (Land *) getCollectionItem(edb->land_data, slot);
}

/* edb_getShip -- retrieve info about a particular ship */
Ship   *edb_getShip(Empire_Database *edb, int shipNo)
{
	int slot = findIndexEntry(edb->ship_data_index, shipNo, 0);
	return (Ship *) getCollectionItem(edb->ship_data, slot);
}

/* edb_getNuke -- retrieve info about a particular nuke */
Nuke   *edb_getNuke(Empire_Database *edb, int nukeNo)
{
	int slot = findIndexEntry(edb->ship_data_index, nukeNo, 0);
	return (Nuke *) getCollectionItem(edb->nuke_data, slot);
}

/* edb_getSector -- retrieve info about a particular sector */
Sector *edb_getSector(Empire_Database *edb, int x, int y)
{
	int slot = findIndexEntry(edb->sector_data_index, x, y);
	return (Sector *) getCollectionItem(edb->sector_data, slot);
}

/* edb_getCountry -- retrieve info about the country */
Country *edb_getCountry(Empire_Database *edb)
{
	return (Country *) getCollectionItem(edb->country_data, 0);
}

/* edb_getVersion -- retrieve info about the game */
Version *edb_getVersion(Empire_Database *edb)
{
	return (Version *) getCollectionItem(edb->game_data, 0);
}

/* edb_getMap -- retrieve map info */
Cmap *edb_getCmap(Empire_Database *edb, int x, int y)
{
	int slot = findIndexEntry(edb->sector_data_index, x, y);
	return (Cmap *) getCollectionItem(edb->map_data, slot);
}

/* edb_getBmap -- retrieve map info */
Bmap *edb_getBmap(Empire_Database *edb, int row)
{
	int slot = findIndexEntry(edb->sector_data_index, row, 0);
	return (Bmap *) getCollectionItem(edb->bmap_data, slot);
}

Collection *objectCollection(Empire_Database *edb, EmpireObjectType itemType)
{
	switch (itemType) {
		case V_Plane_Build:
			return edb->plane_build;
		case V_Land_Build:
			return edb->land_build;
		case V_Ship_Build:
			return edb->ship_build;
		case V_Sector_Build:
			return edb->sector_build;
		case V_Nuke_Build:
			return edb->nuke_build;
		case V_Item_Class:
			return edb->item_class;
		case V_Product_Class:
			return edb->product_class;
		case V_Plane_Data:
			return edb->plane_data;
		case V_Land_Data:
			return edb->land_data;
		case V_Ship_Data:
			return edb->ship_data;
		case V_Sector_Data:
			return edb->sector_data;
		case V_Country_Data:
			return edb->country_data;
		case V_Bmap_Data:
			return edb->bmap_data;
		case V_Cmap_Data:
			return edb->map_data;
		case V_Version_Data:
			return edb->game_data;
	}
	return NULL;
}

void edb_enumerate(Empire_Database *edb, EmpireObjectType itemType,
		   Edb_CallBack func, void *context)
{
	int n, i;
	void *p;
	Collection *c;
	c = objectCollection(edb, itemType);
	if (!c) return;
	n = getCollectionCount(c);
	for (i=0;i<n;i++) {
		p =  getCollectionItem(c,i);
		if (!p) continue;
		func(context,p);
	}
}

/*  High level database query functions  */


/* edb_query -- perform a query operation on empire database */
Empire_Query *edb_query(Empire_Database *edb, char *query)
{
	return NULL;
}


/* edb_first_item -- get first item in query result set */
void *edb_first_item(Empire_Query *eq)
{
	return NULL;
}


/* edb_next_item -- get next item in query result set */
void *edb_next_item(Empire_Query *eq)
{
	return NULL;
}


/* edb_free_query -- dispose of query result set */
void edb_free_query(Empire_Query *eq)
{
}

