#ifndef __EDBPRIV_H__
#define __EDBPRIV_H__

/*
	ObjectDescriptor has information necessary to construct and store
	the objects described by csync messages
*/

typedef	void ObjectStoreFunc _PROTO((void *, Empire_Database *, struct genobject *));
typedef	struct genobject *ObjectFindFunc _PROTO((void *, Empire_Database *, struct genobject *));


typedef struct {
	long objtype;
	char *objdescr;
	int objsize;
	struct castr *obj_ca;
	ObjectStoreFunc *store;
	ObjectFindFunc *find;
	int collection_offset;	/* field offset in edb of collection */
	int index_offset;	/* field offset in edb of index */
	int key1, key2;		/* field offset in structure of keys */
} ObjectDescriptor;

/*
	FieldStruct is used to describe individual fields of objects
*/
typedef struct FieldStruct {
	struct FieldStruct *next;
	char *fldname;
	int  fldtype;
	struct castr *boundto;
} Field;

/*
	DictionaryStruct is used to describe each object in the database
*/
typedef struct DictionaryStruct {
	struct DictionaryStruct *next;
	int objnum;
	Field *flds;
	ObjectDescriptor *objdesc;
} Dictionary;


#endif
