#include <stdio.h>

#include "edbproc.h"
#include "edbpriv.h"
#include "misc.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"
#include "genitem.h"
#include "edb.h"

#define BUFSZ 1024

Empire_Database *edb = 0;

extern void dumpDict(Empire_Database *);

char sectorDes(Empire_Database *edb, int descode)
{
	struct dchrstr *bld;
	bld = (struct dchrstr *) getCollectionItem(edb->sector_build, descode);
	return bld->d_mnem;	
}

void showSectors(Empire_Database *edb)
{
	// Note: This is not the correct method to retrieve sector info...
	// The "Collection" methods will be replaced with something else
	// This is only to verify that the information is being stored in
	// the database correctly.
	
	int i,n;
	struct sctstr *sp;
	n = getCollectionCount(edb->sector_data);
	for (i=0;i<n;i++) {
		sp = (struct sctstr *) getCollectionItem(edb->sector_data,i);
		if (!sp) continue;
		printf("%3d,%3d %c %3d %3d %3d %3d %3d\n",
			sp->sct_x, sp->sct_y, 
			sectorDes(edb, sp->sct_type),
			sp->sct_effic,
			sp->sct_min, sp->sct_gmin, 
			sp->sct_fertil, sp->sct_oil );
	}
}

int main(int argc, char **argp)
{
	FILE *f;
	char buf[BUFSZ];
	f = fopen("csync.dat","r+");
	if (!f) {
		perror("cannot open csync.dat");
		exit(1);
	}
	edb = edb_new();
	while (fgets(buf, BUFSZ, f)) {
		edb_parse_c_sync(edb, buf);
	}
	fclose(f);

/*
	dumpDict(edb);
*/
	showSectors(edb);
	return 0;
}
