/*
 * tel.h
 *
 * things having to do with telegrams
 *
 * from PSL Empire, 1985
 * $Revision: 2.2 $ $Date: 1995/09/13 05:52:38 $
 */

#ifndef _TEL_H_
#define _TEL_H_

#define	MAXTELSIZE	1024	/* doesn't apply to TEL_UPDATE */

#define TEL_NORM	0	/* normal */
#define TEL_ANNOUNCE	1	/* announcement */
#define TEL_BULLETIN	2	/* bulletin */
#define TEL_UPDATE	3	/* update message */
#define TEL_LAST        3

#define TEL_SECONDS 5 /* how many seconds before starting a new telegram */

struct	telstr {
	natid	tel_from;	/* sender */
	s_char	tel_type;
	long	tel_length;	/* how long */
	time_t	tel_date;	/* when sent */
};

extern	s_char *mailbox();
extern	s_char *syncbox();

extern	s_char *teldir, *telfil;

extern  s_char *annfil;

extern	s_char *syncdir, *syncfil;

#endif /* _TEL_H_ */
