/*
 * land.h
 *
 * things having to do with land units
 *
 */

#ifndef _LAND_H_
#define _LAND_H_
#include "queue.h"

#ifndef RET_LEN
#define RET_LEN 10
#endif /* RET_LEN */

#define LAND_MINEFF	10
#define LAND_MINFIREEFF 20 /* arty must be this effic to fire */
#define MAXLNDV		12

struct	lndstr {
	short	ef_type;
	natid	lnd_own;	/* owner's country num */
	short	lnd_uid;	/* unit id (land unit) */
	coord	lnd_x;		/* x location in abs coords */
	coord	lnd_y;		/* y location in abs coords */
	s_char	lnd_type;	/* ship type */
	s_char	lnd_effic;	/* 0% to 100% */
	s_char	lnd_mobil;	/* mobility units made int for RS/6000 */
	short	lnd_sell;	/* pointer to trade file */
	short	lnd_tech;	/* tech level ship was built at */
	s_char	lnd_army;	/* group membership */
	coord	lnd_opx,lnd_opy;/* Op sector coords */
	short	lnd_mission;	/* mission code */
	short	lnd_radius;	/* mission radius */
	s_char	lnd_flags;	/* unit flags */
	short	lnd_ship;	/* pointer to transporting ship */
        s_char	lnd_harden;	/* for missiles */
        short	lnd_retreat;	/* retreat percentage */
	u_char	lnd_fuel;	/* How much fuel do we have */
	u_char	lnd_nxlight;	/* How many xlight planes on board? */
	int	lnd_rflags;	/* When do I retreat? */
	s_char	lnd_rpath[RET_LEN];	/* retreat path */
	u_char	lnd_rad_max;	/* max radius for this unit */
	u_char	lnd_scar;	/* how experienced the unit is (not used) */
	s_char  lnd_nv;		/* current number of variables */
#ifndef TOOLKIT
	u_char	lnd_vtype[MAXLNDV];
	u_short	lnd_vamt[MAXLNDV];
#else
	ushort civil, milit, shell, gun, petrol, iron,
		dust, bar, food, oilv, lcm, hcm, 
		uw, rad;

#endif
#ifndef SMALL_SERVER
        s_char  lnd_sparec;     /* not used */
        int     lnd_sparei;     /* not used */
        long    lnd_sparel;     /* not used */
#endif /* SMALL_SERVER */
};

#define LND_NOSYNC bit(0)

struct	lchrstr {
	u_char	l_nv;		/* number of variables it can hold */
	u_char	l_vtype[MAXCHRNV];
	u_short	l_vamt[MAXCHRNV];
	s_char	*l_name;	/* full name of type of land unit */
	int	l_lcm;		/* units of lcm to build */
	int	l_hcm;		/* units of hcm to build */
	int	l_mil;		/* how many mil it takes to build */
	int	l_gun;		/* how many guns it takes to build */
	int	l_shell;	/* how many shells it takes to build */
	int	l_tech;		/* tech required to build */
	int	l_cost;		/* how much it costs to build */
	float	l_att;		/* attack multiplier */
	float	l_def;		/* defense multiplier */
	int	l_vul;		/* vulnerability (0-100) */
	int	l_spd;		/* speed */
	int	l_vis;		/* visibility */
	int	l_spy;		/* Seeing distance */
	int	l_rad;		/* reaction radius */
	int	l_frg;		/* firing range */
	int	l_acc;		/* firing accuracy */
	int	l_dam;		/* firing damage */
	int	l_ammo;		/* firing ammu used per shot */
	int	l_aaf;		/* aa fire */
	u_char	l_fuelc;	/* fuel capacity */
	u_char	l_fuelu;	/* fuel used per 10 mob */
	u_char	l_nxlight;	/* maximum number of xlight planes */
	long	l_flags;	/* what special things can this unit do */
};

/* Land unit ability flags */
#define	L_XLIGHT	bit(0)	/* Hold xlight planes */
#define	L_ENGINEER	bit(1)	/* Do engineering things */
#define	L_SUPPLY	bit(2)	/* supply other units/sects */
#define	L_SECURITY	bit(3)	/* anti-terrorist troops */
#define	L_LIGHT		bit(4)	/* can go on ships */
#define	L_MARINE	bit(5)	/* marine units, good at assaulting */
#define	L_RECON		bit(6)	/* recon units, good at spying */
#define L_RADAR		bit(7)	/* radar unit */
#define L_ASSAULT	bit(8)	/* can assault */
#define L_FLAK		bit(9)	/* flak unit */

#define getland(n, p) \
	ef_read(EF_LAND, n, (caddr_t)p)
#define putland(n, p) \
	ef_write(EF_LAND, n, (caddr_t)p)
#define getlandp(n) \
	(struct lndstr *) ef_ptr(EF_LAND, n)

extern  struct lchrstr lchr[];
extern	int lnd_maxno;

struct llist {
	struct	qelem queue;	/* list of units */
	coord	x,y;		/* x,y it came from */
	struct	lchrstr *lcp;	/* pointer to desc of land unit */
	struct	lndstr land;	/* struct land unit */
	int	eff;
	double	mobil;
	int	supplied;
};

void landdamage();
void lnd_sel();
void lnd_nav();
void lnd_mess();
void lnd_sweep();
int lnd_check_mines();
int lnd_interdict();
int lnd_check_nav();
double lnd_mobcost();
s_char *lnd_path();
s_char *prland();

#endif /* _LAND_H_ */
