#ifndef __EDBPRIV_H__
#define __EDBPRIV_H__

/*
	ObjectDescriptor has information necessary to construct and store
	the objects described by csync messages
*/
typedef struct {
	long objtype;
	char *objdescr;
	int objsize;
	struct castr *obj_ca;
	void (*store) _PROTO((Empire_Database *,void *));
} ObjectDescriptor;

/*
	FieldStruct is used to describe individual fields of objects
*/
typedef struct FieldStruct {
	struct FieldStruct *next;
	char *fldname;
	int  fldtype;
	struct castr *boundto;
} Field;

/*
	DictionaryStruct is used to describe each object in the database
*/
typedef struct DictionaryStruct {
	struct DictionaryStruct *next;
	int objnum;
	Field *flds;
	ObjectDescriptor *objdesc;
} Dictionary;

#define EPROC(X) extern void X _PROTO((Empire_Database *, struct genobject *))

EPROC(sect_ca_store);
EPROC(sect_cf_store);
EPROC(land_ca_store);
EPROC(land_cf_store);
EPROC(ship_ca_store);
EPROC(ship_cf_store);
EPROC(plane_ca_store);
EPROC(plane_cf_store);

#endif
