#ifndef __EDBINT_H__
#define __EDBINT_H__

/* definitions internal to the database... Not part of the public interface */

/*
	C_Field_Definition is a dictionary entry of a field exported by the
	server.

	note... offset is normally the offset of a field in the structure 
        	if we need to create a "calculated" field, it will have   
		a negative offset.                                        
*/

typedef struct {
	char *name;
	int kind, len, offs;
	long flags;
} C_Field_Definition;

#define STRUCT_FLD_OFF(str, x)	((int) &(((struct str *)0)->x))


#ifdef __cplusplus
extern "C" {
#endif


void edb_print_object(s_char *buf, int objtype, void *obj, long flags);
void edb_print_def(s_char *buf, int objtype, long flags);

#ifdef __cplusplus
}
#endif



#endif
