;;; empwin.el --- Functions used by GENIE on window systems

;; Copyright (C) 1994 Markus Armbruster

;; Author: Markus Armbruster <armbru@pond.sub.org>
;; Version: $Id: empwin.el,v 1.2 1994/07/25 09:16:13 armbru Exp $
;; Keywords: games

;; This file is part of GENIE, the GNU Emacs's Nifty Interface to Empire

;; GENIE is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GENIE is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GENIE; see the file COPYING.  If not, write to the Free
;; Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; For general information on GENIE, see file empire.el.

;; This file contains definitions specific to window systems.
;; See empterm.el for character terminal specific stuff.

;; Entry points:
;; empire-highlight-string


;;; To do

;; Combine highlight faces from user customizable settings


;;; Code:

(provide 'empwin)

(defvar empire-highlight-faces
  (vector 'default 'highlight 'italic 'bold-italic)
  "Array of highlight faces.
The array index encodes the combination highlights: bit I on means
highlight I is active.")

(defun empire-highlight-string (string start end prop-list)
  "Modify STRING between START and END to highlight it according to PROP-LIST."
  (let ((index (empire-highlight-index prop-list)))
    (put-text-property start end
		       'face (aref empire-highlight-faces index)
		       string)
    string))

;;; empwin.el ends here
