/* Prefs.h */

#define kBlankLinesWinItem		0
#define kLogSizePrefsWinItem		1
#define kMaxHostsWinItem		2
#define kPagerPrefsWinItem		3
#define kStartupLCWDWinItem		4
#define kStartupMsgsPrefsWinItem	5
#define kTimeoutPrefsWinItem		6
#define kTracePrefsWinItem		7

#define kFirstPrefsWinItem			kBlankLinesWinItem
#define kLastPrefsWinItem			kTracePrefsWinItem
#define kQuitPrefsWinItem			(kLastPrefsWinItem + 1)

#define kPrefInt					0
#define kPrefToggle					1
#define kPrefStr					2

#define kPrefsName					"prefs"

#define PREFINT(a)					kPrefInt, &a, sizeof(int), 0, 0
#define PREFBOOL(a)					kPrefToggle, &a, sizeof(int), 0, 1
#define PREFTOGGLE(a,min,max)		kPrefToggle, &a, sizeof(int), min, max
#define PREFSTR(a,b,c)				kPrefStr, a, sizeof(a), b, c


typedef struct PrefOpt {
	char *name, *label, *msg;
	int type;
	void *storage;
	size_t siz;
	int min, max;	/* Also used as flags for strings. */
} PrefOpt;

#define kToggleMsg "Space toggles;  Hit <RETURN> when done."

#define kOkayIfEmpty 1
#define kNotOkayIfEmpty 0
#define kGetAndEcho 1
#define kGetNoEcho 0


void TogglePref(int *, int, int);
void GetPrefSetting(char *, size_t, int);
void UpdatePrefsWindow(int);
void PrefsWinWinMsg(char *);
void PrefsWinGetStr(char *, int, int);
void PrefsWinGetNum(int *);
void PrefsWinDraw(int, int);
void PrefsWinToggle(int *, int, int, int);
void SigIntPrefsWin(int);
int PrefsWindow(void);
void ShowAll(void);
int SetCmd(int, char **);
int PrefsCmd(int, char **);
void WritePrefs(void);
void ReadPrefs(void);
