/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/xm/RCS/realm.c,v 5.1 1993/03/14 16:35:47 etienne Exp jpo $
    $Date: 1993/03/14 16:35:47 $
    $Author: etienne $
    $Id: realm.c,v 5.1 1993/03/14 16:35:47 etienne Exp jpo $
    $Locker: jpo $
    $Log: realm.c,v $
    Revision 5.1  1993/03/14 16:35:47  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:26:31  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:00:52  greyhelm
 * Add RCS logging - Karl Hagen
 *

*/
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

#include "type.h"
#include "xextern.h"
#include "main.h"
#include "sector.h"
#include "nation.h"

void ShowBox (sx, sy, ex, ey)
int sx, sy, ex, ey;
{

	int x1, y1, x2, y2;

	x1 = sx;
	x2 = ex;
	y1 = sy;
	y2 = ey;

	ConvMapPosToPixelPos (& sx, & sy);
	ConvMapPosToPixelPos (& ex, & ey);

	if (x1 > x2)
	{
		XorLine (map_win, -1, sy, ex + MapSctWidth () - 1, sy);
		XorLine (map_win, -1, ey + MapSctHeight () - 1,
			ex + MapSctWidth () - 1, ey + MapSctHeight () - 1);
		XorLine (map_win, sx, sy, 1200, sy);
		XorLine (map_win, sx, ey + MapSctHeight () - 1, 1200,
			ey + MapSctHeight () - 1);
	}
	else
	{
		XorLine (map_win, sx, sy, ex + MapSctWidth () - 1, sy);
		XorLine (map_win, sx, ey + MapSctHeight () - 1,
			ex + MapSctWidth () - 1, ey + MapSctHeight () - 1);
	}

	if (y1 > y2)
	{
		XorLine (map_win, sx, -1, sx, ey + MapSctHeight () - 1);
		XorLine (map_win, ex + MapSctWidth () - 1, -1, 
			ex + MapSctWidth () - 1, ey + MapSctHeight () - 1);
		XorLine (map_win, sx, sy, sx, 1200);
		XorLine (map_win, ex + MapSctWidth () - 1, sy,
			ex + MapSctWidth () - 1, 1200);
	}
	else
	{
		XorLine (map_win, sx, sy, sx, ey + MapSctHeight () -1);
		XorLine (map_win, ex + MapSctWidth () - 1, sy,
			ex + MapSctWidth () - 1, ey + MapSctHeight () - 1);
	}
		
	FlushWindow (map_win);
}


typedef enum
{
	ST_INIT,
	ST_SHOW,
	ST_DONE,
	ST_TRACK
} State;

char *  MySelRealm ()
{
	Sector sct, sct1;
	State state;
	int sx, sy;
	int cx, cy;
	int nx, ny;
	int button;

	UnmarkSector (cursct);
	state = ST_INIT;

	while (state != ST_DONE) {
	    MesBut ("View", "Done", "Set1");
	    while (state == ST_INIT) {
		if (SelectSctCrd (&sx, &sy, &button) == False) {
		    MesClearBut ();
		    return NULL;
		}
		switch (button) {
		case LEFT_BUTTON:
		    sct = World (sx, sy, S_EXIST);
		    if (sct == (Sector) 0 || NO_INFO(sct))
			break;
		    CensusSct (sct);
		    break;
		case MIDDLE_BUTTON:
		    MesClearBut ();
		    return NULL;
		case RIGHT_BUTTON:
		    state = ST_TRACK;
		    break;
		default:
		    break;
		}
	    }
	    MesBut ("View", "Clear", "Set2");
	    sct1 = World (sx, sy, S_EXIST);
	    if (sct1 == (Sector) 0 || NO_INFO(sct1)) {
		sct1 = (Sector)0;
	    }
	    else
		MarkSector (sct1);

	    while (state == ST_TRACK) {
		if (SelectSctCrd (&cx, &cy, &button) == False) {
		    MesClearBut ();
		    return NULL;
		}
		switch (button) {
		case LEFT_BUTTON:
		    sct = World (cx, cy, S_EXIST);
		    if (sct == (Sector) 0 || NO_INFO(sct))
			break;
		    CensusSct (sct);
		    break;
		case MIDDLE_BUTTON:
		    state = ST_INIT;
		    break;
		case RIGHT_BUTTON:
		    ShowBox (sx, sy, cx, cy);
		    state = ST_SHOW;
		    break;
		default:
		    break;
		}
	    }
	    if (sct1)
		UnmarkSector (sct1);
	    MesBut ("Do", "Cancel", "Set2");
	    while (state == ST_SHOW) {
		if (SelectSctCrd (&nx, &ny, &button) == False) {
		    MesClearBut ();
		    return NULL;
		}
		switch (button) {
		case LEFT_BUTTON:
		    state = ST_DONE;
		    break;
		case MIDDLE_BUTTON:
		    MesClearBut ();
		    ShowBox (sx, sy, cx, cy);
		    state = ST_TRACK;
		    break;
		case RIGHT_BUTTON:
		    ShowBox (sx, sy, cx, cy);
		    cx = nx;
		    cy = ny;
		    ShowBox (sx, sy, cx, cy);
		    break;
		default:
		    break;
		}
	    }
	}
	ShowBox (sx, sy, cx, cy);
	MesClearBut ();
	return Fmt ("%s,%s",
		    sx == cx ? Fmt ("%d", sx) : Fmt ("%d:%d", sx, cx),
		    sy == cy ? Fmt ("%d", sy) : Fmt ("%d:%d", sy, cy));
}
