/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/x/RCS/xmisc.c,v 5.1 1993/03/14 16:35:53 etienne Exp $
    $Date: 1993/03/14 16:35:53 $
    $Author: etienne $
    $Id: xmisc.c,v 5.1 1993/03/14 16:35:53 etienne Exp $
    $Locker:  $
    $Log: xmisc.c,v $
    Revision 5.1  1993/03/14 16:35:53  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:26:31  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:00:52  greyhelm
 * Add RCS logging - Karl Hagen
 *

*/
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

#include "type.h"
#include "xextern.h"
#include "main.h"
#include "sector.h"
#include "nation.h"

bool SelButtonAtWin (win, x, y, button)
WinInfo win;
int * x, * y, * button;
{
 	XEvent event;
 
 	for (;;)
 	{
 		XNextEvent (display, &event);
 
 		if (StandardEvent (& event))
 		{
 			if (interrupt)
 			{
 				interrupt = False;
 				return False;
 			}
 
 			continue;
 		}
 
 		switch (event. type)
 		{
 
 		case ButtonPress:

 			if (EventWindow (& event) != win)
 				return False;
 
 			if (button != (int *) 0)
 				*button = event. xbutton. button;
 			
 			if (x != (int *) 0)
 				* x = PixelToCharX (event. xbutton. x);
 			
 			if (y != (int *) 0)
 				* y = PixelToCharY (event. xbutton. y);
 
 			return True;
		}
	}
}

Sector SelectSector (button)
int * button;
{
	Sector sct;
	int x, y;

	sct = (Sector) 0;
	do {
		if (SelectSctCrd (& x, & y, button))
			sct = World (x, y, S_EXIST);
	}
	while (sct == (Sector) 0);

	return sct;
}

bool SelectSctCrd (x, y, button)
int *x, *y;
int *button;
{
	XEvent event;

	for (;;)
	{
		XNextEvent (display, &event);

		if (StandardEvent (& event))
		{
			if (interrupt)
			{
				* x = 0;
				* y = 0;
				return False;
			}

			continue;
		}

		switch (event. type)
		{

		case ButtonPress:

			if (EventWindow (&event) != map_win)
				continue;

			* x = event. xbutton. x;
			* y = event. xbutton. y;

			if (! ConvertToSctCrd (x, y))
				continue;

			if (button != (int *) 0)
				*button = event. xbutton. button;


			return True;
		}
	}
}

void WaitButtonPress (button)
int *button;
{
	XEvent event;

	if (! xstarted)
		return;

	for (;;)
	{
		XNextEvent (display, &event);

		if (StandardEvent (& event))
		{
			if (interrupt) return;
			continue;
		}

		switch (event. type)
		{

		case ButtonPress:
			if (button != (int *) 0)
				*button = event. xbutton. button;
			return;
		}
	}
}

void Pause ()
{
	XEvent event;

	if (! xstarted)
		return;

	for (;;)
	{
		XNextEvent (display, &event);

		if (StandardEvent (& event))
		{
			if (interrupt)
				return;
			continue;
		}

		if (event. type == ButtonPress ||
		    event. type == KeyPress)
			return;
	}
}

bool interrupt = False;

bool SetInterrupt (pevent)
XEvent *pevent;
{
	KeySym keysym;
	XComposeStatus comp_status;
	char buffer [BUFSIZ];
	extern char intrchar;

	if (pevent-> type == KeyPress)
	{
		if (XLookupString (& (pevent-> xkey), buffer, BUFSIZ - 1,
					&keysym, &comp_status) == 0)
			return False;

		if (buffer[0] == intrchar)
		{
			interrupt = True;
			return True;
		}
	}

	return False;
}
