/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/termc/RCS/window.c,v 5.2 1995/09/28 13:40:59 jpo Exp jpo $
    $Date: 1995/09/28 13:40:59 $
    $Author: jpo $
    $Id: window.c,v 5.2 1995/09/28 13:40:59 jpo Exp jpo $
    $Locker: jpo $
    $Log: window.c,v $
    Revision 5.2  1995/09/28 13:40:59  jpo
    sync

 * Revision 5.1  93/03/14  16:37:17  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:28:03  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:11:33  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "tc_type.h"
#include "char.h"
#include "window.h"
#include <sys/signal.h>
#ifdef BSD
#include <sgtty.h>
#else
#include <sys/ioctl.h>
#endif

	/*
	 *	GLOBAL VARIABLES
	 */

IPixel ** screen_image;
SPixel ** real_screen;

WinInfo root_window;

static void SetBetween (i, min, max)
int * i;
int min, max;
{
	if (* i < min)
		* i = min;
	else if (* i > max)
		* i = max - 1;
}
	/*
	 *	FUNCTIONS
	 */

char ** AllocScreen (width, height, size)
int width, height, size;
{
	char ** scr;
	int x;

	scr = (char **) doalloc ((unsigned) width * sizeof (char *));

	for (x = 0; x < width; x ++)
		scr [x] = (char *) doalloc (height * size);
	
	return scr;
}

bool AtBottum (win)
WinInfo win;
{
	return ! win-> scrollbar || win-> wd_start_y == win-> savelines;
}

void ScrollDown (win, lines)
WinInfo win;
int lines;
{
	if (! win-> scrollbar)
		return;
	
	win-> wd_start_y += lines;
	if (win-> wd_start_y > win-> savelines)
		win-> wd_start_y = win-> savelines;
	
	RefreshWindow (win);
	DrawScrollBar (win);
	Refresh ();
}

void ScrollUp (win, lines)
WinInfo win;
int lines;
{
	if (! win-> scrollbar)
		return;
	
	win-> wd_start_y -= lines;
	if (win-> wd_start_y < 0)
		win-> wd_start_y = 0;
	
	RefreshWindow (win);
	DrawScrollBar (win);
	Refresh ();
}

void DrawScrollBar (win)
WinInfo win;
{
	int start, end;
	int y;

	if (! win-> scrollbar)
		return;
	
	start = (int) (win-> mult * win-> wd_start_y + 0.5);
	end = (int) (win-> mult * (win-> wd_start_y + win-> si_height) + 0.5);

	for (y = 0; y < win-> si_height; y ++)
		SiPut (win, win-> si_scroll_x, y + win-> si_start_y, ':',
						False, False);
	
	if (end >= win-> si_height)
		end --;

	for (y = start; y <= end; y ++)
		SiPut (win, win-> si_scroll_x, y + win-> si_start_y, '|',
				False, False);
}

WinInfo OpenBaseWindow (x, y, width, height)
int x, y;
int width, height;
{
	WinInfo base;

	base = OpenWindow ((WinInfo) 0,
			   0, 0,
			   width, height,
			   0, NO_BOX, 0);
	return base;
}

WinInfo OpenMapWindow (parent, sx, sy, iw, ih, widthp, heightp)
WinInfo parent;
int sx, sy;
int iw, ih;
int *widthp, *heightp;
{
	int lines;
	WinInfo win;

	lines = screen_rows - sy - 1 - EMPIRE_HEIGHT;
	if (no_empwin)
		lines += EMPIRE_HEIGHT + 1;


	win = OpenWindow (parent,
			  sx, sym
			  screen_cols - sx,
			  lines,
			  0,
			  NO_BOX,
			  0);
	if (! no_empwin)
		LowerWindow (win);

	*widthp = screen_cols - sx + 2;
	*heightp = lines;
	return win;
}

WinInfo OpenMessageWindow (parent, iw, widthp)
WinInfo parent;
int iw;
int *widthp;
{
	*widthp = screen_cols - CENSUS_WIDTH - 1;

	return OpenWindow (parent,
			   CENSUS_WIDTH + 1, 0,
			   *widthp, MES_HEIGHT,
			   0, LOWER_BOX, 0);
}
		   
WinInfo OpenCensusWindow (win)
WinInfo win;
{
	return OpenWindow (win, 0, 0, CENSUS_WIDTH, screen_rows,
			   0, RIGHT_BOX, 0);
}

WinInfo OpenVersionWindow (parent, x, y)
WinInfo parent;
int x, y;
{
	WinInfo win;
	win = OpenWindow (map_win, 0, 0, x, y, CHARS, MENU, 0);

	PrintB (ver_win, 19, 1, "-=[ TCEMP ]=-");
	return win;
}

    
WinInfo OpenWindow (parent, x, y, width, height, base, box, savelines)
WinInfo parent;
int x, y, width, height;
int base, box;
{
	WinInfo newwin;
	int xp, yp;
	int dx, dy;
	int ex, ey;
	int sx;

	HideCursor ();

	newwin = (WinInfo) doalloc ((unsigned) sizeof (WININFO));
	newwin-> parent = parent;
	newwin-> box = box;
	newwin-> savelines = savelines;

	newwin-> si_max_x = width;
	newwin-> si_max_y = height;

	newwin-> si_height = height;
	newwin-> si_width = width;

	newwin-> wd_max_x = width;
	newwin-> wd_max_y = height + savelines;

	newwin-> si_start_x = 0;
	newwin-> si_start_y = 0;
	
	if (parent == (WinInfo) 0)
	{
		newwin-> offset_x = x;
		newwin-> offset_y = y;
	}
	else
	{
			/*
			 *	Perhaps we should leave out the start(x,y)
			 */

		newwin-> offset_x = parent-> offset_x + x + parent-> si_start_x;
		newwin-> offset_y = parent-> offset_y + y + parent-> si_start_y;
	}

	if (LEFT_BORDER (box))
	{
		newwin-> si_max_x ++;
		newwin-> si_start_x ++;
	}

	if (UPPER_BORDER (box))
	{
		newwin-> si_max_y ++;
		newwin-> si_start_y ++;
	}

	if (RIGHT_BORDER (box))
		newwin-> si_max_x ++;

	if (LOWER_BORDER (box))
		newwin-> si_max_y ++;

	if (savelines > 0)
	{
		newwin-> scrollbar = True;
		newwin-> si_scroll_x = newwin-> si_start_x;
		newwin-> si_start_x ++;
		newwin-> si_max_x ++;
		newwin-> mult = (double) height / (double) (savelines + height);
	}
	else
		newwin-> scrollbar = False;

	newwin-> wd_start_y = 0;

			/*
			 *	Do not let the window fall of the screen
			 */

	if (newwin-> si_max_x + newwin-> offset_x >= screen_cols)
		newwin-> offset_x = screen_cols - newwin-> si_max_x;
	
	if (newwin-> si_max_y + newwin-> offset_y >= screen_rows)
		newwin-> offset_y = screen_rows - newwin-> si_max_y;

	newwin-> wd_pixels = (SPixel **) AllocScreen (newwin-> wd_max_y, 
				newwin-> wd_max_x, sizeof (SPixel));

	newwin-> si_pixels = (WPixel **) AllocScreen (newwin-> si_max_y,
				newwin-> si_max_x, sizeof (WPixel));

	/* Allocate space for wd_pixels */


	for (x = 0; x < newwin-> wd_max_x; x ++)
		for (y = 0; y < newwin-> wd_max_y; y ++)
			newwin-> wd_pixels [y][x] = (SPixel) doalloc
					((unsigned) sizeof (SPIXEL));
			/*
			 *	Overlay window.
			 */

	for (x = 0; x < newwin-> si_max_x; x ++)
		for (y = 0; y < newwin-> si_max_y; y ++)
		{
			WPixel new_pixel;
			IPixel pixel;

			pixel = screen_image [y + newwin-> offset_y]
					     [x + newwin-> offset_x];

			new_pixel = (WPixel) doalloc ((unsigned)
							sizeof (WPIXEL));

			newwin-> si_pixels [y][x] = new_pixel;
			
			new_pixel-> above = (WPixel) 0;
			new_pixel-> parent = newwin;

			if (pixel-> pixel_info != (WPixel) 0)
				pixel-> pixel_info-> above = new_pixel;

			new_pixel-> under = pixel-> pixel_info;

			pixel-> pixel_info = new_pixel;
			pixel-> parent = newwin;
		}
			
			/*
			 *	Draw Box
			 */
		
	if (UPPER_BORDER (box))
		for (x = 0; x < newwin-> si_max_x; x ++)
			SiPut (newwin, x, 0, ' ', True, False);

	if (LOWER_BORDER (box))
		for (x = 0; x < newwin-> si_max_x; x ++)
			SiPut (newwin, x, newwin-> si_max_y - 1, ' ',
						True, False);

	if (LEFT_BORDER (box))
		for (y = 0; y < newwin-> si_max_y; y ++)
			SiPut (newwin, 0, y, ' ', True, False);

	if (RIGHT_BORDER (box))
		for (y = 0; y < newwin-> si_max_y; y ++)
			SiPut (newwin, newwin-> si_max_x - 1, y, ' ',
						True, False);
		
	ClearWindow (newwin);
	DrawScrollBar (newwin);
	RefreshWindow (newwin);

	return newwin;
}

struct sgttyb save_status;
struct sgttyb tc_status;

void Bell ()
{
	putc ('\007', stdout);
	fflush (stdout);
}

void InitTermc (hs1, he1, hs2, he2)
char * hs1, * he1, * hs2, * he2;
{
	int x, y;

#ifdef BSD
	if (gtty (0, & save_status) != 0)
		perror ("gtty");
	if (gtty (0, & tc_status) != 0)
		perror ("gtty");
#else
	ioctl (0, TIOCGETP, & tc_status);
	ioctl (0, TIOCGETP, & save_status);
#endif

	InitTermcap (hs1, he1, hs2, he2);

	tc_status. sg_flags &= ~ ECHO;
	tc_status. sg_flags |= CBREAK;

#ifdef BSD
	if (stty (0, & tc_status) != 0)
		perror ("stty");
#else
	if (ioctl (0, TIOCSETP, & tc_status) < 0)
		perror ("ioctl");
#endif

	signal (SIGINT, SIG_IGN);

	real_screen = (SPixel **)
		AllocScreen (screen_rows, screen_cols, sizeof (SPixel));
	
		/* Clear screen */
	tputs (CL, 1, put);
	for (x = 0; x < screen_cols; x ++)
		for (y = 0; y < screen_rows; y ++)
		{
			real_screen [y][x] = (SPixel) doalloc (sizeof (SPIXEL));
			real_screen [y][x]-> cont = ' ';
			real_screen [y][x]-> reversed = False;
			real_screen [y][x]-> underlined = False;
		}
	
	screen_image = (IPixel **)
		AllocScreen (screen_rows, screen_cols, sizeof (IPixel));
	
	for (x = 0; x < screen_cols; x ++)
		for (y = 0; y < screen_rows; y ++)
		{
			screen_image [y][x] = (IPixel)
						doalloc (sizeof (IPIXEL));
			screen_image [y][x]-> pixel_info = (WPixel) 0;
			screen_image [y][x]-> parent = (WinInfo) 0;
		}
}

int last_x = -1;
int last_y = -1;

void SiPut (win, x, y, ch, reversed, underlined)
WinInfo win;
int x, y;
char ch;
bool reversed, underlined;
{
	if (x < 0 || x >= win-> si_max_x || y < 0 || y >= win-> si_max_y)
		return;

	win-> si_pixels [y][x]-> cont = ch;
	win-> si_pixels [y][x]-> reversed = reversed;
	win-> si_pixels [y][x]-> underlined = underlined;
}

void WdPut (win, x, y, ch, reversed, underlined)
WinInfo win;
int x, y;
char ch;
bool reversed, underlined;
{
	if (x < 0 || x >= win-> wd_max_x || y < 0 || y >= win-> wd_max_y)
		return;

	win-> wd_pixels [y][x]-> cont = ch;
	win-> wd_pixels [y][x]-> reversed = reversed;
	win-> wd_pixels [y][x]-> underlined = underlined;
}

	/*
	 *	Print writes on wd_pixels, then calls RefreshWindow
	 *	to copy it into si_pixels
	 */

void Print (win, x, y, str, mode)
WinInfo win;
int x, y;
char * str;
int mode;
{
	int i;

	for (i = 0; * str != '\0'; str ++, i++)
		WdPut (win, x + i, win-> wd_start_y + y, * str, 
				False, mode == BOLD);
	
	RefreshWindowPart (win, x, x + i, y, y + 1);
}

void PrintN (win, x, y, str)
WinInfo win;
int x, y;
const char * str;
{
	Print (win, x, y, str, NORMAL);
}

void PrintB (win, x, y, str)
WinInfo win;
int x, y;
char * str;
{
	Print (win, x, y, str, BOLD);
}

void PrintMarked (win, x, y, str, mode)
WinInfo win;
int x, y;
char * str;
int mode;
{
	int i;

	for (i = 0; * str != '\0'; str ++, i++)
		WdPut (win, x + i, win-> wd_start_y + y, * str, 
				True, mode == BOLD);
	
	RefreshWindowPart (win, x, x + i, y, y + 1);
}

void PrintMarkedN (win, x, y, str)
WinInfo win;
int x, y;
char * str;
{
	PrintMarked (win, x, y, str, NORMAL);
}


void PrintMarkedB (win, x, y, str)
WinInfo win;
int x, y;
char * str;
{
	PrintMarked (win, x, y, str, BOLD);
}


void Pause ()
{
	char ch;

	Refresh ();
	do {
		ch = getchar ();
	}
	while (ch != CNTR ('C') && ch != ' ' && ch != '\n');
}

static bool underl_on = False;
static bool reverse_on = False;

	/*
	 *	Make real_screen look like screen_image
	 */

void Refresh ()
{
	register int x, y;
	SPixel spix;
	WPixel wpix;
	char buf [BUFSIZ];
	int len, sx, sy;
	bool change, set_cursor;
	bool same_char, same_mode, change_mode;
	int last_x;

	extern bool am_flag, ms_flag;

	len = 0;

		/*
		 *	All screen pixels must be allocated.
		 */

	for (y = 0; y < screen_rows; y ++)
	{
		last_x = (y == screen_rows - 1 && am_flag) ? screen_cols - 1
							   : screen_cols;
					      
		for (x = 0; x < last_x; x ++)
		{
			spix = real_screen [y][x];
			wpix = screen_image [y][x]-> pixel_info;

			same_char = spix-> cont == wpix-> cont;
			same_mode = (spix-> reversed == wpix-> reversed) &&
				    (spix-> underlined == wpix-> underlined);
				
			if (same_char && same_mode)	/* No changes */
			{
				if (len != 0)
				{
					buf [len] = '\0';
					fputs (buf, stdout);
					len = 0;
				}

				continue;
			}

			change_mode = (wpix-> reversed != reverse_on) ||
				      (wpix-> underlined != underl_on);

			if (len == 0)	/* nothing buffered yet */
			{
				if (change_mode)
					SetMode (wpix-> reversed,
						     wpix-> underlined);
				if (! ms_flag)
					SetMode (False, False);
				tputs (tgoto (CM, x, y), 1, put);
				if (! ms_flag)
					SetMode (wpix-> reversed,
						     wpix-> underlined);
				buf [len ++] = wpix-> cont;
				continue;
			}
				
			if (change_mode)
			{
				buf [len] = '\0';
				fputs (buf, stdout);
				len = 0;

				SetMode (wpix-> reversed,
						     wpix-> underlined);
			}

			buf [len ++] = wpix-> cont;
			continue;
		}

		if (len == 0)
			continue;

		buf [len] = '\0';
		fputs (buf, stdout);
		len = 0;
	}

	for (y = 0; y < screen_rows; y ++)
		for (x = 0; x < screen_cols; x ++)
		{
			spix = real_screen [y][x];
			wpix = screen_image [y][x]-> pixel_info;

			spix-> cont = wpix-> cont;
			spix-> reversed = wpix-> reversed;
			spix-> underlined = wpix-> underlined;
		}

	SetMode (False, False);
	CursorUp ();
	fflush (stdout);
}

	/*
	 *	rewritten (911029)
	 *
	 *	Clear wd_pixels
	 */

void ClearWindow (win)
WinInfo win;
{
	int x, y;
	int sx;

	for (x = 0; x < win-> wd_max_x; x ++)
		for (y = 0; y < win-> wd_max_y; y ++)
			WdPut (win, x, y, ' ', False, False);

	RefreshWindow (win);
}

int current_x = 10;
int current_y = 10;
static bool cursor_visible = False;

void CursorUp ()
{
	tputs (tgoto (CM, screen_cols - 1, 0), 1, put);
}

	/*
	 *	Turning one mode of, results often in disabling all 
	 *	output modes.
	 */

void SetMode (reverse, underl)
bool reverse, underl;
{
	if (underl == underl_on && reverse == reverse_on)
		return;
	
	if (underl && reverse)
	{
		if (! underl_on)
		{
			tputs (US, 1, put);
			underl_on = True;
		}

		if (! reverse_on)
		{
			tputs (HLS, 1, put);
			reverse_on = True;
		}

		return;
	}

	if (! underl && ! reverse)
	{
		if (underl_on)
		{
			tputs (UE, 1, put);
			underl_on = False;
		}

		if (reverse_on)
		{
			tputs (HLE, 1, put);
			reverse_on = False;
		}

		return;
	}

	if (! reverse && reverse_on)
	{
		tputs (HLE, 1, put);
		reverse_on = False;
	}

	if (! underl && underl_on)
	{
		tputs (UE, 1, put);
		underl_on = False;
	}

	if (reverse)
	{
		reverse_on = True;
		tputs (HLS, 1, put);
	}

	if (underl)
	{
		underl_on = True;
		tputs (US, 1, put);
	}
}

void ShowCursor ()
{
	SPixel si_pixel;

	if (! cursor_visible)
	{
		si_pixel = real_screen [current_y][current_x];
		SetMode (! si_pixel-> reversed, si_pixel-> underlined);
		tputs (tgoto (CM, current_x, current_y), 1, put);
		putchar (si_pixel-> cont);
		cursor_visible = True;
		CursorUp ();
		fflush (stdout);
	}
}

void HideCursor ()
{
	SPixel si_pixel;

	if (cursor_visible)
	{
		si_pixel = real_screen [current_y][current_x];
		SetMode (si_pixel-> reversed, si_pixel-> underlined);
		cursor_visible = False;
		tputs (tgoto (CM, current_x, current_y), 1, put);
		putchar (si_pixel-> cont);
		CursorUp ();
		fflush (stdout);
	}
}

void DestroyWindow (win)
WinInfo win;
{
	int x, y, ox, oy;
	WPixel wpixel;

	ox = win-> offset_x;
	oy = win-> offset_y;

	for (y = 0; y < win-> si_max_y; y ++)
		for (x = 0; x < win-> si_max_x; x ++)
		{
			wpixel = win-> si_pixels [y][x];
			screen_image [y + oy][x + ox]-> pixel_info =
						wpixel-> under;
			if (wpixel-> under != (WPixel) 0)
			{
				wpixel-> under-> above = (WPixel) 0;
				screen_image [y + oy][x + ox]-> parent =
						wpixel-> under-> parent;
			}
			else
				screen_image [y + oy][x + ox]-> parent =
						(WinInfo) 0;
		}
	

	for (x = 0; x < win-> si_max_x; x ++)
		for (y = 0; y < win-> si_max_y; y ++)
			(void) free ((char *) win-> si_pixels [y][x]);

	for (y = 0; y < win-> si_max_y; y ++)
		free ((char *) win-> si_pixels [y]);
	free ((char *) win-> si_pixels);

	for (x = 0; x < win-> wd_max_x; x ++)
		for (y = 0; y < win-> wd_max_y; y ++)
			(void) free ((char *) win-> wd_pixels [y][x]);

	for (y = 0; y < win-> wd_max_y; y ++)
		free ((char *) win-> wd_pixels [y]);
	free ((char *) win-> wd_pixels);

	(void) free ((char *) win);
}

WinInfo FindWindow (x, y)
{
	return screen_image [y][x]-> parent;
}

void Redraw ()
{
	int x, y;

	/* Clear screen */

	tputs (CL, 1, put);
	fflush (stdout);
	for (x = 0; x < screen_cols; x ++)
		for (y = 0; y < screen_rows; y ++)
		{
			real_screen [y][x]-> cont = ' ';
			real_screen [y][x]-> reversed = False;
			real_screen [y][x]-> underlined = False;
		}
	
	Refresh ();
}

	/*
	 *	Dump window to "window.dump"
	 */

void DumpLine (fp, length)
FILE * fp;
int length;
{
	while (length -- > 0)
		putc ('*', fp);
	putc ('\n', fp);
}

void DumpWindow (win)
WinInfo win;
{
	int x, y;
	FILE * fp;
	bool reversed, underlined;

	fp = fopen ("window.dump", "w");
	if (fp == (FILE *) 0)
		return;

	fprintf (fp, "Window dump:\n\n");

	fprintf (fp, "Part 1:\tsavelines= %d\n", win-> savelines);
	fprintf (fp, "\tscrollbar= %s\n", win-> scrollbar ? "True" : "False");
	fprintf (fp, "\tmult= %.2f\n", win-> mult);
	fprintf (fp, "\tbox= 0x%02d", win-> box);
	fprintf (fp, "\toffset= (%d,%d)\n", win-> offset_x, win-> offset_y);
	fprintf (fp, "\tparent= 0x%ld\n", (long) win-> parent);


	fprintf (fp, "Part2:\tsi_max= (%d,%d)\n", win-> si_max_x,
					win-> si_max_y);
	fprintf (fp, "\tsi_start= (%d,%d)\n", win-> si_start_x,
					win-> si_start_y);
	fprintf (fp, "\tsi_size= (%dx%d)\n", win-> si_width, win-> si_height);
	fprintf (fp, "\tscroll_x= %d\n", win-> si_scroll_x);


	reversed = False;
	underlined = False;

	DumpLine (fp, win-> si_max_x + 2);

	for (y = 0; y < win-> si_max_y; y ++)
	{
		WPixel pix;

		putc ('*', fp);
		for (x = 0; x < win-> si_max_x; x ++)
		{	
			pix = win-> si_pixels [y][x];

			if (pix-> reversed != reversed)
			{
				if (reversed)
					fputs (HLE, fp);
				else
					fputs (HLS, fp);

				reversed = ! reversed;
			}

			if (pix-> underlined != underlined)
			{
				if (underlined)
					fputs (UE, fp);
				else
					fputs (US, fp);
				
				underlined = ! underlined;
			}
		
			putc (pix-> cont, fp);
		}

		if (reversed)
		{
			reversed = False;
			fputs (HLE, fp);
		}

		if (underlined)
		{
			underlined = False;
			fputs (UE, fp);
		}

		putc ('*', fp);
		putc ('\n', fp);
	}

	DumpLine (fp, win-> si_max_x + 2);

	fprintf (fp, "Part 3:\twd_max= (%d,%d)\n", win-> wd_max_x,
			win-> wd_max_y);
	fprintf (fp, "\twd_start_y= %d\n\n", win-> wd_start_y);

	reversed = False;
	underlined = False;

	DumpLine (fp, win-> wd_max_x + 2);

	for (y = 0; y < win-> wd_max_y; y ++)
	{
		SPixel pix;

		putc ('*', fp);
		for (x = 0; x < win-> wd_max_x; x ++)
		{	
			pix = win-> wd_pixels [y][x];

			if (pix-> reversed != reversed)
			{
				if (reversed)
					fputs (HLE, fp);
				else
					fputs (HLS, fp);

				reversed = ! reversed;
			}

			if (pix-> underlined != underlined)
			{
				if (underlined)
					fputs (UE, fp);
				else
					fputs (US, fp);
				
				underlined = ! underlined;
			}
		
			putc (pix-> cont, fp);
		}

		if (reversed)
		{
			reversed = False;
			fputs (HLE, fp);
		}

		if (underlined)
		{
			underlined = False;
			fputs (UE, fp);
		}

		putc ('*', fp);
		putc ('\n', fp);
	}

	DumpLine (fp, win-> wd_max_x + 2);

	/*
	 *	Message ("Window dumped in window.dump");
	 */

	fclose (fp);
}

	/*
	 *	Copies the contens of wd_pixels to si_pixels
	 */

void RefreshWindowPart (win, sx, ex, sy, ey)
WinInfo win;
int sx, ex, sy, ey;
{

	int x, y;
	WPixel si_pixel;
	SPixel wd_pixel;

	SetBetween (& sx, 0, win-> si_max_x);
	SetBetween (& ex, 0, win-> si_max_x);
	SetBetween (& sy, 0, win-> si_max_y - win-> si_start_y);
	SetBetween (& ey, 0, win-> si_max_y - win-> si_start_y);

	for (y = sy; y < ey; y ++)
		for (x = sx; x < ex; x ++)
		{
			si_pixel = win-> si_pixels [y + win-> si_start_y]
						   [x + win-> si_start_x];
			wd_pixel = win-> wd_pixels [y + win-> wd_start_y]
						   [x];

			si_pixel-> cont       = wd_pixel-> cont;
			si_pixel-> reversed   = wd_pixel-> reversed;
			si_pixel-> underlined = wd_pixel-> underlined;

		}
}


void RefreshWindow (win)
WinInfo win;
{
	RefreshWindowPart (win, 0, win-> si_width, 0, win-> si_height);
}

void Scroll (win, lines)
WinInfo win;
int lines;
{
	int y, x;
	int size;

	/*
	if (! win-> scrollbar)
		return;
	*/
	
		/*
		 *	Set window at end of data
		 */

	if (win-> wd_start_y != win-> savelines)
	{
		win-> wd_start_y = win-> savelines;
		DrawScrollBar (win);
	}

	/*
	size = win-> wd_max_x * sizeof (WPIXEL);
	*/

	for (y = lines; y < win-> wd_max_y; y ++)
		for (x = 0; x < win-> wd_max_x; x ++)
		{
			win-> wd_pixels [y - lines][x]-> cont =
				win-> wd_pixels [y][x]-> cont;
			win-> wd_pixels [y - lines][x]-> reversed =
				win-> wd_pixels [y][x]-> reversed;
			win-> wd_pixels [y - lines][x]-> underlined =
				win-> wd_pixels [y][x]-> underlined;
		}
		/*

		bcopy ((char *) win-> wd_pixels [y],
		       (char *) win-> wd_pixels [y - lines],
		       size);

		*/
	
	/*
	for (y = win-> wd_max_y - lines + 1; y < win-> wd_max_y; y ++)
	*/
	for (y = win-> wd_max_y - lines; y < win-> wd_max_y; y ++)
		for (x = 0; x < win-> wd_max_x; x ++)
		{
			win-> wd_pixels [y] [x]-> cont = ' ';
			win-> wd_pixels [y] [x]-> reversed = False;
			win-> wd_pixels [y] [x]-> underlined = False;
		}
	
	RefreshWindow (win);
}

WinInfo OpenRelToRoot (win, x, y, width, height, box, savelines)
WinInfo win;
int x, y, width, height, savelines;
int box;
{
	return OpenWindow (root_win, x + win-> offset_x, y + win-> offset_y,
			width, height, 0, box, savelines);
}

void FlushWindow (win)
WinInfo win;
{
	RefreshWindow (win);
}

void SetToBot (win)
WinInfo win;
{
	win-> wd_start_y = win-> savelines;
}

void SetToTop (win)
WinInfo win;
{
	win-> wd_start_y = 0;
}

void ClearLine (win, y)
WinInfo win;
int y;
{
	PrintN (win, 0, y, Fmt ("%*s", win-> wd_max_x, ""));
}

void FlashWindow (win)
WinInfo win;
{
	RefreshWindow (win);
}

void RaiseWindow (win)
WinInfo win;
{
	int x, y;
	WPixel sip;
	IPixel si;

	for (x = 0; x < win-> si_max_x; x ++)
		for (y = 0; y < win-> si_max_y; y ++)
		{
			sip = win-> si_pixels [y][x];
			if (sip-> above == (WPixel) 0)
				continue;

			si = screen_image [y + win-> offset_y]
					  [x + win-> offset_x];
			
			si-> pixel_info-> above = sip;
			sip-> under-> above = sip-> above;
			sip-> above-> under = sip-> under;
			sip-> under = si-> pixel_info;
			sip-> above = (WPixel) 0;
			si-> parent = win;
			si-> pixel_info = sip;
		}
	
	Refresh ();
}

void LowerWindow (win)
WinInfo win;
{
	int x, y;
	WPixel sip, rip;
	IPixel si;

	for (x = 0; x < win-> si_max_x; x ++)
		for (y = 0; y < win-> si_max_y; y ++)
		{
			sip = win-> si_pixels [y][x];
			si = screen_image [y + win-> offset_y]
					  [x + win-> offset_x];
			rip = root_win-> si_pixels [y + win-> offset_y]
						   [x + win-> offset_x];
			
			if (sip-> above != (WPixel) 0)
				sip-> above-> under = sip-> under;
			else
			{
				si-> pixel_info = sip-> under;
				si-> parent = sip-> under-> parent;
			}
			sip-> under-> above = sip-> above;

			sip-> above = rip-> above;
			if (rip-> above == (WPixel) 0)
			{
				si-> pixel_info = sip;
				si-> parent = win;
			}
			else
				rip-> above-> under = sip;
			
			rip-> above = sip;
			sip-> under = rip;
		}
	
	Refresh ();
}

void LowerAll ()
{
	LowerWindow (empire_win);
	LowerWindow (map_win);
	LowerWindow (census_win);
	LowerWindow (mes_win);
}

void RaiseAll ()
{
	RaiseWindow (empire_win);
	RaiseWindow (map_win);
	RaiseWindow (census_win);
	RaiseWindow (mes_win);
}

void RaiseEmpWin ()
{
	RaiseWindow (empire_win);
}

void LowerEmpWin ()
{
	LowerWindow (empire_win);
}

void QuitTermc ()
{
	int fd;

	tputs (UE, 1, put);
	tputs (HLE, 1, put);
	tputs (CL, 1, put);

	fflush (stdout);

	fd = open ("/dev/tty", 1);
	if (fd < 0)
	{
		perror ("open");
		return;
	}

#ifdef BSD
	if (stty (fd, & save_status) != 0)
		perror ("stty");
#else
	if (ioctl (fd, TIOCSETP, & save_status) < 0)
		perror ("ioctl");
#endif /* BSD */
}


WinInfo OpenEmpireWindow (win, inc_y, inc_width, inc_height, savelines,
			  widthp, heightp)
WinInfo win;
int inc_y, inc_width, inc_height;
int savelines;
int *widthp, *heightp;
{
	WinInfo w;

	*heightp = EMPIRE_HEIGHT + 1;
	*widthp = screen_cols - CENSUS_WIDTH - 1;

	w = OpenWindow (win,
			CENSUS_WIDTH + 1,
			EMPIRE_STARTY,
			*widthp,
			*heightp,
			0,
			UPPER_BOX,
			savelines);
	return w;
}

