/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/util/RCS/mail.c,v 5.3 1996/01/29 08:36:52 jpo Exp $
    $Date: 1996/01/29 08:36:52 $
    $Author: jpo $
    $Id: mail.c,v 5.3 1996/01/29 08:36:52 jpo Exp $
    $Locker:  $
    $Log: mail.c,v $
    Revision 5.3  1996/01/29 08:36:52  jpo
    New mail interface, still needs work

    Revision 5.2  1995/09/08 07:48:44  jpo
    const

 * Revision 5.1  93/03/14  16:52:56  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:24:11  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:45:54  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "xrc.h"
#include "func.h"
#include "nation.h"

#include <sys/times.h>

#define	DELET	0x01
#define	READ	0x02
#define	KEEP	0x04
#define ANSWER	0x08

void MailMenu();
void InfoMailMenu();

#define MA_ANNOUNCEMENT	0x01
#define MA_TELEGRAM	0x02
#define MA_BULLETIN	0x04
#define MA_OWNTELE	0x08
#define	MA_OWNANN	0x10
#define MA_OUTPUT	0x20
#define MA_PRODUCT	0x40
#define MA_UNKNOWN	0x80

#define MA_ALL		0xff

#define MA_MAX		7

char * mail_str [] =
{
	"announcements",
	"telegrams",
	"bulletins",
	"own telegrams",
	"own announcements",
	"ouput of programs",
	"production reports",
	(char *) 0
};

typedef struct s_mail *Mail;

struct s_mail
{
	char * header;
	Strings strings;
	int flags;
	Mail next;
	int type;
};

static Mail head = (Mail) 0;

static void SetMailType (new)
Mail new;
{
	if (StrEQ (new-> header, "> Anno"))
		new-> type = MA_ANNOUNCEMENT;
	else if (StrEQ (new-> header, "> Telegram"))
		new-> type = MA_TELEGRAM;
	else if (StrEQ (new-> header, "> BULL"))
		new-> type = MA_BULLETIN;
	else if (StrEQ (new-> header, ">>> Te"))
		new-> type = MA_OWNTELE;
	else if (StrEQ (new-> header, ">>> Ann"))
		new-> type = MA_OWNANN;
	else if (StrEQ (new-> header, "> Production"))
		new-> type = MA_PRODUCT;
	else if (StrEQ (new-> header, "==="))
		new-> type = MA_OUTPUT;
	else
		new-> type = MA_UNKNOWN;
}

static char * Author (ptr)
Mail ptr;
{
	static char buf [100];
	char * author, * ptri;

	author = (char *) 0;
	if (StrEQ (ptr-> header, "> Telegram from"))
	{
		ptri = ptr-> header + 15;
		if (ScanFmt ((ConstVP)& ptri, buf, "-a-zA-Z _0-9"))
			author = buf;
	}
	else if (StrEQ (ptr-> header, "> Announcement from"))
	{
		ptri = ptr-> header + 19;
		if (ScanFmt ((ConstVP)& ptri, buf, "-a-zA-Z _0-9"))
			author = buf;
	}

	return author;
}

static void ConcatMail (types)
int types;
{
	Mail ptr, prev, next;
	bool concat;
	char * author;

	if (head == (Mail) 0)
		return;

	prev = head;
	ptr = head-> next;

	while (ptr != (Mail) 0)
	{
		if (ptr-> type == prev-> type && ptr-> type & types)
		{
			concat = False;

			switch (ptr-> type)
			{

			case MA_BULLETIN:
				concat = True;
				break;
			
			case MA_ANNOUNCEMENT:
			case MA_TELEGRAM:
				author = Str (Author (ptr));
				concat = strcmp (author, Author (prev)) == 0;
				free (author);
				break;

			default:
				break;
			}

			if (concat)
			{
				JoinStrings (prev-> strings, ptr-> strings);
				prev-> next = ptr-> next;
				next = ptr-> next;
				FreeStrings (ptr-> strings);
				free (ptr-> header);
				free ((char *) ptr);
				ptr = next;
			}
			else
			{
				prev = ptr;
				ptr = ptr-> next;
			}
		}
		else
		{
			prev = ptr;
			ptr = ptr-> next;
		}
	}
}

void SaveMail (fp)
FILE *fp;
{
	Mail ptr;
	const char *line;

	for (ptr = head; ptr != (Mail) 0; ptr = ptr-> next)
	{
		if (((ptr-> flags & READ) != READ) ||
			    ((ptr-> flags & KEEP) == KEEP))
		{
			fprintf (fp, "%d %d %s\n",
				StringsSize (ptr-> strings),
				ptr-> flags,
				ptr-> header);
			
			InitStringList (ptr-> strings);
			while ((line = GetNextString (ptr-> strings))
							!= (char *) 0)
				fprintf (fp, "%s\n", line);
		}
	}

	fprintf (fp, "END OF MAILBOX\n");
}

void RestoreMail (fp)
FILE *fp;
{
	Mail tail, new;
	char buffer [BUFSIZ];
	char *ptr;
	int lines;

	tail = head;
	if (head != (Mail) 0)
		while (head-> next != (Mail) 0)
			head = head-> next;

	for (;;)
	{
		(void) fgets (buffer, BUFSIZ, fp);
		if (strncmp (buffer, "END OF MAILBOX", 14) == 0)
			return;

		new = (Mail) doalloc ((unsigned) sizeof (struct s_mail));
		new-> next = (Mail) 0;

		if (head == (Mail) 0)
		{
			head = new;
			tail = new;
		}
		else
		{
			tail-> next = new;
			tail = new;
		}

		ptr = buffer;
		(void) ScanDigit ((ConstVP)& ptr, & lines);

		(void) ScanDigit ((ConstVP)& ptr, & (new-> flags));

		SkipBlank ((ConstVP)& ptr);
		ptr [strlen (ptr) - 1] = '\0';

		new-> header = Str (ptr);
		new-> strings = InitStrings ();

		SetMailType (new);
		
		while ((lines --) > 0)
		{
			(void) fgets (buffer, BUFSIZ, fp);
			buffer [strlen (buffer) - 1] = '\0';
			AddString (new-> strings, buffer);
		}
	}
}

void AddMail (strings, header)
Strings strings;
const char * header;
{
	Mail ptr, tail = NULL, new;

	new = (Mail) doalloc ((unsigned) sizeof (struct s_mail));
	new-> header = Str (header);
	new-> strings = InitStrings ();
	new-> next = (Mail) 0;
	new-> flags = 0;

	SetMailType (new);
	JoinStrings (new-> strings, strings);

	if (head == (Mail) 0)
		head = new;
	else
	{
		for (ptr = head; ptr != (Mail) 0; ptr = ptr-> next)
			tail = ptr;

		tail-> next = new;
	}

	return;
}

static bool FindTel (header)
char *header;
{
	Mail ptr;

	for (ptr = head; ptr != (Mail) 0; ptr = ptr-> next)
		if (! strcmp (ptr-> header, header))
			return True;

	return False;
}


static bool FScanMessage (mtype)
const char *mtype;
{
	char *header;
	char *ptr;
	char *ans;
	Mail tail, new = NULL;
	bool dubble, lasttel, lastline;

	FeedEmpire (mtype, PRINT);
	header = ReadEmpire (DONT_PRINT);

	if (StrEQ (header, "No messages"))
	{
		(void) WaitForPrompt (PRINT);
		return False;
	}
	if (StrEQ (header, "No telegrams"))
	{
		(void) WaitForPrompt (PRINT);
		return False;
	}

	PrintAtEmpire (Fmt("Empiretool: scanning %s", mtype));

	while (*header != '>') {
		header = ReadEmpire (DONT_PRINT);
		if (EmpireStatus () == E_COMMAND)
			return True;
	}
	
	tail = head;
	if (tail != (Mail) 0)
		while (tail-> next != (Mail) 0)
			tail = tail-> next;

	lasttel = False;
	while (! lasttel)
	{
		if (FindTel (header))
			dubble = True;
		else
		{
			new = (Mail) doalloc ((unsigned)
					      sizeof (struct s_mail));
			new-> header = Str (header);
			new-> strings = InitStrings ();
			new-> next = (Mail) 0;
			new-> flags = 0;
			SetMailType (new);
			dubble = False;
		}

		lastline = False;
		while (! lastline)
		{
			ptr = ReadEmpire (DONT_PRINT);

			if (EmpireStatus () != E_PRINTING)
			{
				if (EmpireStatus () == E_COMMAND)
				{
					Message (Fmt("%s tels out of sync",
						     mtype));
					Bell ();
					if (new)
					    free ((char *) new);
					return True;
				}

				lastline = True;
				lasttel = True;
			}
			else
			if (*ptr == '>')
			{
				lastline = True;
				header = ptr;
			}
			else if (! dubble)
				AddString (new-> strings, ptr);
		}
		if (dubble)
			continue;

		if (tail == (Mail) 0)
		{
			tail = new;
			head = new;
		}
		else
		{
			tail-> next = new;
			tail = new;
		}
	}

	switch (xrc. delete_mail)
	{

	case DO_YES:
		ans = "yes";
		break;
	
	case DO_NO:
		ans = "no";
		break;

	case DO_CONFIRM:
	default:
		if (Confirm ("Delete empire mailbox ?", True))
			ans = "yes";
		else
			ans = "no";
		break;
	}

	FeedEmpire (ans, DONT_PRINT);
	(void) WaitForPrompt (PRINT);
	return True;
}

bool FScanReadWirs ()
{
    return FScanMessage ("wire");
}

bool FScanReadTels ()
{
    return FScanMessage ("read");
}

static char *Entry (ptr)
Mail ptr;
{
	return Fmt ("%c%c%c %-3d %s",
		((ptr-> flags & DELET) == DELET) ? 'D' :
			(((ptr-> flags & KEEP) == KEEP) ? 'K' : ' '),
		((ptr-> flags & READ)  == READ)  ? 'R' : ' ',
		((ptr-> flags & ANSWER) == ANSWER) ? 'A' : ' ',
		StringsSize (ptr-> strings),
		ptr-> header);
}

struct maildata {
    Mail head;
    int type;
    int x, y;
};

static void ReadMail (strings, ind, data)
Strings strings;
int ind;
void *data;
{
    struct maildata *mptr = (struct maildata *) data;
    int i;
    Mail ptr;

    if (ind < 0) return;
    for (ptr = mptr -> head, i = ind; ptr && i > 0; ) {
	while (ptr && (ptr -> type & mptr -> type) == 0)
	    ptr = ptr -> next;
	if (ptr == NULL)
	    return;
	ptr = ptr -> next;
	i --;
    }
    ViewPagerStrings(ptr -> header, ptr -> strings, map_win,
		     mptr -> x + 2, mptr -> y + 2);
    ptr -> flags |= READ;
    ChangeString (strings, ind, Entry(ptr));
}

static void DeleteMail (strings, ind, data)
Strings strings;
int ind;
void *data;
{
    struct maildata *mptr = (struct maildata *)data;
    Mail ptr;
    int i;

    if (ind < 0) return;
    for (ptr = mptr -> head, i = ind; ptr && i > 0; ) {
	while (ptr && (ptr -> type & mptr -> type) == 0)
	    ptr = ptr -> next;
	if (ptr == NULL)
	    return;
	ptr = ptr -> next;
	i --;
    }
    if ((ptr -> flags & KEEP) == KEEP) {
	ptr -> flags &= ~KEEP;
	ptr -> flags |= DELET;
    }
    else if ((ptr -> flags & DELET) == DELET) 
	ptr -> flags &= ~DELET;
    else
	ptr -> flags |= DELET;

    ChangeString (strings, ind, Entry(ptr));
}

static void KeepMail (strings, ind, data)
Strings strings;
int ind;
void *data;
{
    struct maildata *mptr = (struct maildata *)data;
    Mail ptr;
    int i;

    if (ind < 0) return;
    for (ptr = mptr -> head, i = ind; ptr && i > 0; ) {
	while (ptr && (ptr -> type & mptr -> type) == 0)
	    ptr = ptr -> next;
	if (ptr == NULL)
	    return;
	ptr = ptr -> next;
	i --;
    }
    if ((ptr -> flags & DELET) == DELET) {
	ptr -> flags &= ~DELET;
	ptr -> flags |= KEEP;
    }
    else if ((ptr -> flags & KEEP) == KEEP) 
	ptr -> flags &= ~KEEP;
    else
	ptr -> flags |= KEEP;

    ChangeString (strings, ind, Entry(ptr));
}

static FuncList read_fnxs[] = {
    { "Done", DONEFUNC, NULL },
    { "Concat", CONCATFUNC, NULL },
    { "Read New Mail", NEWFUNC, NULL },
    { "Read", READFUNC, ReadMail },
    { "Delete", DELETEFUNC, DeleteMail },
    { "Keep", KEEPFUNC, KeepMail },
    { NULL }
};


void ShowMail (x, y, types)
int x, y, types;
{
	Strings strings;
	register Mail ptr;
	Mail prev, next;
	int i, j;
	int func;
	bool rescan, cont;
	char * reply;
	struct maildata mdata;

	if (head == (Mail) 0)
	{
		Message ("No messages for you at the moment");
		return;
	}
	while (1) {
	    strings = InitStrings ();
	    for (ptr = head, i = 0; ptr != (Mail) 0; ptr = ptr-> next)
		if (ptr-> type & types)
		    AddStringID (strings, Entry (ptr), i ++);

	    if (StringsSize (strings) == 0) {
		Message ("No messages in this group");
		Bell ();
		FreeStrings (strings);
		return;
	    }

	    mdata.head = head;
	    mdata.type = types;
	    mdata.x = x;
	    mdata.y = y;
	    func = MakePickDialog (strings, "Mail", read_fnxs, &mdata,
				   map_win, x, y, True);
	    FreeStrings (strings);

	    switch (func) {
	    case CONCATFUNC:
		ConcatMail (types);
		continue;

	    case DONEFUNC:
	    case CANCEL:
		break;

	    case NEWFUNC:
		FScanReadTels ();
		FScanReadWirs ();
		continue;
	    }
	    break;
	}
	
	/* delete messages */

	ptr = head;
	prev = (Mail) 0;

	while (ptr != (Mail) 0)
	{
		if ((ptr-> flags & DELET) == DELET)
		{
			next = ptr-> next;

			if (prev == (Mail) 0)
				head = ptr-> next;
			else
				prev-> next = ptr-> next;
			
			FreeStrings (ptr-> strings);
			free (ptr-> header);
			free ((char *) ptr);
			ptr = next;
		}
		else
		{
			prev = ptr;
			ptr = ptr-> next;
		}
	}
}

void ShowHeadLines (x, y)
int x, y;
{
	Strings strings;

	FeedEmpire ("headlines", DONT_PRINT);

	strings = InitStrings ();
	ReadEmpireStrings (strings);
	ViewPagerStrings ("Headlines", strings, map_win, x, y);
	FreeStrings (strings);
}

static void Telegram (strings, command)
Strings strings;
char *command;
{
	int chars, i;
	Strings stripped;
	const char * ptr;

	stripped = StripStrings (strings);
		
	FeedEmpire (command, PRINT);
	(void) WaitForPrompt (PRINT);
	chars = 0;

	InitStringList (stripped);
	while ((ptr = GetNextString (stripped)) != (char *) 0)
	{
		i = strlen (ptr) + 1;
		if (chars + i > (510 * (land_units +1 )))
		{
			FeedEmpire (".", PRINT);
			(void) WaitForPrompt (PRINT);
			FeedEmpire (command, PRINT);
			(void) WaitForPrompt (PRINT);
			FeedEmpire (ptr, PRINT);
			chars = i;
		}
		else
		{
			FeedEmpire (ptr, PRINT);
			(void) WaitForPrompt (PRINT);
			chars += i;
		}
	}

	FreeStrings (stripped);

	FeedEmpire (".", PRINT);
	(void) WaitForPrompt (PRINT);
}
		
bool SendTelegram (x, y, country)
int x, y;
char *country;
{
	Strings strings, stripped;
	bool keep;
	int i;

	strings = InitStrings ();
	AddString (strings, "Subject:");
	AddString (strings, Fmt ("Date: %s", DateFmt (time ((time_t *) 0))));
	AppendSignature (strings);
	if ((strings = EditText (Fmt ("Telegram for %s", country),
				 strings, "Send", map_win, x, y)) == NULL) {
	       Message ("Telegram not sent");
	       return False;
	}

	
	Telegram (strings, Fmt ("telegram %s", country));

	switch (xrc. keep_send)
	{

	case DO_YES:
		keep = True;
		break;
	
	case DO_NO:
		keep = False;
		break;

	case DO_CONFIRM:
	default:
		keep = Confirm ("Keep a copy of this message ?", True);
		break;
	}

	if (keep)
	{
		stripped = StripStrings (strings);
		AddMail (stripped, Fmt (">>> Telegram to %s (%s)",
			country, DateFmt (time ((time_t *) 0))));
		FreeStrings (stripped);
	}

	FreeStrings (strings);
	Message ("Telegram send");

	return True;
}

void Announce (x, y)
int x, y;
{
	Strings strings, stripped;
	bool keep;
	int i;

	strings = InitStrings ();
	AddString (strings, "Subject:");
	AddString (strings, Fmt ("Date: %s", DateFmt (time ((time_t *) 0))));
	AppendSignature (strings);

	if ((strings = EditText ("-=[ Announcement ]=-", strings,
				 "Send",  map_win, x, y)) == NULL) {
		FreeStrings (strings);
		Message ("Announcement not send");
		return;
	}


	switch (xrc. keep_announce)
	{

	case DO_YES:
		keep = True;
		break;
	
	case DO_NO:
		keep = False;
		break;

	case DO_CONFIRM:
	default:
		keep = Confirm ("Keep a copy of this announcement ?", True);
		break;
	}

	if (keep)
	{
		stripped = StripStrings (strings);
		AddMail (stripped, Fmt (">>> Announcement (%s)",
			DateFmt (time ((time_t *) 0))));
		FreeStrings (stripped);
	}

	Telegram (strings, "announce");
	FreeStrings (strings);
	Message ("announcement send");
	return;
}

static const char *news_menu [] =
{
	"new news",
	"one day",
	"two days",
	"three days",
	"four days",
	(char *) 0
};

void News (x, y)
int x, y;
{
	Strings strings;
	int r;
	const char *command;

	strings = InitStrings ();
	AddStringsID (strings, news_menu, 5, 0);
	r = ChooseMenu (strings, "News", map_win, x, y, NULL);
	FreeStrings (strings);
	if (r < 0)
	{
		return;
	}

	if (r == 0)
		command = "news";
	else
		command = Fmt ("news %d", r);
	
	FeedEmpire (command, PRINT);
	PrintAtEmpire ("Empiretool: scanning news");
	strings = InitStrings ();
	ReadEmpireStrings (strings);
	ViewPagerStrings("News", strings, map_win, x + 2, y + 2);
	FreeStrings (strings);

	(void) WaitForPrompt (PRINT);
	return;
}

#define	CM_READ		0
#define CM_NEWS		1
#define CM_HEADL	2
#define	CM_SEND		3
#define	CM_ANNOUNCE	4
#define CM_REREAD	5
#define CM_SORTMAIL	6

#define	CM_NR		7

static const char *comm_menu [] =
{
	"read telegrams",
	"news",
	"headlines",
	"send telegram",
	"announce",
	"reread telegrams",
	"mail commands",
	(char *) 0
};

void Commun (x, y)
int x, y;
{
	int i;
	Strings strings;
	char *country_name;

	strings = InitStrings ();
	AddStringsID (strings, comm_menu, CM_NR, 0);
	i = ChooseMenu (strings, "Operator", map_win, x, y, NULL);
	FreeStrings (strings);

	switch (i) {

	case CM_READ:
	    ShowMail (x + 2, y + 2, MA_ALL);
	    break;

	case CM_NEWS:
	    News (x + 2, y + 2);
	    break;

	case CM_HEADL:
	    ShowHeadLines (x + 2, y + 2);
	    break;

	case CM_SEND:
	    country_name = AskCountry (x + 2, y + 2,
				       "Send to which country ?", True);

	    if (country_name == (char *) 0)
		break;

	    SendTelegram (x + 2, y + 2, country_name);
	    break;

	case CM_ANNOUNCE:
	    Announce (x + 2, y + 2);
	    break;

	case CM_REREAD:
	    if (FScanReadTels () || FScanReadWirs ())
	    {
		ShowMail (x + 2, y + 2,
			  MA_ANNOUNCEMENT | MA_TELEGRAM);
		break;
	    }
	    break;

	case CM_SORTMAIL:
	    MailMenu (x + 2, y + 2);
	    break;

	default:
	    break;
	}
}

/******************************************************************************
 *                      Show mail command                                     *
 *****************************************************************************/

/* should have MA_ here.... */

void InfoMailMenu (x, y, i)
int x, y, i;
{
	switch (i)
	{

	case MA_ANNOUNCEMENT:
		Help (x, y, "Announcement");
		break;

	case MA_TELEGRAM:
		Help (x, y, "Telegram");
		break;

	case MA_BULLETIN:
		Help (x, y, "Bulletin");
		break;

	case MA_OWNTELE:
		Help (x, y, "Own telegrams");
		break;

	default:
		Help (x, y, "No Help");
		break;
	}
}

	/*
	 *	Left: 	toggle on/off
	 *	Middle:	select
	 *	Right: 	done
	 */
    
void MailMenu (x, y)
int x, y;
{
	Strings strings;
	const char *ptr;
	int i, j;
	int ret;
	bool flag;

	strings = InitStrings ();
	j = 1;
	for (i = 0; i < MA_MAX; i++)
	{
		AddStringID (strings,  mail_str [i], j);
		j *= 2;
	}
	ret = MultiSelectPager (strings, "Mail messages",
				NULL, 0, InfoMailMenu);
	switch (ret) {
	case CANCELFUNC:
	default:
	    break;

	case DONEFUNC:
	    j = 0;
	    while ((ptr = GetNextStringID (strings, &i)) != NULL) {
		flag = GiveStringFlag (strings, i);
		if (flag)
		    j |= i;
	    }
	    if (j == 0)
		Message ("No groups selected");
	    else
		ShowMail (x + 2, y + 2, j);
	    break;
	}
	FreeStrings (strings);
}

/*
 * 	no arg means all mail
 *
 *	B:	Bulletins
 *	A:	Anouncements
 *	T:	Telegrams
 *	R:	Replies
 *	P:	Production reports
 *	O:	Output of programs
 */

int ParseReadArg (str)
char * str;
{

	int i;

	if (str == (char *) 0)
		return MA_ALL;
	
	i = 0;
	if (index (str, 'B') != (char *) 0)
		i |= MA_BULLETIN;
	if (index (str, 'A') != (char *) 0)
		i |= MA_ANNOUNCEMENT;
	if (index (str, 'T') != (char *) 0)
		i |= MA_TELEGRAM;
	if (index (str, 'O') != (char *) 0)
		i |= MA_OUTPUT;
	if (index (str, 'P') != (char *) 0)
		i |= MA_PRODUCT;
	if (index (str, 'R') != (char *) 0)
		i |= (MA_OWNTELE | MA_OWNANN);

	return i;
}

void BindRead (x, y, str)
int x, y;
char * str;
{
	int i;

	i = ParseReadArg (str);
	if (i == 0)
	{
		Message ("Bind: Nothing selected to read (BATOPR)");
		Bell ();
		return;
	}
	ShowMail (x, y, i);
}

void BindReRead (x, y, str)
int x, y;
char * str;
{
	int i;

	i = ParseReadArg (str);
	if (i == 0)
	{
		Message ("Bind: Nothing selected to read (BATOPR)");
		Bell ();
		return;
	}

	if (FScanReadTels () || FScanReadWirs ())
		ShowMail (x, y, i);
	else
		Message ("No messages for you at the moment");
}

void BindSend (x, y, str)
int x, y;
char * str;
{
	char buf [50];
	char * country_name;

	if (str != (char *) 0 && sscanf (str, "( %[^)]*", buf) == 1)
	{
		if (CountryId (buf) == UNKNOWN_CNUM)
		{
			Message ("Illegal usage: bind send ( country-name )");
			Bell ();
			return;
		}

		SendTelegram (x, y, buf);
	}
	else
	{
		country_name = AskCountry (x, y, "Send to which country ?",
							True);

		if (country_name == (char *) 0)
		{
			Message ("Send cancelled");
			return;
		}

		SendTelegram (x + 2, y + 2, country_name);
	}
}

/*
 * return last production tele, if none found first char of it is \0
 * needed in reading production
 */
struct s_str_ent {
	char *str;
	int id;
	bool flag;
	struct s_str_ent *next;
};

typedef struct s_str_ent *StrEnt;

struct s_strings {
	StrEnt *index;
	int nelems;
	int lastid;
	StrEnt head, tail, current;
};


char *LastProduction()
{
   Mail ptr = NULL;
   Strings value = NULL;
   StrEnt strptr = NULL;
   char *return_value;
   

   return_value = (char *) malloc(20*1024);

   return_value[0] = '\0';

   for ( ptr = head; ptr != (Mail) 0; ptr = ptr -> next) 
      if ( ptr -> type == MA_PRODUCT )
	 value = ptr -> strings;

   if ( value != NULL ) {
      strptr = value -> head;
      while ( strptr ) {
	 strcat( return_value, strptr -> str);
	 strcat( return_value, "\n");
	 strptr = strptr -> next;
      }
   }
   return return_value;
}

void AppendSignature (strings)
Strings strings;
{
	char buffer [BUFSIZ];
	FILE * fp;

	if (xrc. signature != (char *) 0)
	{
		fp = fopen (xrc. signature, "r");
		if (fp == (FILE *) 0)
		{
			Error (Fmt ("Can't open signature file: %s",
				xrc. signature));
			return;
		}

		while (fgets (buffer, BUFSIZ, fp) != (char *) 0)
		{
			buffer [strlen (buffer) - 1] = '\0';
			AddString (strings, buffer);
		}

		fclose (fp);
	}
}
