/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/select.c,v 5.3 1996/01/29 08:32:59 jpo Exp $
    $Date: 1996/01/29 08:32:59 $
    $Author: jpo $
    $Id: select.c,v 5.3 1996/01/29 08:32:59 jpo Exp $
    $Locker:  $
    $Log: select.c,v $
    Revision 5.3  1996/01/29 08:32:59  jpo
    New selection stuff

    Revision 5.2  1995/09/08 07:43:49  jpo
    const

    Revision 5.1  1993/03/14 16:51:39  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "var.h"
#include "ship.h"
#include "sector.h"
#include "func.h"
#include "nation.h"

char * SelectShips (x, y, shtask, quest)
int x, y;
ShTask shtask;
const char * quest;
{
	extern int last_layout;

	static char buffer [200];

	Strings strings;
	Ship ptr, ship;
	bool flag, first;
	int func;
	int i;
	int nr = -1;

	strings = InitStrings ();
	AddStringID (strings,
		     Fmt ("%-4s %-16s %2s %3s  %3s %3s %3s %3s %4s",
			  "Ship", "", "Fl", "Eff", "Mob", "Civ",
			  "Mil", "Foo", "Tec"), -2);

	for (ptr = s_fship (cursct); ptr != (Ship) 0; ptr = sh_nxtsct (ptr))
	{
		if (! sh_owned (ptr))
			continue;

		if (shtask == ST_NAVIGATE && sh_mob (ptr) <= 0)
			continue;
		
		if (shtask == ST_UPGRADE &&
		    sh_tech (ptr) == (int) n_tech (nation))
			continue;

		if (shtask == ST_TEND && ptr == curship)
			continue;

		if (shtask == ST_LOADXPLANE &&
		    (sh_xpln (ptr) <= shiptypes [sh_type (ptr)] .xpl))
			continue;

		if (shtask == ST_LOADPLANE &&
		    (sh_pln (ptr) == shiptypes [sh_type (ptr)]. pla))
			continue;

		if (shtask == ST_LOADHELI &&
		    (sh_heli (ptr) == shiptypes [sh_type (ptr)]. hel))
			continue;

		if (shtask == ST_LOADLAND &&
		    !shiptypes [sh_type (ptr)]. land &&
		    (sh_land (ptr) == shiptypes [sh_type (ptr)] .land))
			continue;


		AddStringID (strings, Fmt (
			"%-4d %-16.16s  %c %-3d%% %-3d %-3d %-3d %-3d %-4d",
				sh_nr (ptr),
				ShipName (ptr),
				sh_fleet (ptr),
				sh_eff (ptr),
				sh_mob (ptr),
				sh_civ (ptr),
				sh_mil (ptr),
				sh_foo (ptr),
				sh_tech (ptr)),
			sh_nr (ptr));

		nr = sh_nr (ptr);
	}

	if (StringsSize (strings) == 1)
	{
		FreeStrings (strings);
		Message ("No available ships.");
		Bell ();
		return (char *) 0;
	}
	else if (StringsSize (strings) == 2)
	{
		FreeStrings (strings);
		return Fmt ("%d", nr);
	}

	if (last_layout == SHIP_MODE)
		SetStringFlag (strings, sh_nr (curship), True);
	else if (last_layout == FLEET_MODE)
		for (ptr = s_fship (cursct); ptr != (Ship) 0;
							ptr = sh_nxtsct (ptr))
			if (sh_fleet (ptr) == curfleet)
				SetStringFlag (strings, sh_nr (ptr), True);

	switch (MultiSelectPager (strings, quest, NULL, NOFUNC, NULL)) {
	case CANCELFUNC:
	default:
	    FreeStrings (strings);
	    return (char *)0;
	case DONEFUNC:
	    break;
	}
	InitStringList (strings);
	buffer [0] = '\0';
	first = True;
	while ((nr = GetNextSelectedId (strings)) != -1)
	{
	    if (nr == -2)
		continue;
	    if (first)
		first = False;
	    else
		strcat (buffer, "/");

	    strcat (buffer, Fmt ("%d", nr));
	}

	FreeStrings (strings);
	if (first)
	{
	    Message ("No ships selected");
	    return (char *) 0;
	}
	else
	    return buffer;
}
