/*
	$Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/scuttle.c,v 5.5 1996/02/16 08:39:14 jpo Exp $
	$Date: 1996/02/16 08:39:14 $
	$Author: jpo $
	$Id: scuttle.c,v 5.5 1996/02/16 08:39:14 jpo Exp $
	$Locker:  $
	$Log: scuttle.c,v $
	Revision 5.5  1996/02/16 08:39:14  jpo
	Another go at scuttle. Must be about right now

	Revision 5.4  1996/01/29 08:32:37  jpo
	Minor fixes
	Still work needed

	Revision 5.3  1995/10/12 07:23:04  jpo
	Attempt to work with new forms of scuttle

	Revision 5.2  1995/09/08 07:43:46  jpo
	const

	Revision 5.1  1993/03/14 16:51:39  etienne
	*** empty log message ***

 * Revision 5.0  93/02/12  19:38:45  etienne
 * initial rel.
 * 
*/

#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"

void RedoScuttle ()
{
	Ship next;
	char nextfl;

	if (last_layout == SHIP_MODE)
	{
		next = sh_nxtsct (curship);
		ScuttleShip (Fmt ("%d", sh_nr (curship)));
		curship = next;
		if (curship != (Ship) 0)
			CensusShip (curship);
		else
			Census ();
		DrawSector (cursct);
	}
	else if (last_layout == FLEET_MODE)
	{
		nextfl = GiveNextFleetInSct (cursct, curfleet);
		ScuttleShip (FleetId ());
		if (nextfl != ' ' && nextfl != '\0')
		{
			curfleet = '\0';
			Census ();
		}
		else
		{
			curfleet = nextfl;
			CensusFleet (curfleet);
		}
		DrawSector (cursct);
	}
	else
	{
		Message ("No current ship/fleet selected");
		Bell ();
	}
}
	

	/*
	 *	There is no binding to scuttle.
	 *	This routine should only be called with owned ships
	 */

void ScuttleShip (what)
const char * what;
{
	Ship ptr, next;
	int i, j;
	int nr = 0;
	char itemchar;
	char *cp;
	char *ans;

	UnmarkAllShips ();
	MarkShips (what);

	Message (Fmt ("Scuttleping %s", what));

	if (! Confirm (Fmt ("Scuttle %s", what), True))
	{
		Message ("Scuttle ship cancelled");
		return;
	}

	FeedEmpire (Fmt ("scuttle ship %s", what), PRINT);
	while (1) {
	    cp = ReadEmpire (PRINT);
	    switch (EmpireStatus()) {
	    case E_PRINTING:
		continue;
	    case E_COMMAND:
		PrintAtEmpire (cp);
		break;
	    case E_QUESTION:
		PrintAtEmpire (cp);
		ans = InputAtMessage (cp, 10, GS_TEXT);
		if (ans == (char *)0 || interrupt) {
		    interrupt = False;
		    FeedEmpire ("n", PRINT);
		    return;
		}
		FeedEmpire (ans, PRINT);
		continue;
	    default:
		break;
	    }
	    break;
	}
	SetAgain (RedoScuttle);

	ptr = shiplist;
	while (ptr != (Ship) 0)
		if (sh_marked (ptr))
		{
			next = sh_next (ptr);

			for (i = 1; i < V_MAX; i ++)
			{
				itemchar = ItemChar (i);
				j = GiveShipQuant (ptr, itemchar);
				if (j > 0)
					SetQuant (cursct, itemchar,
					      GiveQuant (cursct, itemchar) + j);
			}

			nr ++;

			DeleteShip (ptr);
			ptr = next;
		}
		else
			ptr = sh_next (ptr);
	
	if (nr == 0)
	{
		Message ("No ships scuttled");
		Bell ();
		return;
	}

	Message (Fmt ("%d ships scrapped", nr));
	Census ();
	DrawSector (cursct);
}
