/*
	$Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/order.c,v 1.6 1996/02/16 08:38:48 jpo Exp $
	$Date: 1996/02/16 08:38:48 $
	$Author: jpo $
	$Id: order.c,v 1.6 1996/02/16 08:38:48 jpo Exp $
	$Locker:  $
	$Log: order.c,v $
	Revision 1.6  1996/02/16 08:38:48  jpo
	Rework interface for motif etc.

	Revision 1.5  1996/01/29 08:31:43  jpo
	New menu stuff
	plus some fixes

	Revision 1.4  1995/09/10 17:45:36  jpo
	Added prototype

	Revision 1.3  1995/09/10 16:24:58  jpo
	Generic order setting
	support of fleet mode stuff

	Revision 1.2  1995/09/08 07:43:23  jpo
	holds and cargos etc

	Revision 1.1  1995/08/15 07:54:50  jpo
	Initial revision

 * Revision 1.1  93/03/14  16:51:36  etienne
 * Initial revision
 * 
*/

#include "main.h"
#include "sector.h"
#include "ship.h"
#include "func.h"

static int CalcEta _PROTO((const char *path, Ship ship));
Sector ChooseSeaDest _PROTO((Sector sct, char **pathp));
static bool ShipChangeOrder _PROTO((const char *ships, Sector sct,
				    int orders, int *orderp,
				    short *d1xp, short *d1yp,
				    short *d2xp, short *d2yp,
				    char **pathp));

static const char *order_types[] = {
    "Clear Orders",
#define ORD_CLEAR	0
    "Set Destination",
#define ORD_DEST	1
    "Set Two-Way Path",
#define ORD_TWOWAY	2
    "Suspend Orders",
#define ORD_SUSPEND	3
    "Resume Orders",
#define ORD_RESUME	4
    (char *)0
};
#define ORDERS_MAX	5

static bool ShipChangeOrder (ships, sct, orders, orderp,
			     d1xp, d1yp, d2xp, d2yp, pathp)
const char *ships;
Sector sct;
int orders;
int *orderp;
short *d1xp, *d1yp, *d2xp, *d2yp;
char **pathp;
{
	char *ptr, *path, *path2;
	int i;
	Sector to, to2;
	Strings strings;

	*pathp = NULL;
	*d1xp = *d1yp = *d2xp = *d2yp = 0;
	*orderp = 0;

	strings = InitStrings ();
	AddStringsID (strings, order_types, ORDERS_MAX, 0);
	i = ChooseMenu (strings, "Set Orders", census_win, 5, 5, NULL);

	FreeStrings (strings);

	if (i < 0 || interrupt) {
		interrupt = False;
		Message ("Orders cancelled");
		return False;
	}
	switch (i) {
	    case ORD_CLEAR:
		*orderp = 0;
		FeedCommand (Fmt("order %s clear", ships), PRINT);
		return True;
	    case ORD_RESUME:
		*orderp = (orders & (~ORDER_SUSPENDED));
		FeedCommand (Fmt("order %s resume", ships), PRINT);
		return True;
	    case ORD_SUSPEND:
		*orderp = orders | ORDER_SUSPENDED;
		FeedCommand (Fmt ("order %s suspend", ships), PRINT);
		return True;
	    case ORD_DEST:
		Message (Fmt ("Order ship(s) %s to?", ships));
		to = ChooseSeaDest(sct, &path);
		if (to == NULL)
			return False;
		*orderp = ORDER_ONEWAY;
		*pathp = path;
		*d1xp = s_xcd(to);
		*d1yp = s_ycd(to);
		FeedEmpire ( Fmt("order %s declare %s",
				 ships, CrdStr(to)), PRINT);
		ptr = ReadEmpire (PRINT);
		if (ptr && StrEQ (ptr, "Second dest?"))
			FeedEmpire ("", PRINT);
		(void) WaitForPrompt (PRINT);
		DrawSector (sct);
		break;
	    case ORD_TWOWAY:
		Message (Fmt ("Order ship(s) %s to?", ships));
		if ((to = ChooseSeaDest (sct, &path)) == NULL) {
		    	DrawSector (sct);
			return False;
		}
		*pathp = Str (path);
		Message ("And then sail to?");
		if ((to2 = ChooseSeaDest (to, &path2)) == NULL) {
			free (*pathp);
			DrawSector (sct);
			return False;
		}
		*orderp = ORDER_TWOWAY;
		*d1xp = s_xcd (to);
		*d1yp = s_ycd (to);
		*d2xp = s_xcd (to2);
		*d2yp = s_ycd (to2);
		FeedCommand (Fmt ("order %s declare %s %s",
				  ships, CrdStr(to),
				  CrdStr (to2)), PRINT);
		DrawSector (sct);
		break;
	    default:
		Message ("Ehhh?");
		return False;
	}
	return True;
}

void ChangeOrder (ship)
Ship ship;
{
	char *path;
	short d1x, d1y, d2x, d2y;
	int orders;

	if (!sh_owned(ship)) {
		Message ("Not your ship !!");
		return;
	}

	if (ShipChangeOrder (Fmt ("%d", sh_nr(ship)),
			     World (sh_xcd(ship), sh_ycd(ship), S_DESIG),
			     ship -> orderflags,
			     &orders,
			     &d1x, &d1y, &d2x, &d2y,
			     &path) == True) {
		ship -> orderflags = orders;
		ship -> d1x = d1x;
		ship -> d1y = d1y;
		ship -> d2x = d2x;
		ship -> d2y = d2y;
		if ((orders & (ORDER_TWOWAY | ORDER_ONEWAY)) && path) {
			ship -> lenpath = strlen(path) - 1;
			ship -> eta = CalcEta (path, ship);
		}
		if (path) free (path);
	}
	CensusShip (ship);
	return;
}


Sector ChooseSeaDest (sct, pathp)
Sector sct;
char **pathp;
{
	int button;
	Sector to;

	MesBut ("View", "Cancel", "Set");
	for (;;) {
		to = SelectSector (&button);
		
		if (interrupt || button == MIDDLE_BUTTON) {
			interrupt = False;
			Message ("Cancelled");
			MesClearBut ();
			return NULL;
		}
		if (to == (Sector)0)
			continue;

		if (button == LEFT_BUTTON) {
			CensusSct (to);
			continue;
		}
		if (to == sct)
			continue;
		if (NavigOK (to) == False) {
			Message ("Not a good navigable sector!");
			continue;
		}
		if ((*pathp = BestSeaPath (sct, to)) == NULL) {
			Message ( Fmt("I don't see a path from %s to %s",
				      CrdStr(sct), CrdStr(to)));
			return NULL;
		}
		MesClearBut ();
		return to;
	}
}

static int CalcEta (path, ship)
const char *path;
Ship ship;
{
	int speed;
	int mobcost;
	const char *cp;
	int mobil;
	int updates = 0;

	speed = shiptypes[sh_type(ship)].spd;
	mobcost = sh_eff(ship) * 0.01 * speed;
	mobcost = 480.0 / (mobcost + TechFact (sh_tech(ship), mobcost));
	mobil = sh_mob(ship);
	for (cp = path; *cp && *cp != 'h';) {
		if (mobil > 0) {
			mobil -= mobcost;
			cp ++;
		}
		else {
			mobil += ship_mob_gain * etu_per_update;
			updates ++;
		}
	}
	return updates;
}



static const char *ShipOrders (oflags, d1x, d1y, d2x, d2y, eta)
uchar oflags;
short d1x, d1y, d2x, d2y;
uchar eta;
{
	char buf[200];

	if (oflags == 0)
		return "No orders";

	if (oflags & ORDER_TWOWAY) {
		(void) sprintf (buf, "Btwn %d,%d & %d,%d",
				d1x, d1y,
				d2x, d2y);
	}
	else if (oflags & ORDER_ONEWAY) {
		(void) sprintf (buf, "Sail %d,%d",
				d1x, d1y);
	}
	if (oflags & ORDER_SUSPENDED)
		return Fmt ("%s (Susp)", buf);
	else if (oflags & ORDER_LOADING)
		return Fmt ("%s (Load)", buf);
	else if (oflags & (ORDER_ONEWAY|ORDER_TWOWAY))
		return Fmt ("%s (eta %d)", buf, eta);
	return Fmt ("%s", buf);
}

const char *ShipHasOrders (ship)
Ship ship;
{
	return ShipOrders (ship -> orderflags,
			   ship -> d1x, ship -> d1y,
			   ship -> d2x, ship -> d2y,
			   ship -> eta);
}

void FScanShipOrders (list, flag)
const char *list;
int flag;
{
	FeedEmpire (Fmt ("sorder %s", list), flag);

	ScanShipOrders (flag);
	(void) WaitForPrompt (flag);
}

void ScanShipOrders (flag)
int flag;
{
	char *ptr, *ind;
	Ship ship;
	int sno;
	int coff, soff, eoff, loff, etaoff;
	int x, y;
	struct offsets {
		char *str;
		int *offp;
		int add;
	} Offsets[] = {
	{"x,y", &coff, -2},
	{"start", &soff, -1},
	{"end", &eoff, -1},
	{"len", &loff, -1},
	{"eta", &etaoff, -1},
	{ NULL}
	};
	struct offsets *op;

	if (EmpireStatus () != E_PRINTING)
		return;
	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning ship orders");

	ptr = ReadEmpire (DONT_PRINT);
	if (StrStr(ptr, "No ship") != NULL)
	    return;

	if ((ind = StrStr (ptr, "ship type")) == NULL) {
		PrintAtEmpire (Fmt ("Order scan failed on %s", ptr));
		return;
	}
	for (op = Offsets; op -> str; op ++) {
		if ((ind = StrStr (ind, op -> str)) == NULL) {
			PrintAtEmpire (Fmt ("No %s in %s",
					    op -> str, ptr));
			return;
		}
		*op -> offp = ind - ptr;
		*op -> offp += op -> add;
	}
		
	for (;;) {
		ind = ptr = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING) {
			if (flag == PRINT)
				PrintAtEmpire (ptr);
			return;
		}
		if (ScanDigit ((ConstVP)&ind, &sno) == False) /* ship name? */
			continue;
		if (strncmp (ind, " ship", 4) == 0) /* %d ships */
			break;
		if ((ship = NrToShip (sno)) == (Ship)0) {
			PrintAtEmpire (Fmt ("#%d Unknown ship (rescan ships!)",
					    sno));
			Bell ();
			(void) EmpireMore ();
			continue;
		}
		if (sscanf (&ptr[soff], "%d,%d", &x, &y) != 2)
			continue;
		ship -> d1x = x;
		ship -> d1y = y;
		ship -> orderflags = ORDER_ONEWAY;
		for (ind = &ptr[eoff]; ind < &ptr[loff]; ind ++) {
			if (isascii(*ind) && (isdigit(*ind) || *ind == '-')) {
				if (sscanf (&ptr[eoff], "%d,%d",
					    &x, &y) == 2) {
					ship -> d2x = x;
					ship -> d2y = y;
					ship -> orderflags |= ORDER_TWOWAY;
					ship -> orderflags &= ~ORDER_ONEWAY;
				}
				break;
			}
		}
		if (StrStr (&ptr[loff], "suspended"))
			ship -> orderflags |= ORDER_SUSPENDED;
		else if(StrStr (&ptr[loff], "loading"))
			ship -> orderflags |= ORDER_LOADING;
		else {
			int len, eta;
			if (sscanf (&ptr[loff], "%d %d", &len, &eta) == 2) {
				ship -> eta = eta;
				ship -> lenpath = len;
			}
		}
	}
}

void FScanShipQOrders (list, flag)
const char *list;
int flag;
{
	FeedEmpire (Fmt ("qorder %s", list), flag);

	ScanShipQOrders (flag);
	(void) WaitForPrompt (flag);
}

void ScanShipQOrders (flag)
int flag;
{
	char *ptr, *ind;
	Ship ship;
	int hold, amount, sno;
	char type;

	if (EmpireStatus () != E_PRINTING)
		return;
	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning ship cargo orders");

	ptr = ReadEmpire (DONT_PRINT);
	if (StrStr(ptr, "No ship") != NULL)
	    return;

	if ((ind = StrStr (ptr, "ship type")) == NULL) {
		PrintAtEmpire (Fmt ("Qorder scan failed on %s", ptr));
		return;
	}
	for (;;) {
		ind = ptr = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING) {
			if (flag == PRINT)
				PrintAtEmpire (ptr);
			return;
		}
		if (ScanDigit ((ConstVP)&ind, &sno) == False) /* ship name? */
			continue;
		if (strncmp (ind, " ship", 4) == 0) /* %d ships */
			break;
		if ((ship = NrToShip (sno)) == (Ship)0) {
			PrintAtEmpire (Fmt ("#%d Unknown ship (rescan ships!)",
					    sno));
			Bell ();
			(void) EmpireMore ();
			continue;
		}
		if ((ind = index (ptr, '[')) != NULL) {
			ind ++;

			while (*ind != ']') {
				while (*ind == ' ')
					ind ++;
				if (sscanf ("%d-%c:%d", &hold, &type,
					    &amount) == 3) {
					ship -> holds[hold].stype = type;
					ship -> holds[hold].samount = amount;
				}
				while (*ind != ' ' && *ind != ']')
					ind ++;
				
			}
		}
		if ((ind = index (ptr, '(')) != NULL) {
			ind ++;

			while (*ind != ')') {
				while (*ind == ' ')
					ind ++;
				if (sscanf ("%d-%c:%d", &hold, &type,
					    &amount) == 3) {
					ship -> holds[hold].etype = type;
					ship -> holds[hold].eamount = amount;
				}
				while (*ind != ' ' && *ind != ')')
					ind ++;
				
			}
		}
	}
}

const char *ShipHasCargo (ship)
Ship ship;
{
	static char cargobuf[16];
	char *cp;
	int i;

	cp = cargobuf;
	for (i = 0; i < MAXHOLDS; i++) {
		if (ship -> holds[i].stype != '\0')
			*cp ++ = ship -> holds[i].stype;
	}
	*cp ++ = '/';
	for (i = 0; i < MAXHOLDS; i++) {
		if (ship -> holds[i].etype != '\0')
			*cp ++ = ship -> holds[i].etype;
	}
	*cp = '\0';
	if (strcmp (cargobuf, "/") == 0)
	    return "None";
	return cargobuf;
}

static void CargoLine (str, i, hold)
char *str;
int i;
Holds *hold;
{
	char *cp = str;
	sprintf (cp, "%4d ", i);
	cp += strlen(cp);
	if (hold -> samount == 0)
		hold -> stype = '\0';
	sprintf (cp, "%4d %-7.7s", hold -> samount,
		 hold -> stype ?
		 ItemName (CharToItem(hold -> stype)) : "");
	cp += strlen (cp);
	*cp ++ = ' ';
	if (hold -> eamount == 0)
		hold -> etype = '\0';
	sprintf (cp, "%4d %-7.7s", hold -> eamount,
		 hold -> etype ?
		 ItemName(CharToItem(hold -> etype)) : "");
}

/* work out whats changed and do the necessary - and update the ship */
static void HoldApply (ship, newhold)
Ship ship;
Holds newhold[];
{
	int i;

	for (i = 0; i < MAXHOLDS; i++) {
		if (ship -> holds[i].samount != newhold[i].samount ||
		    ship -> holds[i].stype != newhold[i].stype)
			FeedCommand (Fmt ("order %d load %d start %c %d",
					  sh_nr (ship),
					  i + 1,
					  newhold[i].samount == 0 ?
					  'c' : newhold[i].stype,
					  newhold[i].samount),
				     PRINT);
		if (ship -> holds[i].eamount != newhold[i].eamount ||
		    ship -> holds[i].etype != newhold[i].etype)
			FeedCommand (Fmt("order %d load %d end %c %d",
					 sh_nr (ship),
					 i + 1,
					 newhold[i].eamount == 0 ?
					 'c' : newhold[i].etype,
					 newhold[i].eamount),
				     PRINT);
	
		ship -> holds[i] = newhold[i];
    }
}

struct hdata {
    Holds *holds;
    char cargos[MAXHOLDS+1][80];
};
    

static void CargoEdit (strings, ind, data)
Strings strings;
int ind;
void *data;
{
    struct hdata *hdata = data;
    char *newhold;
    int s1, s2;
    char c1, c2;

    newhold = InputAtMessage (Fmt("New Hold %d contents: ", ind),
			      10, "0-9a-z");
    if (newhold == NULL || *newhold == '\0' || interrupt)
	return;

    if (ScanDigit ((ConstVP)&newhold, &s1) == False)
	return;
    if (CharToItem (*newhold) == -1)
	return;
    c1 = *newhold++;
    if (*newhold) {
	if (ScanDigit ((ConstVP)&newhold, &s2) == False)
	    return;
	if (CharToItem (*newhold) == -1)
	    return;
	c2 = *newhold;
    }
    else {
	s2 = 0; c2 = 0;
    }

    hdata -> holds[ind-1].samount = s1;
    hdata -> holds[ind-1].stype = c1;
    hdata -> holds[ind-1].eamount = s2;
    hdata -> holds[ind-1].etype = c2;
    CargoLine(hdata -> cargos[ind], ind, &hdata -> holds[ind-1]);
    ChangeString (strings, ind, hdata -> cargos[ind]);
}

static void CargoDelete (strings, ind, data)
Strings strings;
int ind;
void *data;
{
    struct hdata *hdata = data;

    hdata -> holds[ind-1].eamount = hdata -> holds[ind-1].samount = 0;
    CargoLine(hdata -> cargos[ind], ind, &hdata -> holds[ind-1]);
    ChangeString (strings, ind, hdata -> cargos[ind]);
}


static FuncList hold_fnxs[] = {
    { "Done", DONEFUNC, NULL },
    { "Cancel", CANCELFUNC, NULL},
    { "Change", NEWFUNC, CargoEdit },
    { "Delete", DELETEFUNC, CargoDelete},
    { NULL },
};


void ChangeCargo (ship)
Ship ship;
{
	Strings strings;
	int func;
	struct hdata hdata;
	int i;
	Holds holds[MAXHOLDS];

	strings = InitStrings ();

	hdata.holds = holds;
	sprintf (hdata.cargos[0], "%-4s %-12s %-12s", "Hold",
		 "Load Port 1", "Load Port 2");
	AddStringID (strings, hdata.cargos[0], 0);
	for (i = 1; i <= MAXHOLDS; i++) {
		holds[i-1] = ship -> holds[i-1];
		CargoLine (hdata.cargos[i], i, &holds[i-1]);
		AddStringID (strings, hdata.cargos[i], i);
	}

	func = MakePickDialog (strings, "Hold Disposition",
			       hold_fnxs, &hdata, map_win, 5, 5, True);
	FreeStrings (strings);

	switch (func) {
	case CANCELFUNC:
	    break;
	case DONEFUNC:
	    HoldApply (ship, holds);
	    break;
	}
	return;
}

const char *FleetHasOrders (fleet)
char fleet;
{
	Ship ptr;
	int flags;
	int d1x, d2x, d1y, d2y;
	int eta;
	int first = 0;
	
	flags = d1x = d2x = d1y = d2y = eta = 0;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet) {
			if (first++ == 0) {
				flags = ptr -> orderflags;
				d1x = ptr -> d1x;
				d2x = ptr -> d2x;
				d1y = ptr -> d1y;
				d2y = ptr -> d2y;
				eta = ptr -> eta;
				continue;
			}
			if (flags != ptr -> orderflags)
				return "Mixed";
			switch (flags & (ORDER_ONEWAY|ORDER_TWOWAY)) {
			    case ORDER_TWOWAY:
				if (ptr -> d1x != d1x ||
				    ptr -> d1y != d1y ||
				    ptr -> d2x != d2x ||
				    ptr -> d2y != d2y)
					return "Mixed";
				if (ptr -> eta > eta)
					eta = ptr -> eta;
				break;

			    case ORDER_ONEWAY:
				if (ptr -> d1x != d1x ||
				    ptr -> d1y != d1y)
					return "Mixed";
				if (ptr -> eta > eta)
					eta = ptr -> eta;
				break;
			}
		}
	return ShipOrders (flags, d1x, d1y, d2x, d2y, eta);
}

void ChangeFleetOrder (fleet)
char fleet;
{
	int orders;
	char *path;
	short d1x, d1y, d2x, d2y;
	int len;
	Ship ptr;

	if (FleetEmpty(fleet) == True) {
		Message ("Fleet is empty");
		return;
	}
	if (FleetColocated (fleet) == False) {
		Message ("Fleet not colocated");
		return;
	}

	if (ShipChangeOrder (Fmt ("%c", fleet),
			     FleetSector (fleet),
			     0,
			     &orders,
			     &d1x, &d1y, &d2x, &d2y,
			     &path) == True) {
		len = strlen (path) - 1;
		for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
			if (ptr-> fleet == fleet) {
				ptr -> orderflags = orders;
				ptr -> d1x = d1x;
				ptr -> d1y = d1y;
				ptr -> d2x = d2x;
				ptr -> d2y = d2y;
				if (orders & (ORDER_TWOWAY | ORDER_ONEWAY)) {
					ptr -> lenpath = len;
					ptr -> eta = CalcEta (path, ptr);
				}
			}
		if (path) free (path);
		CensusFleet (fleet);
	}
}
