/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/list.c,v 5.4 1996/01/29 08:30:36 jpo Exp $
    $Date: 1996/01/29 08:30:36 $
    $Author: jpo $
    $Id: list.c,v 5.4 1996/01/29 08:30:36 jpo Exp $
    $Locker:  $
    $Log: list.c,v $
    Revision 5.4  1996/01/29 08:30:36  jpo
    New menu stuff

    Revision 5.3  1995/09/08 07:43:03  jpo
    const

    Revision 5.2  1995/08/15 08:00:15  jpo
    *** empty log message ***

 * Revision 5.1  93/03/14  16:51:35  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "census.h"
#include "nation.h"
#include "var.h"
#include "ship.h"
#include "sector.h"

#define SORT_NR		0
#define	SORT_SECTOR	1
#define	SORT_TYPE	2
#define	SORT_FLEET	3
#define	SORT_OWNER	4

#define SORT_MAX_O	4
#define SORT_MAX_E	5

#define OWN  		0
#define ENEMY           1

static const char *list_ships_how [] = 
{
	"sort by number",
	"sort by sector",
	"sort by ship-type",
	"sort by fleet",
	"sort by owner",
	(char *) 0
};

static char * fleet_chars =
	"~abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

static int AddShipToStrings (strings, ship, enemy)
Strings strings;
Ship ship;
int enemy;
{
  if ((sh_owned(ship)) && (enemy == OWN))

      {
	AddString (strings, Fmt (
			       "%4d %-17.17s %4d,%-4d %c %3d%% %3d %3d %3d %3d %3d  %3d  %3d %s%s%s%s",
			       sh_nr (ship),
			       ShipName (ship),
			       sh_xcd (ship),
			       sh_ycd (ship),
			       sh_fleet (ship),
			       sh_eff (ship),
			       sh_mob (ship),
			       sh_moves (ship),
			       sh_pln (ship),
			       sh_mil (ship),
			       sh_civ (ship),
			       sh_foo (ship),
			       sh_tech (ship),
                               chainsaw_version ? Fmt (" %3d ",
                                                       sh_heli (ship))
                                           : "",
                               chainsaw_version ? Fmt (" %3d ",
                                                       sh_xpln (ship))
                                           : "",
                               land_units ? Fmt (" %3d ",
                                                       sh_land (ship))
                                           : "",
                               chainsaw_version ? Fmt (" %3d ",
                                                       sh_fuel (ship))
                                           : ""));
	return 1;
      }
  
  else if ( !(sh_owned(ship)) && (enemy == ENEMY))

    {
      AddString (strings, Fmt (
	    "%4d %-17.17s %-14.14s %4d,%-4d ",
			sh_nr (ship),
			ShipName (ship),
			(CountryName(sh_owner (ship))),
			sh_xcd (ship),
			sh_ycd (ship)));
      return 1;
    }
  else
    return 0;
}

void ListShips (x, y, enemy)
int x, y, enemy;
{
	Strings strings;
	int i, j;
	int total;
	Sector sct;
	Ship ptr;
	char * ch;
	bool empty_line;

	strings = InitStrings ();
	AddStringsID (strings, list_ships_how,
		      enemy == OWN ? SORT_MAX_O : SORT_MAX_E,
		      0);
	i = ChooseMenu (strings, "Listing of ships", map_win, x, y, NULL);
	FreeStrings (strings);
	if (i < 0)
	{
		Message ("No listing");
		return;
	}

	strings = InitStrings ();
	Message ("generating list");
	if (enemy == OWN)
		if(chainsaw_version) {	
			if(land_units) {
	  			AddString (strings, 
		     			"   #    type              x,y    w eff  mob muv pln mil civ food tech heli xpln land fuel");
			} else {
	  			AddString (strings, 
		     			"   #    type              x,y    w eff  mob muv pln mil civ food tech heli xpln fuel");
			}
		} else {
	  		AddString (strings, 
		     			"   #    type           x,y    w eff  mob muv pln mil civ food tech");
		}
	else
	  
	  AddString (strings, "   #    type         Owner            x,y    ");
	
	total = 0;
	switch (i)
	{

	case SORT_NR:
		for ALL_SHIPS (ptr)
		{
		  if (AddShipToStrings (strings, ptr, enemy))
		    {
		      empty_line = True;
		      total ++;
		    }
		}
		break;
	
	case SORT_SECTOR:
		for (x = - MAX_X / 2; x <= MAX_X / 2; x ++)
			for (y = - MAX_Y / 2; y <= MAX_Y / 2; y++)
			{
				sct = World (x, y, S_EXIST);
				if (sct == (Sector) 0)
					continue;

				empty_line = False;
				for (ptr = s_fship (sct); ptr != (Ship) 0;
							ptr = sh_nxtsct (ptr))
				{
				  if (AddShipToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				     total ++;
				   }
				}

				if (empty_line)
					AddString (strings, "");
			}
		break;
	
	case SORT_TYPE:
		for (j = 0; shiptypes [j]. nam != (char *) 0; j ++)
		{
			empty_line = False;

			for ALL_SHIPS (ptr)
			{
				if (sh_type (ptr) == j)
				{
				  if (AddShipToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				      total ++;
				    }
				}
			      }
			
			if (empty_line)
				AddString (strings, "");
		}
		break;
	
	case SORT_FLEET:
		for (ch = fleet_chars; * ch != '\0'; ch ++)
		{
			empty_line = False;

			for ALL_SHIPS (ptr)
			{
				if (sh_fleet (ptr) == * ch)
				  {
				  if (AddShipToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				      total ++;
				    }
				}
			      }
			if (empty_line)
				AddString (strings, "");
		}
		break;

	case SORT_OWNER:

		for (j = 0; j < MAX_NATIONS ; j ++)
		{
			empty_line = False;

			for ALL_SHIPS (ptr)
			{
				if (sh_owner (ptr) == j)
				{
				  if (AddShipToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				      total ++;
				    }
				}
			}
			
			if (empty_line)
				AddString (strings, "");
		}
		break;
	}

	if (total == 0)
	{
		Message ("No info on ships !");
		FreeStrings (strings);
		Bell ();
		return;
	}

	AddString (strings, Fmt ("%d ships", total));
	ShowStringsInPager (strings, "List of all ships");
}
