/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/plane/RCS/paradrop.c,v 5.1 1993/03/14 16:51:12 etienne Exp $
    $Date: 1993/03/14 16:51:12 $
    $Author: etienne $
    $Id: paradrop.c,v 5.1 1993/03/14 16:51:12 etienne Exp $
    $Locker:  $
    $Log: paradrop.c,v $
    Revision 5.1  1993/03/14 16:51:12  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:23:20  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:42:01  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"
#include "var.h"

static char * last_planes = (char *) 0;
static int last_x, last_y;
static Sector last_sct = (Sector) 0;
     

void RedoParadrop ()
{
      Paradrop (last_x, last_y, last_planes);

/*	if (cursct == last_sct)
	  Paradrop (last_x, last_y, last_planes);
   else if (last_layout == PLANE_MODE)
      Paradrop (s_xcd(cursct), s_ycd(cursct), Fmt ("%d", pl_nr (curplane)));
   else if (last_layout == WING_MODE)
      Paradrop (s_xcd(cursct), s_ycd(cursct), WingId());
   else
	  DoParadrop (last_x, last_y); */
}



void Paradrop (x, y, what)
int x, y;
char * what;
{
	char * escort;
	char * path;
	Sector to;
	int max_range;

	UnmarkAllPlanes ();
	MarkPlanes (what);
	if (LoadMarked (False) > s_mil (cursct) / ItemWeight (V_MILIT, NPKG))
	{
		Message ("Not enough mils");
		Bell ();
		return;
	}

	if (NrMarkedPlanes () == 0)
	{
		Message ("No planes to paradrop !");
		Bell ();
		return;
	}

	if (last_planes != (char *) 0)
		free (last_planes);
	last_planes = Str (what);

	escort = SelectPlanes (x, y, cursct, MIS_ESCORT, "Use as escort ?");
	if (escort == (char *) 0)
		return;

	MarkPlanes (escort);
	max_range = MaxRangeMarked (cursct) / 2;


	SetAgain (RedoParadrop);
	last_x = x;
	last_y = y;
	last_sct = cursct;

	path = AskFlyRoute (cursct, max_range - 1, "paradrop");

	if (path == (char *) 0)
	{
		Message ("paradrop cancelled");
		return;
	}

	to = FollowPath (cursct, path);

	switch (s_des(to)) {
	case '^':
	case '.':
	case '\\':
	case 'c':
	case 'f':
	    Message ("That would be pointless");
	    return;
	}

	FeedEmpire (Fmt ("paradrop %s %s %s %sh",
		what,
		escort,
		CrdStr (cursct),
		path), PRINT);

	ParseFlyOutput (-1);

	Message ("Redumping planes & sects");
	FScanPlanes (what, PRINT);
	if (* escort != '.')
		FScanPlanes (escort, PRINT);

	RedumpSector (cursct, PRINT);
	RedumpSector (to, PRINT);
	CensusSct (cursct);
	DrawMap ();
	Message ("paradrop done");
}

void DoParadrop (x, y)
int x, y;
{
	char * pl, * tmp;

	UnmarkAllPlanes ();
	pl = SelectPlanes (x, y, cursct, MIS_PARADROP,
		"Which planes to paradrop ?");
	if (pl == (char *) 0)
		return;
	tmp = Str (pl);
	Paradrop (x + 2, y + 2, tmp);
	free (tmp);
}
