/*
	$Header: /nexor/users/jpo/xemp/xemp5.0/lib/plane/RCS/mission.c,v 1.4 1996/01/29 08:27:21 jpo Exp $
	$Date: 1996/01/29 08:27:21 $
	$Author: jpo $
	$Id: mission.c,v 1.4 1996/01/29 08:27:21 jpo Exp $
	$Locker:  $
	$Log: mission.c,v $
	Revision 1.4  1996/01/29 08:27:21  jpo
	New menu stuff

	Revision 1.3  1995/09/08 07:40:06  jpo
	const

	Revision 1.2  1995/08/15 08:05:26  jpo
	lots of mission changes

 * Revision 1.1  93/03/14  16:51:12  etienne
 * Initial revision
 * 
*/

#include "main.h"
#include "sector.h"
#include "version.h"
#include "plane.h"

static const char *mission_types[] = {
	"Delete Mission",
#define MIS_DELETE	0
	"Interdict",
#define MIS_INTERDICT	1
	"Support",
#define MIS_SUPPORT	2
	"Offensive Support",
#define MIS_OFFSUPP	3
	"Defensive Support",
#define MIS_DEFSUPP	4
	"Escort",
#define MIS_ESCORT	5
	"Air Defense",
#define MIS_AIRDEF	6
	(char *)0
};
#define MISSION_MAX	7

static const char type2mission[] = "\0isodea";

void PMission (plane)
Plane plane;
{
	int i;
	Strings strings;
	Sector sct;
	char *answer;
	int range;

	strings = InitStrings ();
	AddStringsID (strings, mission_types, MISSION_MAX, 0);
	i = ChooseMenu (strings, "Mission Type?", map_win, 5, 5, NULL);
	FreeStrings (strings);

	if (i < 0 || interrupt) {
		interrupt = False;
		Message ("Set mission cancelled");
		return;
	}
	
	if (i == 0) {
		set_pl_mission (plane, type2mission[i]);
		FeedCommand (Fmt ("mission plane %d c", pl_nr(plane)), PRINT);
		Message (Fmt ("Plane %d now has no mission", pl_nr(plane)));
		return;
	}
	if (pl_eff(plane) < 60) {
		Message ("Must be greater than 60% eff");
		return;
	}
	switch (i) {
	    case MIS_INTERDICT:
	    case MIS_SUPPORT:
	    case MIS_OFFSUPP:
	    case MIS_DEFSUPP:
		if (PlaneHas (plane, P_T) == 0) {
			Message ( Fmt("Plane must be have %s capabilty",
				      PlaneCapNames (P_T)));
			return;
		}
		break;

	    case MIS_ESCORT:
		if (PlaneHas (plane, P_E) == 0 ||
		    PlaneHas (plane, P_F) == 0) {
			Message (Fmt ("Plane must have %s capability",
				      PlaneCapNames (P_E|P_F)));
		}
		break;

	    case MIS_AIRDEF:
		if (PlaneHas (plane, P_F) == 0) {
			Message (Fmt ("Plane must have %s capability",
				      PlaneCapNames (P_F)));
			return;
		}
		break;
	}

	range = pl_range(plane);
	answer = InputAtMessage (Fmt  ("Range [%d]: ",range),
				 3, GS_PNUMBER);
	if (interrupt || answer == (char *)0) {
		interrupt = False;
		Message ("Mission cancelled");
		return;
	}
	if (*answer != '\0')
		range = atoi (answer);
		
	sct = PlaneSector (plane);
	set_pl_mission (plane, type2mission[i]);
	FeedCommand (Fmt ("mission plane %d %c %s %d",
			  pl_nr (plane), pl_mission(plane),
			  CrdStr(sct), range), PRINT);
	Message (Fmt ("Plane %d now on %s mission", pl_nr (plane),
		      mission_types[i]));
	return;
}

void FScanPlaneMission (list, flag)
const char *list;
int flag;
{
	int nr;

	FeedEmpire (Fmt ("mission plane %s q", list), flag);

	ScanPlaneMission (flag);
	(void) WaitForPrompt (flag);
}

void ScanPlaneMission (flag)
int flag;
{
	char *ptr, *ind;
	int mind, pno;
	Plane plane;

	if (EmpireStatus () != E_PRINTING)
		return;
	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning plane missions");

	ptr = ReadEmpire (DONT_PRINT);
	if ((ind = StrStr (ptr, "mission")) == NULL) {
		PrintAtEmpire (Fmt ("Mission scan failed on %s", ptr));
		return;
	}
	mind = ind - ptr;
	
	for (;;) {
		ptr = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING) {
			if (flag == PRINT)
				PrintAtEmpire (ptr);
			return;
		}
		
		if ((ind = index (ptr, '#')) == NULL)
			continue;

		ind ++;
		if (!ScanDigit ((ConstVP)&ind, &pno) ||
		    (plane = NrToPlane (pno)) == (Plane)0) {
			PrintAtEmpire (Fmt ("#%d Unknown plane (rescan planes!)",
					    pno));
			Bell ();
			(void) EmpireMore ();
			continue;
		}

		switch (ptr[mind]) {
		    case 'i':
		    case 's':
		    case 'o':
		    case 'd':
		    case 'e':
		    case 'a':
			set_pl_mission (plane, ptr[mind]);
			break;
		    case 'h':
			set_pl_mission (plane, '\0');
			break;
		    default:
			PrintAtEmpire (Fmt ("Unknown mission type %s",
					    ptr + mind));
			Bell ();
			break;
		}
	}
}
