/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/plane/RCS/dump.c,v 5.1 1993/03/14 16:51:07 etienne Exp $
    $Date: 1993/03/14 16:51:07 $
    $Author: etienne $
    $Id: dump.c,v 5.1 1993/03/14 16:51:07 etienne Exp $
    $Locker:  $
    $Log: dump.c,v $
    Revision 5.1  1993/03/14 16:51:07  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:23:20  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:42:01  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "plane.h"
#include "sector.h"

void SaveShowPlane (fp)
FILE * fp;
{
	register int i;
	register char *ptri, *name;;

	for (i = 0; planetypes [i]. nam != (char *) 0; i++)
	{
		name = Str (planetypes [i]. nam);
		for (ptri = name; *ptri != '\0'; ptri ++)
			if (*ptri == ' ')
				*ptri = '_';

		fprintf (fp, "%s %d %d %d %d %d %d %d %d %d %d %d %d %d\n",
			name,
			planetypes [i]. lcm,
			planetypes [i]. hcm,
			planetypes [i]. cost,
			planetypes [i]. tech,
			planetypes [i]. acc,
			planetypes [i]. load,
			planetypes [i]. att,
			planetypes [i]. def,
			planetypes [i]. range,
			planetypes [i]. crew,
			planetypes [i]. fuel,
			planetypes [i]. ava,
			planetypes [i]. flags);

		free (name);
	}

	fprintf (fp, "END OF SHOW PLANE LIST\n");
}

void RestoreShowPlane (fp)
FILE * fp;
{
	int nr;
	char buffer [BUFSIZ];
	char name [BUFSIZ];
	register char *ptri;

	nr = 0;
	while (fgets (buffer, BUFSIZ, fp) != (char *) 0)
	{
		if (StrEQ (buffer, "END OF SHOW PLANE LIST"))
		{
			planetypes [nr]. nam = (char *) 0;
			break;
		}

		buffer [strlen (buffer) - 1] = '\0';	/* no newline */
		
		if (sscanf (buffer,
				"%s %d %d %d %d %d %d %d %d %d %d %d %d %d",
			name,
			& (planetypes [nr]. lcm),
			& (planetypes [nr]. hcm),
			& (planetypes [nr]. cost),
			& (planetypes [nr]. tech),
			& (planetypes [nr]. acc),
			& (planetypes [nr]. load),
			& (planetypes [nr]. att),
			& (planetypes [nr]. def),
			& (planetypes [nr]. range),
			& (planetypes [nr]. crew),
			& (planetypes [nr]. fuel),
			& (planetypes [nr]. ava),
			& (planetypes [nr]. flags)) != 14)
		{
				PrintAtEmpire ("Bad Plane info in datafile");
				Bell ();
				continue;
		}

		for (ptri = name; *ptri != '\0'; ptri ++)
			if (*ptri == '_')
				*ptri = ' ';

		planetypes [nr]. nam = Str (name);
		nr ++;
	}
}

void BinDumpPlanes (fp)
FILE * fp;
{
	struct s_plane dummy;
	Plane plane;
	int size;

	size = sizeof (struct s_plane);
	fwrite ((char *) & size, sizeof (size), 1, fp);

	for (plane = first_plane; plane != (Plane) 0; plane = pl_next (plane))
		(void) fwrite ((char *) plane, sizeof (struct s_plane), 1, fp);
	
	dummy. nr = -1;

	(void) fwrite ((char *) & dummy, sizeof (struct s_plane), 1, fp);
}

bool BinRestPlanes (fp)
FILE * fp;
{
	Plane dummy;
	Sector sct;
	int size;

	fread ((char *) & size, sizeof (size), 1, fp);
	if (size != sizeof (struct s_plane))
		return False;

	for (;;)
	{
		dummy = (Plane) doalloc ((unsigned) sizeof (struct s_plane));

		fread ((char *) dummy, sizeof (struct s_plane), 1, fp);

		if (pl_nr (dummy) == -1)
		{
			free ((char *) dummy);
			return True;
		}

			/* add plane to sector */
		
		sct = World (pl_xcd (dummy), pl_ycd (dummy), S_DESIG);
		AddPlaneToList (dummy);
		AddPlaneToSector (dummy, sct);
	}
}
