/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/parse/RCS/expr.c,v 5.2 1995/09/08 07:36:07 jpo Exp $
    $Date: 1995/09/08 07:36:07 $
    $Author: jpo $
    $Id: expr.c,v 5.2 1995/09/08 07:36:07 jpo Exp $
    $Locker:  $
    $Log: expr.c,v $
    Revision 5.2  1995/09/08 07:36:07  jpo
    removed # line

 * Revision 5.1  93/03/14  16:50:37  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:02  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:53  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
/* LLgen generated code from source expr.g */
/* $Header: /nexor/users/jpo/xemp/xemp5.0/lib/parse/RCS/expr.c,v 5.2 1995/09/08 07:36:07 jpo Exp $ */
#ifdef LL_DEBUG
#define LL_assert(x) if(!(x)) LL_badassertion("x",__FILE__,__LINE__)
#else
#define LL_assert(x)	/* nothing */
#endif

extern int LLsymb;

#define LL_SAFE(x)	/* Nothing */
#define LL_SSCANDONE(x)	if (LLsymb != x) LLerror(x); else
#define LL_SCANDONE(x)	if (LLsymb != x) LLerror(x); else
#define LL_NOSCANDONE(x) LLscan(x)
#ifdef LL_FASTER
#define LLscan(x)	if ((LLsymb = LL_LEXI()) != x) LLerror(x); else
#endif

# include "Lpars.h"

extern unsigned int LLscnt[];
extern unsigned int LLtcnt[];
extern int LLcsymb;

#define LLsdecr(d)	{LL_assert(LLscnt[d] > 0); LLscnt[d]--;}
#define LLtdecr(d)	{LL_assert(LLtcnt[d] > 0); LLtcnt[d]--;}
#define LLsincr(d)	LLscnt[d]++
#define LLtincr(d)	LLtcnt[d]++
#define LL_LEXI NextToken

#include <stdio.h>
#include <ctype.h>

#include "parser.h"
#include "symtab.h"
#include "token.h"
#include "main.h"
#include "stack.h"

static Stack expr_result;

Stack ParseExpression(str)
const char *str;
{
	Strings strings;
	extern Strings InitStrings();

	parse_error = False;

	strings = InitStrings();
	AddString(strings, str);

	LexInitStrings(strings);
	LLParseExpression();

	FreeStrings(strings);

	if (parse_error == True) {
		DestroyExpression(&expr_result);
		DisplayParseErrors();
	}

	return (Stack) expr_result;
}

void DestroyExpression(expr)
Stack *expr;
{
	Stack ptr, next;

	ptr = (Stack) *expr;

	while (ptr != NULL) {
		if (ptr->type == S_PUSH && ptr->p_type == T_STRING)
			dofree(ptr->p_text);

		next = ptr->next;
		dofree((char *) ptr);
		ptr = next;
	}

	*expr = NULL;
}

static void NewEntry(type, modifier)
int type, modifier;
{
	Stack new = (Stack) doalloc(sizeof(STACK));

	if (expr_result == NULL) {
		expr_result = (Stack) doalloc(sizeof(STACK));
		expr_result->s_tail = expr_result;
		expr_result->type = S_HEAD;
	}

	new->type = type;
	new->next = NULL;

	expr_result->s_tail->next = new;
	expr_result->s_tail = new;
}

static void AddPush(type, mod)
int type, mod;
{
	NewEntry(S_PUSH);

	expr_result->s_tail->p_type	= type;
	expr_result->s_tail->p_modifier = mod;

	switch (type) {
	case T_NUMERIC:
		expr_result->s_tail->p_constant = current_token.t_constant;
		break;
	case T_CHARACTER:
		expr_result->s_tail->p_character = current_token.t_character;
		break;
	case T_STRING:
		expr_result->s_tail->p_text = current_token.t_text;
		break;
	case T_TOKEN:
		expr_result->s_tail->p_token = current_token.value;
	}
}

static void AddCalc(operator, type)
int operator, type;
{
	NewEntry(S_CALC);

	expr_result->s_tail->c_calctype = type;
	expr_result->s_tail->c_operator = operator;
}

static void AddSubExpr(type, old_modifier, new_modifier)
int type, old_modifier, new_modifier;
{
	NewEntry(type);

	expr_result->s_tail->e_old_modifier = old_modifier;
	expr_result->s_tail->e_new_modifier = new_modifier;
}

static char *ModifierName(mod)
int mod;
{
	switch (mod) {
		case MP_RESO:	return "resource";
		case MP_THRES:	return "threshold";
		case MP_SSECT:
		case MP_SECT:	return "sector";
		case MP_SHIP:	return "ship";
		case MP_LAND:	return "land";
		case MP_PLANE:	return "plane";
		case MP_NUKE:	return "nuke";
		default:	return "Pippi Langkous";
	}
}

static char *TypeName(type)
int type;
{
	switch(type) {
		case T_NONE:	  return "none";
		case T_NUMERIC:	  return "numeric";
		case T_BOOLEAN:	  return "boolean";
		case T_CHARACTER: return "character";
		case T_STRING:	  return "string";
		case T_SECTOR:	  return "sector";
		case T_PLAGUE:	  return "plague";
		default:	  return "unknown";
	}
}

void CheckType(type, desired, error_code, argument)
int *type, desired;
{
	if (*type & desired)
		return;

	if (*type != T_NONE) {
		switch(error_code) {
		case E_EVAL:
			ParseError(
				 "Expression type must be numeric or boolean.");
			break;
		case E_OR_TYPE:
			ParseError("Argument to \"OR\" must be boolean.");
			break;
		case E_AND_TYPE:
			ParseError("Argument to \"AND\" must be boolean.");
			break;
		case E_LHS:
			ParseError("Type left of %s must be numerical.",
				   TokenName(argument));
			break;
		case E_RHS:
			ParseError("Type right of %s must be numerical.",
				   TokenName(argument));
			break;
		case E_ARG:
			ParseError("Incorrect argument type \"%s\" to \"%s\".",
				   TypeName(*type), TokenName(argument));
			break;
		case E_MOD:
			ParseError("Expression type to \"%s(...)\" must be boolean or numeric.",
				   ModifierName(argument));
			break;
		case E_SECA1:
			ParseError(
				 "First argument to sector must be numerical.");
			break;
		case E_SECA2:
			ParseError(
				"Second argument to sector must be numerical.");
			break;
		default:
			ParseError("Unexpected parser error type %d.",
				   error_code);
		}
	}

	*type = (desired == T_EVALUATE) ? T_NUMERIC : desired;
}

static void CheckComparison(type1, type2, operator)
int type1, type2;
int operator;
{
	if (type1 != type2)
		ParseError("Type mismatch to operator \"%s\".",
			   TokenName(operator));

	else if (operator == MATCHES && type1 != T_STRING)
		ParseError("Arguments to the \"%s\" operator must be of type string.", TokenName(MATCHES));
	else if ((type1 & T_EVALUATE) == 0 && operator != EQUALS &&
					      operator != UNEQUALS)
		ParseError("Only \"%s\" and \"%s\" are allowed on type \"%s\".",
			   TokenName(EQUALS), TokenName(UNEQUALS),
			   TypeName(type1));
}

static void CheckModChange(old_mod, new_mod)
int old_mod, new_mod;
{
	if (old_mod == MP_SSECT)
		old_mod = MP_SECT;

	switch (new_mod) {
	case MP_RESO:
	case MP_THRES:
		if (old_mod == MP_SECT) return;
		break;
	case MP_SECT:
		if (old_mod != MP_SECT) return;
		break;
	case MP_NUKE:
	case MP_SHIP:
		if (old_mod == MP_SECT || old_mod == MP_PLANE || old_mod == MP_LAND) return;
		break;
	case MP_LAND:
		if (old_mod == MP_SECT || old_mod == MP_PLANE || old_mod == MP_SHIP) return;
		break;
	case MP_PLANE:
		if (old_mod == MP_SECT || old_mod == MP_SHIP || old_mod == MP_LAND)  return;
		break;
	}

	ParseError("A \"%s(...)\" within a \"%s(...)\" expression makes no sense.",
			ModifierName(new_mod), ModifierName(old_mod));
}

static void CheckModifier(mod, symtab)
int mod;
Symtab symtab;
{
	char *token_name;

	if (mod == MP_SSECT)
		mod = MP_SECT;

	if ((mod & symtab->allowed_modifiers) == 0) {
		token_name = TokenName(symtab->token);

		ParseError("\"%s\" is an invalid specification for %s(%s).",
			   token_name, ModifierName(mod), token_name);
	}
}

#if defined(DUMP)
DumpExpression(st)
Stack st;
{
	if (st == NULL)
		return;

	if (st->type == S_CALC)
		printf (" calc(%s, %s)",
			TokenName(st->c_operator), TypeName(st->c_calctype));
	else if (st->type == S_PUSH) {
		printf (" push[");
		switch (st->p_type) {
		case T_NUMERIC:
			printf ("%.2f", st->p_constant);
			break;
		case T_CHARACTER:
			printf ("'%c'", st->p_character);
			break;
		case T_STRING:
			printf ("\"%s\"", st->p_text);
			break;
		case T_TOKEN:
			if (st->p_modifier != MP_NONE)
				printf ("%s.%s", ModifierName(st->p_modifier),
					TokenName(st->p_token));
			else
				printf ("%s", TokenName(st->p_token));
			break;
		default:
			printf ("invalid type: %d", st->p_type);
		}
		printf("]");
	}
	else if (st->type == S_SUBEXPRSTART)
		printf ("A<%s>(", ModifierName(st->p_modifier));
	else if (st->type == S_SUBEXPREND)
		printf (")");

	DumpExpression(st->next);
}
#endif

L0_parse_single_expression (
) {
 int type;
				  expr_result = NULL; 
L2_expression(
&type, MP_SSECT);
{ CheckType(&type, T_EVALUATE, E_EVAL, 0); }
}
L3_parse_expression (
 result) Stack *result; {
 int type;
				  expr_result = NULL;			   
LLread();
L2_expression(
&type, MP_SSECT);
{ *result = expr_result;		   }
{ CheckType(&type, T_EVALUATE, E_EVAL, 0); }
}
L4_parse_type_expression (
 result,type) Stack *result; int *type; {
 expr_result = NULL;			   
LLread();
L2_expression(
&type, MP_SSECT);
{ *result = expr_result;		   }
}
L5_numeric_expression (
 result,function) Stack *result; int function; {
 int type;
				  expr_result = NULL; 
L_2: ;
switch(LLcsymb) {
case /*  CONSTANT  */ 1 : ;
case /*  CHARACTER  */ 2 : ;
case /*  STRING  */ 3 : ;
case /*  MINUS  */ 12 : ;
case /*  BRACKET_OPEN  */ 21 : ;
case /*  SQUARE_BRACKET_OPEN  */ 23 : ;
case /*  NOT  */ 29 : ;
case /*  TRUE  */ 30 : ;
case /*  FALSE  */ 31 : ;
case /*  POPULATION  */ 32 : ;
case /*  ROUND_FUNC  */ 33 : ;
case /*  FLOOR_FUNC  */ 34 : ;
case /*  CEIL_FUNC  */ 35 : ;
case /*  THRESHOLD_MOD  */ 36 : ;
case /*  RESOURCE_MOD  */ 37 : ;
case /*  SECTOR_MOD  */ 38 : ;
case /*  SHIP_MOD  */ 39 : ;
case /*  PLANE_MOD  */ 40 : ;
case /*  NUKE_MOD  */ 41 : ;
case /*  URANIUM  */ 42 : ;
case /*  FOOD  */ 43 : ;
case /*  DUST  */ 44 : ;
case /*  OIL  */ 45 : ;
case /*  IRON  */ 46 : ;
case /*  UW  */ 47 : ;
case /*  GUNS  */ 48 : ;
case /*  BARS  */ 49 : ;
case /*  PETROL  */ 50 : ;
case /*  LCMS  */ 51 : ;
case /*  HCMS  */ 52 : ;
case /*  SHELLS  */ 53 : ;
case /*  RADS  */ 54 : ;
case /*  CURRENT  */ 88 : ;
case /*  WAREHOUSE  */ 89 : ;
case /*  BAD_SECTOR  */ 90 : ;
case /*  XLOC  */ 91 : ;
case /*  YLOC  */ 92 : ;
case /*  OWNER  */ 93 : ;
case /*  DESIGNATION  */ 94 : ;
case /*  NEW_DESIG  */ 95 : ;
case /*  EFFICIENCY  */ 96 : ;
case /*  WORK  */ 97 : ;
case /*  AVAILABLE  */ 98 : ;
case /*  MOBILITY  */ 99 : ;
case /*  CIVILIANS  */ 100 : ;
case /*  MILITARY  */ 101 : ;
case /*  PLANES  */ 102 : ;
case /*  SHIPS  */ 103 : ;
case /*  NUKES  */ 104 : ;
case /*  OCCUPIED  */ 105 : ;
case /*  OWNED  */ 106 : ;
case /*  COAST  */ 107 : ;
case /*  FOOD_USED  */ 108 : ;
case /*  STARVATION  */ 109 : ;
case /*	 MINES */ 110 : ;
case /*  HAS_PLAN  */ 111 : ;
case /*  IS_ACTIVE  */ 112 : ;
case /*  PLAGUE  */ 113 : ;
case /*  PLAGUE_STAGE  */ 114 : ;
case /*  HAPPY  */ 115 : ;
case /*  HAPPY_STATE  */ 116 : ;
case /*  HAPPY_LOYAL  */ 117 : ;
case /*  HAPPY_UNREST  */ 118 : ;
case /*  HAPPY_REVOL  */ 119 : ;
case /*  HAPPY_TERROR  */ 120 : ;
case /*  HAPPY_GUERRE  */ 121 : ;
case /*  PLAGUE_HEALTHY  */ 122 : ;
case /*  PLAGUE_INFECTED  */ 123 : ;
case /*  PLAGUE_DYING  */ 124 : ;
case /*  SPE  */ 125 : ;
case /*  EPU  */ 126 : ;
case /*  IRATE  */ 127 : ;
case /*  CTRATE  */ 128 : ;
case /*  UTRATE  */ 129 : ;
case /*  AMCRATE  */ 130 : ;
case /*  RMCRATE  */ 131 : ;
case /*  FRATE  */ 132 : ;
case /*  HRATE  */ 133 : ;
case /*  CBRATE  */ 134 : ;
case /*  UBRATE  */ 135 : ;
case /*  ERATE  */ 136 : ;
case /*  BERATE  */ 137 : ;
case /*  NAME  */ 138 : ;
case /*  TYPE  */ 139 : ;
case /*  TECH  */ 140 : ;
case /*  NUMBER  */ 141 : ;
case /*  FLEET  */ 142 : ;
case /*  RADAR  */ 143 : ;
case /*  SONAR  */ 144 : ;
case /*  MOVES  */ 145 : ;
case /*  WING  */ 146 : ;
case /*  RANGE  */ 147 : ;
case /*  MAXRANGE  */ 148 : ;
case /*  ATTACK  */ 149 : ;
case /*  DEFENSE  */ 150 : ;
case /*  HARDEN  */ 151 : ;
case /*  LOAD  */ 152 : ;
case /*  STOCKPILE  */ 153 : ;
case /*  TOKEN_EXPRESSION  */ 154 : ;
case /*  TOKEN_NAME  */ 155 : ;
case /*  TOKEN_SECTOR  */ 156 : ;
case /*  LAND_MOD */ 200: ;
case /*  LANDS */ 201 : ;
LLsdecr(0);
L6_simple_expression(
&type, MP_SSECT);
{ CheckType(&type, T_NUMERIC, E_ARG, function); }
{ *result = expr_result;			 }
break;
case /*  TOKEN_NUMERIC_EXPR  */ 158 : ;
L_3: ;
LLsdecr(0);
LL_SSCANDONE(TOKEN_NUMERIC_EXPR);
LLread();
break;
default: if (LLskip()) goto L_2;
goto L_3;
}
}
L7_sector_expression (
 result) Stack *result; {
 expr_result = NULL;		
LLsincr(1);
L8_sector_specification(
);
{ *result = expr_result;	}
}
L9_parse_factor (
 result) Stack *result; {
 int type;
				  expr_result = NULL;		
LLsincr(2);
L10_factor(
&type, MP_SSECT);
{ *result = expr_result;	}
}
L2_expression (
 type,mod) int *type, mod; {
LLtincr(28);
L11_and_list(
type, mod);
L_1 : {switch(LLcsymb) {
case /*  EOFILE  */ 0 : ;
case /*  BRACKET_CLOSE  */ 22 : ;
case /*  FOOD  */ 43 : ;
case /*  DUST  */ 44 : ;
case /*  OIL  */ 45 : ;
case /*  IRON  */ 46 : ;
case /*  UW  */ 47 : ;
case /*  GUNS  */ 48 : ;
case /*  BARS  */ 49 : ;
case /*  PETROL  */ 50 : ;
case /*  LCMS  */ 51 : ;
case /*  HCMS  */ 52 : ;
case /*  SHELLS  */ 53 : ;
case /*  RADS  */ 54 : ;
case /*  BEGIN  */ 55 : ;
case /*  END  */ 56 : ;
case /*  REPEAT  */ 57 : ;
case /*  UNTIL  */ 58 : ;
case /*  WHILE  */ 59 : ;
case /*  IF  */ 61 : ;
case /*  ELSE  */ 63 : ;
case /*  LOOP  */ 64 : ;
case /*  MOVE  */ 65 : ;
case /*  WHERE  */ 67 : ;
case /*  VIA  */ 68 : ;
case /*  TO  */ 69 : ;
case /*  SET_DESIGNATION  */ 70 : ;
case /*  DEMOBILIZE  */ 71 : ;
case /*  ENLIST  */ 73 : ;
case /*  CONVERT  */ 74 : ;
case /*  SHOOT  */ 75 : ;
case /*  TERRITORY  */ 76 : ;
case /*  SET_DISTRIBUTE  */ 77 : ;
case /*  SET_THRESHOLD  */ 78 : ;
case /*  SET_CUTOFF  */ 79 : ;
case /*  SET_DELIVER  */ 80 : ;
case /*  ON_FAIL  */ 81 : ;
case /*  BREAK  */ 82 : ;
case /*  CONTINUE  */ 83 : ;
case /*  ABORT  */ 84 : ;
case /*  STOP  */ 85 : ;
case /*  PRINT  */ 86 : ;
case /*  SEND  */ 87 : ;
case /*  CIVILIANS  */ 100 : ;
case /*  MILITARY  */ 101 : ;
case /*  TOKEN_STATEMENT  */ 157 : ;
case /*  TOKEN_COMMODITY  */ 159 : ;
LLtdecr(28);
break;
default:{int LL_1=LLnext(284);
;if (!LL_1) {
LLtdecr(28);
break;
}
else if (LL_1 & 1) goto L_1;}
case /*  OR  */ 28 : ;
LLtdecr(28);
LLsincr(3);
{ CheckType(type, T_EVALUATE, E_OR_TYPE, 0); }
{ AddCalc(LEFT_OR, T_BOOLEAN);		     }
LLsdecr(3);
LLtincr(28);
for (;;) {
LL_SAFE(OR);
LLread();
L11_and_list(
type, mod);
{ CheckType(type, T_EVALUATE, E_OR_TYPE, 0); }
{ AddCalc(RIGHT_OR, T_BOOLEAN);		     }
{ *type = T_BOOLEAN;			     }
L_2 : {switch(LLcsymb) {
case /*  EOFILE  */ 0 : ;
case /*  BRACKET_CLOSE  */ 22 : ;
case /*  FOOD  */ 43 : ;
case /*  DUST  */ 44 : ;
case /*  OIL  */ 45 : ;
case /*  IRON  */ 46 : ;
case /*  UW  */ 47 : ;
case /*  GUNS  */ 48 : ;
case /*  BARS  */ 49 : ;
case /*  PETROL  */ 50 : ;
case /*  LCMS  */ 51 : ;
case /*  HCMS  */ 52 : ;
case /*  SHELLS  */ 53 : ;
case /*  RADS  */ 54 : ;
case /*  BEGIN  */ 55 : ;
case /*  END  */ 56 : ;
case /*  REPEAT  */ 57 : ;
case /*  UNTIL  */ 58 : ;
case /*  WHILE  */ 59 : ;
case /*  IF  */ 61 : ;
case /*  ELSE  */ 63 : ;
case /*  LOOP  */ 64 : ;
case /*  MOVE  */ 65 : ;
case /*  WHERE  */ 67 : ;
case /*  VIA  */ 68 : ;
case /*  TO  */ 69 : ;
case /*  SET_DESIGNATION  */ 70 : ;
case /*  DEMOBILIZE  */ 71 : ;
case /*  ENLIST  */ 73 : ;
case /*  CONVERT  */ 74 : ;
case /*  SHOOT  */ 75 : ;
case /*  TERRITORY  */ 76 : ;
case /*  SET_DISTRIBUTE  */ 77 : ;
case /*  SET_THRESHOLD  */ 78 : ;
case /*  SET_CUTOFF  */ 79 : ;
case /*  SET_DELIVER  */ 80 : ;
case /*  ON_FAIL  */ 81 : ;
case /*  BREAK  */ 82 : ;
case /*  CONTINUE  */ 83 : ;
case /*  ABORT  */ 84 : ;
case /*  STOP  */ 85 : ;
case /*  PRINT  */ 86 : ;
case /*  SEND  */ 87 : ;
case /*  CIVILIANS  */ 100 : ;
case /*  MILITARY  */ 101 : ;
case /*  TOKEN_STATEMENT  */ 157 : ;
case /*  TOKEN_COMMODITY  */ 159 : ;
break;
default:{int LL_2=LLnext(284);
;if (!LL_2) {
break;
}
else if (LL_2 & 1) goto L_2;}
case /*  OR  */ 28 : ;
continue;
}
}
LLtdecr(28);
break;
}
}
}
}
L11_and_list (
 type,mod) int *type, mod; {
LLtincr(27);
L12_compare_list(
type, mod);
L_1 : {switch(LLcsymb) {
case /*  EOFILE  */ 0 : ;
case /*  BRACKET_CLOSE  */ 22 : ;
case /*  OR  */ 28 : ;
case /*  FOOD  */ 43 : ;
case /*  DUST  */ 44 : ;
case /*  OIL  */ 45 : ;
case /*  IRON  */ 46 : ;
case /*  UW  */ 47 : ;
case /*  GUNS  */ 48 : ;
case /*  BARS  */ 49 : ;
case /*  PETROL  */ 50 : ;
case /*  LCMS  */ 51 : ;
case /*  HCMS  */ 52 : ;
case /*  SHELLS  */ 53 : ;
case /*  RADS  */ 54 : ;
case /*  BEGIN  */ 55 : ;
case /*  END  */ 56 : ;
case /*  REPEAT  */ 57 : ;
case /*  UNTIL  */ 58 : ;
case /*  WHILE  */ 59 : ;
case /*  IF  */ 61 : ;
case /*  ELSE  */ 63 : ;
case /*  LOOP  */ 64 : ;
case /*  MOVE  */ 65 : ;
case /*  WHERE  */ 67 : ;
case /*  VIA  */ 68 : ;
case /*  TO  */ 69 : ;
case /*  SET_DESIGNATION  */ 70 : ;
case /*  DEMOBILIZE  */ 71 : ;
case /*  ENLIST  */ 73 : ;
case /*  CONVERT  */ 74 : ;
case /*  SHOOT  */ 75 : ;
case /*  TERRITORY  */ 76 : ;
case /*  SET_DISTRIBUTE  */ 77 : ;
case /*  SET_THRESHOLD  */ 78 : ;
case /*  SET_CUTOFF  */ 79 : ;
case /*  SET_DELIVER  */ 80 : ;
case /*  ON_FAIL  */ 81 : ;
case /*  BREAK  */ 82 : ;
case /*  CONTINUE  */ 83 : ;
case /*  ABORT  */ 84 : ;
case /*  STOP  */ 85 : ;
case /*  PRINT  */ 86 : ;
case /*  SEND  */ 87 : ;
case /*  CIVILIANS  */ 100 : ;
case /*  MILITARY  */ 101 : ;
case /*  TOKEN_STATEMENT  */ 157 : ;
case /*  TOKEN_COMMODITY  */ 159 : ;
LLtdecr(27);
break;
default:{int LL_3=LLnext(283);
;if (!LL_3) {
LLtdecr(27);
break;
}
else if (LL_3 & 1) goto L_1;}
case /*  AND  */ 27 : ;
LLtdecr(27);
LLsincr(4);
{ CheckType(type, T_EVALUATE, E_AND_TYPE, 0); }
{ AddCalc(LEFT_AND, T_BOOLEAN);		      }
LLsdecr(4);
LLtincr(27);
for (;;) {
LL_SAFE(AND);
LLread();
L12_compare_list(
type, mod);
{ CheckType(type, T_EVALUATE, E_AND_TYPE, 0); }
{ AddCalc(RIGHT_AND, T_BOOLEAN);	      }
{ *type = T_BOOLEAN;			      }
L_2 : {switch(LLcsymb) {
case /*  EOFILE  */ 0 : ;
case /*  BRACKET_CLOSE  */ 22 : ;
case /*  OR  */ 28 : ;
case /*  FOOD  */ 43 : ;
case /*  DUST  */ 44 : ;
case /*  OIL  */ 45 : ;
case /*  IRON  */ 46 : ;
case /*  UW  */ 47 : ;
case /*  GUNS  */ 48 : ;
case /*  BARS  */ 49 : ;
case /*  PETROL  */ 50 : ;
case /*  LCMS  */ 51 : ;
case /*  HCMS  */ 52 : ;
case /*  SHELLS  */ 53 : ;
case /*  RADS  */ 54 : ;
case /*  BEGIN  */ 55 : ;
case /*  END  */ 56 : ;
case /*  REPEAT  */ 57 : ;
case /*  UNTIL  */ 58 : ;
case /*  WHILE  */ 59 : ;
case /*  IF  */ 61 : ;
case /*  ELSE  */ 63 : ;
case /*  LOOP  */ 64 : ;
case /*  MOVE  */ 65 : ;
case /*  WHERE  */ 67 : ;
case /*  VIA  */ 68 : ;
case /*  TO  */ 69 : ;
case /*  SET_DESIGNATION  */ 70 : ;
case /*  DEMOBILIZE  */ 71 : ;
case /*  ENLIST  */ 73 : ;
case /*  CONVERT  */ 74 : ;
case /*  SHOOT  */ 75 : ;
case /*  TERRITORY  */ 76 : ;
case /*  SET_DISTRIBUTE  */ 77 : ;
case /*  SET_THRESHOLD  */ 78 : ;
case /*  SET_CUTOFF  */ 79 : ;
case /*  SET_DELIVER  */ 80 : ;
case /*  ON_FAIL  */ 81 : ;
case /*  BREAK  */ 82 : ;
case /*  CONTINUE  */ 83 : ;
case /*  ABORT  */ 84 : ;
case /*  STOP  */ 85 : ;
case /*  PRINT  */ 86 : ;
case /*  SEND  */ 87 : ;
case /*  CIVILIANS  */ 100 : ;
case /*  MILITARY  */ 101 : ;
case /*  TOKEN_STATEMENT  */ 157 : ;
case /*  TOKEN_COMMODITY  */ 159 : ;
break;
default:{int LL_4=LLnext(283);
;if (!LL_4) {
break;
}
else if (LL_4 & 1) goto L_2;}
case /*  AND  */ 27 : ;
continue;
}
}
LLtdecr(27);
break;
}
}
}
}
L12_compare_list (
 type,mod) int *type, mod; {
 int operator, type2; 
LLsincr(5);
L6_simple_expression(
type, mod);
L_1 : {switch(LLcsymb) {
case /*  EOFILE  */ 0 : ;
case /*  BRACKET_CLOSE  */ 22 : ;
case /*  AND  */ 27 : ;
case /*  OR  */ 28 : ;
case /*  FOOD  */ 43 : ;
case /*  DUST  */ 44 : ;
case /*  OIL  */ 45 : ;
case /*  IRON  */ 46 : ;
case /*  UW  */ 47 : ;
case /*  GUNS  */ 48 : ;
case /*  BARS  */ 49 : ;
case /*  PETROL  */ 50 : ;
case /*  LCMS  */ 51 : ;
case /*  HCMS  */ 52 : ;
case /*  SHELLS  */ 53 : ;
case /*  RADS  */ 54 : ;
case /*  BEGIN  */ 55 : ;
case /*  END  */ 56 : ;
case /*  REPEAT  */ 57 : ;
case /*  UNTIL  */ 58 : ;
case /*  WHILE  */ 59 : ;
case /*  IF  */ 61 : ;
case /*  ELSE  */ 63 : ;
case /*  LOOP  */ 64 : ;
case /*  MOVE  */ 65 : ;
case /*  WHERE  */ 67 : ;
case /*  VIA  */ 68 : ;
case /*  TO  */ 69 : ;
case /*  SET_DESIGNATION  */ 70 : ;
case /*  DEMOBILIZE  */ 71 : ;
case /*  ENLIST  */ 73 : ;
case /*  CONVERT  */ 74 : ;
case /*  SHOOT  */ 75 : ;
case /*  TERRITORY  */ 76 : ;
case /*  SET_DISTRIBUTE  */ 77 : ;
case /*  SET_THRESHOLD  */ 78 : ;
case /*  SET_CUTOFF  */ 79 : ;
case /*  SET_DELIVER  */ 80 : ;
case /*  ON_FAIL  */ 81 : ;
case /*  BREAK  */ 82 : ;
case /*  CONTINUE  */ 83 : ;
case /*  ABORT  */ 84 : ;
case /*  STOP  */ 85 : ;
case /*  PRINT  */ 86 : ;
case /*  SEND  */ 87 : ;
case /*  CIVILIANS  */ 100 : ;
case /*  MILITARY  */ 101 : ;
case /*  TOKEN_STATEMENT  */ 157 : ;
case /*  TOKEN_COMMODITY  */ 159 : ;
LLsdecr(5);
break;
default:{int LL_5=LLnext(-105);
;if (!LL_5) {
LLsdecr(5);
break;
}
else if (LL_5 & 1) goto L_1;}
case /*  EQUALS  */ 14 : ;
case /*  UNEQUALS  */ 15 : ;
case /*  MATCHES  */ 16 : ;
case /*  SMALLER  */ 17 : ;
case /*  LARGER  */ 18 : ;
case /*  SMALLER_EQ  */ 19 : ;
case /*  LARGER_EQ  */ 20 : ;
LLsdecr(5);
LLsincr(6);
L13_compare_operator(
&operator);
LLread();
LLsdecr(6);
L6_simple_expression(
&type2, mod);
{ CheckComparison(*type, type2, operator); }
{ AddCalc(operator, type2);		   }
{ *type = T_BOOLEAN;			   }
}
}
}
L6_simple_expression (
 type,mod) int *type, mod; {
 int operator; 
LLsincr(7);
L14_term(
type, mod);
for (;;) {
L_1 : {switch(LLcsymb) {
case /*  EOFILE  */ 0 : ;
case /*  EQUALS  */ 14 : ;
case /*  UNEQUALS  */ 15 : ;
case /*  MATCHES  */ 16 : ;
case /*  SMALLER  */ 17 : ;
case /*  LARGER  */ 18 : ;
case /*  SMALLER_EQ  */ 19 : ;
case /*  LARGER_EQ  */ 20 : ;
case /*  BRACKET_CLOSE  */ 22 : ;
case /*  SQUARE_BRACKET_CLOSE  */ 24 : ;
case /*  COMMA  */ 25 : ;
case /*  AND  */ 27 : ;
case /*  OR  */ 28 : ;
case /*  FOOD  */ 43 : ;
case /*  DUST  */ 44 : ;
case /*  OIL  */ 45 : ;
case /*  IRON  */ 46 : ;
case /*  UW  */ 47 : ;
case /*  GUNS  */ 48 : ;
case /*  BARS  */ 49 : ;
case /*  PETROL  */ 50 : ;
case /*  LCMS  */ 51 : ;
case /*  HCMS  */ 52 : ;
case /*  SHELLS  */ 53 : ;
case /*  RADS  */ 54 : ;
case /*  BEGIN  */ 55 : ;
case /*  END  */ 56 : ;
case /*  REPEAT  */ 57 : ;
case /*  UNTIL  */ 58 : ;
case /*  WHILE  */ 59 : ;
case /*  IF  */ 61 : ;
case /*  ELSE  */ 63 : ;
case /*  LOOP  */ 64 : ;
case /*  MOVE  */ 65 : ;
case /*  WHERE  */ 67 : ;
case /*  VIA  */ 68 : ;
case /*  TO  */ 69 : ;
case /*  SET_DESIGNATION  */ 70 : ;
case /*  DEMOBILIZE  */ 71 : ;
case /*  NO_RESERVE  */ 72 : ;
case /*  ENLIST  */ 73 : ;
case /*  CONVERT  */ 74 : ;
case /*  SHOOT  */ 75 : ;
case /*  TERRITORY  */ 76 : ;
case /*  SET_DISTRIBUTE  */ 77 : ;
case /*  SET_THRESHOLD  */ 78 : ;
case /*  SET_CUTOFF  */ 79 : ;
case /*  SET_DELIVER  */ 80 : ;
case /*  ON_FAIL  */ 81 : ;
case /*  BREAK  */ 82 : ;
case /*  CONTINUE  */ 83 : ;
case /*  ABORT  */ 84 : ;
case /*  STOP  */ 85 : ;
case /*  PRINT  */ 86 : ;
case /*  SEND  */ 87 : ;
case /*  CIVILIANS  */ 100 : ;
case /*  MILITARY  */ 101 : ;
case /*  TOKEN_STATEMENT  */ 157 : ;
case /*  TOKEN_COMMODITY  */ 159 : ;
break;
default:{int LL_6=LLnext(-147);
;if (!LL_6) {
break;
}
else if (LL_6 & 1) goto L_1;}
case /*  PLUS  */ 11 : ;
case /*  MINUS  */ 12 : ;
LLsincr(8);
L15_term_operator(
&operator);
{ CheckType(type, T_NUMERIC, E_LHS, operator); }
LLread();
LLsdecr(8);
L14_term(
type, mod);
{ CheckType(type, T_NUMERIC, E_RHS, operator); }
{ AddCalc(operator, *type);		       }
continue;
}
}
LLsdecr(7);
break;
}
}
L14_term (
 type,mod) int *type, mod; {
 int operator; 
LLsincr(2);
LLsincr(9);
L10_factor(
type, mod);
for (;;) {
L_1 : {switch(LLcsymb) {
case /*  EOFILE  */ 0 : ;
case /*  PLUS  */ 11 : ;
case /*  MINUS  */ 12 : ;
case /*  EQUALS  */ 14 : ;
case /*  UNEQUALS  */ 15 : ;
case /*  MATCHES  */ 16 : ;
case /*  SMALLER  */ 17 : ;
case /*  LARGER  */ 18 : ;
case /*  SMALLER_EQ  */ 19 : ;
case /*  LARGER_EQ  */ 20 : ;
case /*  BRACKET_CLOSE  */ 22 : ;
case /*  SQUARE_BRACKET_CLOSE  */ 24 : ;
case /*  COMMA  */ 25 : ;
case /*  AND  */ 27 : ;
case /*  OR  */ 28 : ;
case /*  FOOD  */ 43 : ;
case /*  DUST  */ 44 : ;
case /*  OIL  */ 45 : ;
case /*  IRON  */ 46 : ;
case /*  UW  */ 47 : ;
case /*  GUNS  */ 48 : ;
case /*  BARS  */ 49 : ;
case /*  PETROL  */ 50 : ;
case /*  LCMS  */ 51 : ;
case /*  HCMS  */ 52 : ;
case /*  SHELLS  */ 53 : ;
case /*  RADS  */ 54 : ;
case /*  BEGIN  */ 55 : ;
case /*  END  */ 56 : ;
case /*  REPEAT  */ 57 : ;
case /*  UNTIL  */ 58 : ;
case /*  WHILE  */ 59 : ;
case /*  IF  */ 61 : ;
case /*  ELSE  */ 63 : ;
case /*  LOOP  */ 64 : ;
case /*  MOVE  */ 65 : ;
case /*  WHERE  */ 67 : ;
case /*  VIA  */ 68 : ;
case /*  TO  */ 69 : ;
case /*  SET_DESIGNATION  */ 70 : ;
case /*  DEMOBILIZE  */ 71 : ;
case /*  NO_RESERVE  */ 72 : ;
case /*  ENLIST  */ 73 : ;
case /*  CONVERT  */ 74 : ;
case /*  SHOOT  */ 75 : ;
case /*  TERRITORY  */ 76 : ;
case /*  SET_DISTRIBUTE  */ 77 : ;
case /*  SET_THRESHOLD  */ 78 : ;
case /*  SET_CUTOFF  */ 79 : ;
case /*  SET_DELIVER  */ 80 : ;
case /*  ON_FAIL  */ 81 : ;
case /*  BREAK  */ 82 : ;
case /*  CONTINUE  */ 83 : ;
case /*  ABORT  */ 84 : ;
case /*  STOP  */ 85 : ;
case /*  PRINT  */ 86 : ;
case /*  SEND  */ 87 : ;
case /*  CIVILIANS  */ 100 : ;
case /*  MILITARY  */ 101 : ;
case /*  TOKEN_STATEMENT  */ 157 : ;
case /*  TOKEN_COMMODITY  */ 159 : ;
break;
default:{int LL_7=LLnext(-189);
;if (!LL_7) {
break;
}
else if (LL_7 & 1) goto L_1;}
case /*  TIMES  */ 10 : ;
case /*  DIVIDE  */ 13 : ;
LLsincr(2);
L16_factor_operator(
&operator);
{ CheckType(type, T_NUMERIC, E_LHS, operator); }
LLread();
L10_factor(
type, mod);
{ CheckType(type, T_NUMERIC, E_RHS, operator); }
{ AddCalc(operator, *type);		       }
continue;
}
}
LLsdecr(9);
break;
}
}
L10_factor (
 type,mod) int *type, mod; {
L_2: ;
switch(LLcsymb) {
case /*  BRACKET_OPEN  */ 21 : ;
LLsdecr(2);
LLtincr(22);
LL_SAFE(BRACKET_OPEN);
LLread();
L2_expression(
type, mod);
LLtdecr(22);
LL_SCANDONE(BRACKET_CLOSE);
LLread();
break;
case /*  NOT  */ 29 : ;
LL_SAFE(NOT);
LLread();
L10_factor(
type, mod);
{ CheckType(type, T_EVALUATE, E_ARG, NOT);  }
{ AddCalc(NOT, *type);			    }
{ *type = T_BOOLEAN;			    }
break;
case /*  SQUARE_BRACKET_OPEN  */ 23 : ;
case /*  CURRENT  */ 88 : ;
case /*  WAREHOUSE  */ 89 : ;
case /*  TOKEN_SECTOR  */ 156 : ;
LLsdecr(2);
LLsincr(1);
L8_sector_specification(
);
{ *type = T_SECTOR;			    }
LLread();
break;
case /*  ROUND_FUNC  */ 33 : ;
LLsdecr(2);
LLsincr(6);
LLtincr(22);
LL_SAFE(ROUND_FUNC);
LL_NOSCANDONE(BRACKET_OPEN);
LLread();
LLsdecr(6);
L6_simple_expression(
type, mod);
LLtdecr(22);
LL_SCANDONE(BRACKET_CLOSE);
{ CheckType(type, T_NUMERIC, E_ARG,ROUND_FUNC);}
{ AddCalc(ROUND_FUNC, T_NUMERIC);	       }
LLread();
break;
case /*  FLOOR_FUNC  */ 34 : ;
LLsdecr(2);
LLsincr(6);
LLtincr(22);
LL_SAFE(FLOOR_FUNC);
LL_NOSCANDONE(BRACKET_OPEN);
LLread();
LLsdecr(6);
L6_simple_expression(
type, mod);
LLtdecr(22);
LL_SCANDONE(BRACKET_CLOSE);
{ CheckType(type, T_NUMERIC, E_ARG,FLOOR_FUNC);}
{ AddCalc(FLOOR_FUNC, T_NUMERIC);	       }
LLread();
break;
case /*  CEIL_FUNC  */ 35 : ;
LLsdecr(2);
LLsincr(6);
LLtincr(22);
LL_SAFE(CEIL_FUNC);
LL_NOSCANDONE(BRACKET_OPEN);
LLread();
LLsdecr(6);
L6_simple_expression(
type, mod);
LLtdecr(22);
LL_SCANDONE(BRACKET_CLOSE);
{ CheckType(type, T_NUMERIC, E_ARG, CEIL_FUNC);}
{ AddCalc(CEIL_FUNC, T_NUMERIC);	       }
LLread();
break;
case /*  THRESHOLD_MOD  */ 36 : ;
LLsdecr(2);
LLsincr(10);
LLtincr(22);
LL_SAFE(THRESHOLD_MOD);
{ CheckModChange(mod, MP_THRES);	       }
LL_NOSCANDONE(BRACKET_OPEN);
LLread();
L17_token_name(
type, MP_THRES);
LLtdecr(22);
LL_NOSCANDONE(BRACKET_CLOSE);
LLread();
break;
case /*  RESOURCE_MOD  */ 37 : ;
LLsdecr(2);
LLsincr(10);
LLtincr(22);
LL_SAFE(RESOURCE_MOD);
{ CheckModChange(mod, MP_RESO);		       }
LL_NOSCANDONE(BRACKET_OPEN);
LLread();
L17_token_name(
type, MP_RESO);
LLtdecr(22);
LL_NOSCANDONE(BRACKET_CLOSE);
LLread();
break;
case /*  SECTOR_MOD  */ 38 : ;
LLsdecr(2);
LLsincr(11);
LLtincr(22);
LL_SAFE(SECTOR_MOD);
{ CheckModChange(mod, MP_SECT);		       }
{ AddSubExpr(S_SUBEXPRSTART, mod, MP_SECT);    }
LL_NOSCANDONE(BRACKET_OPEN);
LLread();
LLsdecr(11);
L2_expression(
type, MP_SECT);
LLtdecr(22);
LL_SCANDONE(BRACKET_CLOSE);
{ CheckType(type, T_EVALUATE, E_MOD, MP_SECT); }
{ AddSubExpr(S_SUBEXPREND, mod, MP_SECT);      }
LLread();
break;
case /*  SHIP_MOD  */ 39 : ;
LLsdecr(2);
LLsincr(11);
LLtincr(22);
LL_SAFE(SHIP_MOD);
{ CheckModChange(mod, MP_SHIP);		       }
{ AddSubExpr(S_SUBEXPRSTART, mod, MP_SHIP);    }
LL_NOSCANDONE(BRACKET_OPEN);
LLread();
LLsdecr(11);
L2_expression(
type, MP_SHIP);
LLtdecr(22);
LL_SCANDONE(BRACKET_CLOSE);
{ CheckType(type, T_EVALUATE, E_MOD, MP_SHIP); }
{ *type = T_NUMERIC;			       }
{ AddSubExpr(S_SUBEXPREND, mod, MP_SHIP);      }
LLread();
break;
case /*  PLANE_MOD  */ 40 : ;
LLsdecr(2);
LLsincr(11);
LLtincr(22);
LL_SAFE(PLANE_MOD);
{ CheckModChange(mod, MP_PLANE);	       }
{ AddSubExpr(S_SUBEXPRSTART, mod, MP_PLANE);   }
LL_NOSCANDONE(BRACKET_OPEN);
LLread();
LLsdecr(11);
L2_expression(
type, MP_PLANE);
LLtdecr(22);
LL_SCANDONE(BRACKET_CLOSE);
{ CheckType(type, T_EVALUATE, E_MOD, MP_PLANE);}
{ *type = T_NUMERIC;			       }
{ AddSubExpr(S_SUBEXPREND, mod, MP_PLANE);     }
LLread();
break;
case /*  LAND_MOD  */ 200 : ;
LLsdecr(2);
LLsincr(11);
LLtincr(22);
LL_SAFE(LAND_MOD);
{ CheckModChange(mod, MP_LAND);               }
{ AddSubExpr(S_SUBEXPRSTART, mod, MP_LAND);   }
LL_NOSCANDONE(BRACKET_OPEN);
LLread();
LLsdecr(11);
L2_expression(
type, MP_LAND);
LLtdecr(22);
LL_SCANDONE(BRACKET_CLOSE);
{ CheckType(type, T_EVALUATE, E_MOD, MP_LAND);}
{ *type = T_NUMERIC;                           }
{ AddSubExpr(S_SUBEXPREND, mod, MP_LAND);     }
LLread();
break;
case /*  NUKE_MOD  */ 41 : ;
LLsdecr(2);
LLsincr(11);
LLtincr(22);
LL_SAFE(NUKE_MOD);
{ CheckModChange(mod, MP_NUKE);		       }
{ AddSubExpr(S_SUBEXPRSTART, mod, MP_NUKE);    }
LL_NOSCANDONE(BRACKET_OPEN);
LLread();
LLsdecr(11);
L2_expression(
type, MP_NUKE);
LLtdecr(22);
LL_SCANDONE(BRACKET_CLOSE);
{ CheckType(type, T_EVALUATE, E_MOD, MP_NUKE); }
{ *type = T_NUMERIC;			       }
{ AddSubExpr(S_SUBEXPREND, mod, MP_NUKE);      }
LLread();
break;
case /*  MINUS  */ 12 : ;
LL_SAFE(MINUS);
LLread();
L10_factor(
type, mod);
{ CheckType(type, T_NUMERIC, E_ARG, MINUS);    }
{ AddCalc(NEGATE, T_NUMERIC);		       }
break;
case /*  POPULATION  */ 32 : ;
case /*  URANIUM  */ 42 : ;
case /*  FOOD  */ 43 : ;
case /*  DUST  */ 44 : ;
case /*  OIL  */ 45 : ;
case /*  IRON  */ 46 : ;
case /*  UW  */ 47 : ;
case /*  GUNS  */ 48 : ;
case /*  BARS  */ 49 : ;
case /*  PETROL  */ 50 : ;
case /*  LCMS  */ 51 : ;
case /*  HCMS  */ 52 : ;
case /*  SHELLS  */ 53 : ;
case /*  RADS  */ 54 : ;
case /*  BAD_SECTOR  */ 90 : ;
case /*  XLOC  */ 91 : ;
case /*  YLOC  */ 92 : ;
case /*  OWNER  */ 93 : ;
case /*  DESIGNATION  */ 94 : ;
case /*  NEW_DESIG  */ 95 : ;
case /*  EFFICIENCY  */ 96 : ;
case /*  WORK  */ 97 : ;
case /*  AVAILABLE  */ 98 : ;
case /*  MOBILITY  */ 99 : ;
case /*  CIVILIANS  */ 100 : ;
case /*  MILITARY  */ 101 : ;
case /*  PLANES  */ 102 : ;
case /*  SHIPS  */ 103 : ;
case /*  NUKES  */ 104 : ;
case /*  OCCUPIED  */ 105 : ;
case /*  OWNED  */ 106 : ;
case /*  COAST  */ 107 : ;
case /*  FOOD_USED  */ 108 : ;
case /*  STARVATION  */ 109 : ;
case /*	 MINES */ 110 : ;
case /*  HAS_PLAN  */ 111 : ;
case /*  IS_ACTIVE  */ 112 : ;
case /*  PLAGUE  */ 113 : ;
case /*  PLAGUE_STAGE  */ 114 : ;
case /*  HAPPY  */ 115 : ;
case /*  HAPPY_STATE  */ 116 : ;
case /*  HAPPY_LOYAL  */ 117 : ;
case /*  HAPPY_UNREST  */ 118 : ;
case /*  HAPPY_REVOL  */ 119 : ;
case /*  HAPPY_TERROR  */ 120 : ;
case /*  HAPPY_GUERRE  */ 121 : ;
case /*  PLAGUE_HEALTHY  */ 122 : ;
case /*  PLAGUE_INFECTED  */ 123 : ;
case /*  PLAGUE_DYING  */ 124 : ;
case /*  NAME  */ 138 : ;
case /*  TYPE  */ 139 : ;
case /*  TECH  */ 140 : ;
case /*  NUMBER  */ 141 : ;
case /*  FLEET  */ 142 : ;
case /*  RADAR  */ 143 : ;
case /*  SONAR  */ 144 : ;
case /*  MOVES  */ 145 : ;
case /*  WING  */ 146 : ;
case /*  RANGE  */ 147 : ;
case /*  MAXRANGE  */ 148 : ;
case /*  ATTACK  */ 149 : ;
case /*  DEFENSE  */ 150 : ;
case /*  HARDEN  */ 151 : ;
case /*  LOAD  */ 152 : ;
case /*  STOCKPILE  */ 153 : ;
case /*  TOKEN_NAME  */ 155 : ;
case /*  LANDS */ 201 : ;
LLsdecr(2);
LLsincr(10);
L17_token_name(
type, mod);
LLread();
break;
case /*  SPE  */ 125 : ;
case /*  EPU  */ 126 : ;
case /*  IRATE  */ 127 : ;
case /*  CTRATE  */ 128 : ;
case /*  UTRATE  */ 129 : ;
case /*  AMCRATE  */ 130 : ;
case /*  RMCRATE  */ 131 : ;
case /*  FRATE  */ 132 : ;
case /*  HRATE  */ 133 : ;
case /*  CBRATE  */ 134 : ;
case /*  UBRATE  */ 135 : ;
case /*  ERATE  */ 136 : ;
case /*  BERATE  */ 137 : ;
LLsdecr(2);
L18_empire_constant(
type);
LLread();
break;
case /*  CONSTANT  */ 1 : ;
case /*  CHARACTER  */ 2 : ;
case /*  STRING  */ 3 : ;
case /*  TRUE  */ 30 : ;
case /*  FALSE  */ 31 : ;
LLsdecr(2);
L19_factor_constant(
type);
LLread();
break;
case /*  TOKEN_EXPRESSION  */ 154 : ;
L_3: ;
LLsdecr(2);
LL_SSCANDONE(TOKEN_EXPRESSION);
LLread();
break;
default: if (LLskip()) goto L_2;
goto L_3;
}
}
L19_factor_constant (
 type) int *type; {
switch(LLcsymb) {
default:
LL_SAFE(TRUE);
{ *type = T_BOOLEAN;		      }
{ current_token.t_constant = D1;      }
{ AddPush(T_NUMERIC, MP_NONE);	      }
break;
case /*  FALSE  */ 31 : ;
LL_SAFE(FALSE);
{ *type = T_BOOLEAN;		      }
{ current_token.t_constant = D0;      }
{ AddPush(T_NUMERIC, MP_NONE);	      }
break;
case /*  CHARACTER  */ 2 : ;
LL_SAFE(CHARACTER);
{ *type = T_CHARACTER;		      }
{ AddPush(T_CHARACTER, MP_NONE);      }
break;
case /*  STRING  */ 3 : ;
LL_SAFE(STRING);
{ *type = T_STRING;		      }
{ AddPush(T_STRING, MP_NONE);	      }
break;
case /*  CONSTANT  */ 1 : ;
LL_SAFE(CONSTANT);
{ *type = T_NUMERIC;		      }
{ AddPush(T_NUMERIC, MP_NONE);	      }
break;
}
}
L17_token_name (
 type,mod) int *type, mod; {
L_2: ;
switch(LLcsymb) {
case /*  POPULATION  */ 32 : ;
case /*  URANIUM  */ 42 : ;
case /*  FOOD  */ 43 : ;
case /*  DUST  */ 44 : ;
case /*  OIL  */ 45 : ;
case /*  IRON  */ 46 : ;
case /*  UW  */ 47 : ;
case /*  GUNS  */ 48 : ;
case /*  BARS  */ 49 : ;
case /*  PETROL  */ 50 : ;
case /*  LCMS  */ 51 : ;
case /*  HCMS  */ 52 : ;
case /*  SHELLS  */ 53 : ;
case /*  RADS  */ 54 : ;
case /*  BAD_SECTOR  */ 90 : ;
case /*  XLOC  */ 91 : ;
case /*  YLOC  */ 92 : ;
case /*  OWNER  */ 93 : ;
case /*  DESIGNATION  */ 94 : ;
case /*  NEW_DESIG  */ 95 : ;
case /*  EFFICIENCY  */ 96 : ;
case /*  WORK  */ 97 : ;
case /*  AVAILABLE  */ 98 : ;
case /*  MOBILITY  */ 99 : ;
case /*  CIVILIANS  */ 100 : ;
case /*  MILITARY  */ 101 : ;
case /*  PLANES  */ 102 : ;
case /*  SHIPS  */ 103 : ;
case /*  NUKES  */ 104 : ;
case /*  OCCUPIED  */ 105 : ;
case /*  OWNED  */ 106 : ;
case /*  COAST  */ 107 : ;
case /*  FOOD_USED  */ 108 : ;
case /*  STARVATION  */ 109 : ;
case /*	 MINES */ 110 : ;
case /*  HAS_PLAN  */ 111 : ;
case /*  IS_ACTIVE  */ 112 : ;
case /*  PLAGUE  */ 113 : ;
case /*  PLAGUE_STAGE  */ 114 : ;
case /*  HAPPY  */ 115 : ;
case /*  HAPPY_STATE  */ 116 : ;
case /*  HAPPY_LOYAL  */ 117 : ;
case /*  HAPPY_UNREST  */ 118 : ;
case /*  HAPPY_REVOL  */ 119 : ;
case /*  HAPPY_TERROR  */ 120 : ;
case /*  HAPPY_GUERRE  */ 121 : ;
case /*  PLAGUE_HEALTHY  */ 122 : ;
case /*  PLAGUE_INFECTED  */ 123 : ;
case /*  PLAGUE_DYING  */ 124 : ;
case /*  NAME  */ 138 : ;
case /*  TYPE  */ 139 : ;
case /*  TECH  */ 140 : ;
case /*  NUMBER  */ 141 : ;
case /*  FLEET  */ 142 : ;
case /*  RADAR  */ 143 : ;
case /*  SONAR  */ 144 : ;
case /*  MOVES  */ 145 : ;
case /*  WING  */ 146 : ;
case /*  RANGE  */ 147 : ;
case /*  MAXRANGE  */ 148 : ;
case /*  ATTACK  */ 149 : ;
case /*  DEFENSE  */ 150 : ;
case /*  HARDEN  */ 151 : ;
case /*  LOAD  */ 152 : ;
case /*  STOCKPILE  */ 153 : ;
case /*  LANDS */ 201 : ;
LLsdecr(10);
{ CheckModifier(mod, current_token.symtab); }
{ *type = current_token.symtab->type;	    }
{ AddPush(T_TOKEN, mod);		    }
break;
case /*  TOKEN_NAME  */ 155 : ;
L_3: ;
LLsdecr(10);
LL_SSCANDONE(TOKEN_NAME);
{ *type = T_NONE;			    }
{ AddPush(T_TOKEN, MP_NONE);		    }
break;
default: if (LLskip()) goto L_2;
goto L_3;
}
}
L18_empire_constant (
 type) int *type; {
{ *type = current_token.symtab->type; }
{ AddPush(T_TOKEN, MP_NONE);	      }
}
L8_sector_specification (
) {
 int type;				    
L_2: ;
switch(LLcsymb) {
case /*  WAREHOUSE  */ 89 : ;
LLsdecr(1);
LL_SAFE(WAREHOUSE);
{ AddPush(T_TOKEN, MP_SECT);		    }
break;
case /*  CURRENT  */ 88 : ;
LLsdecr(1);
LL_SAFE(CURRENT);
{ AddPush(T_TOKEN, MP_SECT);		    }
break;
case /*  SQUARE_BRACKET_OPEN  */ 23 : ;
LLsdecr(1);
LLtincr(25);
LLsincr(6);
LLtincr(24);
LL_SAFE(SQUARE_BRACKET_OPEN);
LLread();
L6_simple_expression(
&type, MP_SECT);
LLtdecr(25);
LL_SCANDONE(COMMA);
{ CheckType(&type, T_NUMERIC, E_SECA1, 0);  }
LLread();
LLsdecr(6);
L6_simple_expression(
&type, MP_SECT);
{ CheckType(&type, T_NUMERIC, E_SECA2, 0);  }
LLtdecr(24);
LL_SCANDONE(SQUARE_BRACKET_CLOSE);
{ AddCalc(SECTOR_FUNC, T_SECTOR);	    }
break;
case /*  TOKEN_SECTOR  */ 156 : ;
L_3: ;
LLsdecr(1);
LL_SSCANDONE(TOKEN_SECTOR);
break;
default: if (LLskip()) goto L_2;
goto L_3;
}
}
L16_factor_operator (
 operator) int *operator; {
{ *operator = current_token.value; }
}
L15_term_operator (
 operator) int *operator; {
{ *operator = current_token.value; }
}
L13_compare_operator (
 operator) int *operator; {
{ *operator = current_token.value; }
}


