/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/parse/RCS/LLgen.c,v 5.2 1995/09/16 15:43:42 jpo Exp $
    $Date: 1995/09/16 15:43:42 $
    $Author: jpo $
    $Id: LLgen.c,v 5.2 1995/09/16 15:43:42 jpo Exp $
    $Locker:  $
    $Log: LLgen.c,v $
    Revision 5.2  1995/09/16 15:43:42  jpo
    removed # line stuff

    Revision 5.1  1993/03/14 16:50:35  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:23:02  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:53  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
/* LLgen generated code from source LLgen.g */
/* $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/parse/RCS/LLgen.c,v 5.2 1995/09/16 15:43:42 jpo Exp $ */
#ifdef LL_DEBUG
#define LL_assert(x) if(!(x)) LL_badassertion("x",__FILE__,__LINE__)
#else
#define LL_assert(x)	/* nothing */
#endif

extern int LLsymb;

#define LL_SAFE(x)	/* Nothing */
#define LL_SSCANDONE(x)	if (LLsymb != x) LLerror(x); else
#define LL_SCANDONE(x)	if (LLsymb != x) LLerror(x); else
#define LL_NOSCANDONE(x) LLscan(x)
#ifdef LL_FASTER
#define LLscan(x)	if ((LLsymb = LL_LEXI()) != x) LLerror(x); else
#endif

# include "Lpars.h"

extern unsigned int LLscnt[];
extern unsigned int LLtcnt[];
extern int LLcsymb;

#define LLsdecr(d)	{LL_assert(LLscnt[d] > 0); LLscnt[d]--;}
#define LLtdecr(d)	{LL_assert(LLtcnt[d] > 0); LLtcnt[d]--;}
#define LLsincr(d)	LLscnt[d]++
#define LLtincr(d)	LLtcnt[d]++
#define LL_LEXI NextToken


#include "parser.h"
#include "symtab.h"
#include "token.h"
#include "Lpars.h"

extern Stack expr_result;
bool parse_error;

char *TokenName(token_value)
int token_value;
{
	char token_buf[20];
	Symtab list;
	
	if (token_value == LEFT_AND || token_value == RIGHT_AND)
		token_value = AND;

	if (token_value == LEFT_OR || token_value == RIGHT_OR)
		token_value = OR;

	if (token_value == CONSTANT)    return "constant";
	if (token_value == CHARACTER)   return "character";
	if (token_value == STRING)      return "string";
	if (token_value == NEGATE)      return "negate";
	if (token_value == SECTOR_FUNC) return "sector";
	if (token_value == EOFILE)      return "eofile";
	
	for (list = text_symtab; list->name != (char *) 0; list++)
		if (list->token == token_value)
			return list->name;

	for (list = special_chars_symtab; list->name != (char *) 0; list++)
		if (list->token == token_value)
			return list->name;

	sprintf(token_buf, "Token %d", token_value);

	return token_buf;
}

void LLmessage(msg)
int msg;
{
	parse_error = True;

	switch (msg) {
	case 0:
		ParseError("Unexpected %s.", TokenName(LLsymb));
		break;
	case -1:
		ParseError("Garbage at end of file.");
		break;
	default:
		switch (msg) {
		case TOKEN_EXPRESSION:
			ParseError("Expression expected.");
			break;
		case TOKEN_NAME:
			ParseError("Commodity or resource expected.");
			break;
		case TOKEN_SECTOR:
			ParseError("Sector expression expected.");
			break;
		case TOKEN_STATEMENT:
			ParseError("Statement expected.");
			break;
		case TOKEN_NUMERIC_EXPR:
			ParseError("NUmeric expression expected.");
			break;
		case TOKEN_COMMODITY:
			ParseError("Commodity expected.");
			break;
		case TOKEN_CLAUSE:
			ParseError("ON_ERROR fail clause expected.");
			break;
		default:
			ParseError("%s expected.", TokenName(msg));
		}

		stacked_token.value = LLsymb;
	}
}


