/*
	$Header: /nexor/users/jpo/xemp/xemp5.0/lib/land/RCS/mission.c,v 1.4 1996/01/29 08:17:05 jpo Exp $
	$Date: 1996/01/29 08:17:05 $
	$Author: jpo $
	$Id: mission.c,v 1.4 1996/01/29 08:17:05 jpo Exp $
	$Locker:  $
	$Log: mission.c,v $
	Revision 1.4  1996/01/29 08:17:05  jpo
	New menu stuff

	Revision 1.3  1995/09/10 17:40:12  jpo
	Add army support and display

	Revision 1.2  1995/09/08 07:20:12  jpo
	added land mission support

 * Revision 1.1  93/03/14  16:47:59  etienne
 * Initial revision
 * 
*/

#include "main.h"
#include "version.h"
#include "sector.h"
#include "land.h"

static const char *mission_types[] = {
	"Delete Mission",
	"Interdict",
	"Reserve",
	(char *)0
};
#define MISSION_MAX	3
static const char type2mission[] = "\0ir";


static bool LandMission _PROTO((const char *lands, int range,
				Sector sct, char *missp, int *rangep));

static bool LandMission (lands, range, sct, missp, rangep)
const char *lands;
int range;
Sector sct;
char *missp;
int *rangep;
{
	int i;
	Strings strings;
	char *answer;

	strings = InitStrings ();
	AddStringsID (strings, mission_types, MISSION_MAX, 0);
	i = ChooseMenu (strings, "Mission Type?", map_win, 5, 5, NULL);
	FreeStrings (strings);

	if (i < 0 || interrupt) {
		interrupt = False;
		Message ("Set mission cancelled");
		return False;
	}
	
	if (i == 0) {
		*missp = type2mission[i];
		*rangep = 0;
		FeedCommand (Fmt ("mission land %s c", lands), PRINT);
		return True;
	}
	answer = InputAtMessage (Fmt  ("Range [%d]: ",range),
				 3, GS_PNUMBER);
	if (interrupt || answer == (char *)0) {
		interrupt = False;
		Message ("Mission cancelled");
		return False;
	}
	if (*answer != '\0')
		range = atoi (answer);
	*missp = type2mission[i];
	FeedCommand (Fmt ("mission land %s %c %s %d",
			  lands, *missp,
			  CrdStr(sct), range), PRINT);
	*rangep = range;
	return True;
}

void LMission (land)
Land land;
{
	int range;
	char miss;

	if (!ld_owned (land)) {
		Message ("Not your unit !!");
		return;
	}
	range = LandFireRange (land);
	if (LandMission (Fmt ("%d", ld_nr(land)),
			 range,
			 LandSector (land),
			 &miss,
			 &range) == True) {
		set_ld_mission (land, miss);
		land -> radius = range;
	}
	return;
}

void FScanLandMission (list, flag)
const char *list;
int flag;
{
	FeedEmpire (Fmt ("mission land %s q", list), flag);

	ScanLandMission (flag);
	(void) WaitForPrompt (flag);
}

void ScanLandMission (flag)
int flag;
{
	char *ptr, *ind;
	int mind, lno;
	Land land;

	if (EmpireStatus () != E_PRINTING)
		return;
	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning land missions");

	ptr = ReadEmpire (DONT_PRINT);
	if ((ind = StrStr (ptr, "mission")) == NULL) {
		PrintAtEmpire (Fmt ("Mission scan failed on %s", ptr));
		return;
	}
	mind = ind - ptr;
	
	for (;;) {
		ptr = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING) {
			if (flag == PRINT)
				PrintAtEmpire (ptr);
			return;
		}
		
		if ((ind = index (ptr, '#')) == NULL)
			continue;

		ind ++;
		if (!ScanDigit ((ConstVP)&ind, &lno) ||
		    (land = NrToLand (lno)) == (Land)0) {
			PrintAtEmpire (Fmt ("#%d Unknown land (rescan lands!)",
					    lno));
			Bell ();
			(void) EmpireMore ();
			continue;
		}

		switch (ptr[mind]) {
		    case 'i':
		    case 'r':
			set_ld_mission (land, ptr[mind]);
			break;
		    case 'h':
			set_ld_mission (land, '\0');
			break;
		    default:
			PrintAtEmpire (Fmt ("Unknown mission type %s",
					    ptr + mind));
			Bell ();
			break;
		}
	}
}

const char *ArmyHasMission (army)
char army;
{
	Land ptr;
	char mistype = '~';	/* bogus */
	const char *cp;

	for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
		if (ptr-> army == army && ld_mission(ptr) != mistype) {
			if (mistype == '~')
				mistype = ld_mission(ptr);
			else
				return "Mixed";
		}
	if (mistype == '\0')
		return "None";

	for (cp = type2mission + 1; *cp; cp++)
		if (*cp == mistype)
			return mission_types[cp - type2mission];
	return "Unknown";
}

void ChangeArmyMission (army)
char army;
{
	Land ptr;
	int range = 0;
	char miss;
	
	if (ArmyEmpty (army) == True) {
		Message ("No ships in army!");
		return;
	}
	if (ArmyColocated (army) != True) {
		Message ("Army not colocated");
		return;
	}
	for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
		if (ptr-> army == army) {
			int r = LandFireRange (ptr);
			if (r > range)
				range = r;
		}

	if (LandMission (Fmt ("%c", army),
			 range,
			 ArmySector (army),
			 &miss, &range) == True) {
		const char *cp;

		for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
			if (ptr-> army == army) {
				set_ld_mission (ptr, miss);
				ptr -> radius = range;
			}
		Message (Fmt ("Army %c now on %s mission",
			      army,
			      ArmyHasMission (army)));
		CensusArmy (army);
	}
}
